/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackend;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendZipData;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public class DbSrcBackendFiles {
    private static final Logger LOG = Logger.getInstance(DbSrcBackendFiles.class);
    private final @SystemDependent String myRoot;
    private final DbSrcBackend.Listener myListener;
    private final ReadWriteLock myLock;
    private final Locker myWriteLocker;
    private final Locker myReadLocker;
    private final Map<ObjectPath, DbSrcStorageDsMetadata.MetaData> myMetaDataCache;
    private final Map<ObjectPath, DbSrcBackendZipData> myZipDataCache;

    public DbSrcBackendFiles(@SystemDependent @NotNull String root2, @NotNull DbSrcBackend.Listener listener) {
        if (root2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(1);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myWriteLocker = new Locker(this.myLock.writeLock());
        this.myReadLocker = new Locker(this.myLock.readLock());
        this.myMetaDataCache = ContainerUtil.createConcurrentSoftValueMap();
        this.myZipDataCache = ContainerUtil.newConcurrentMap();
        this.myRoot = root2;
        this.myListener = listener;
    }

    @NotNull
    public @SystemDependent String getRoot() {
        String string = this.myRoot;
        if (string == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public DbSrcBackend.Listener getListener() {
        DbSrcBackend.Listener listener = this.myListener;
        if (listener == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(3);
        }
        return listener;
    }

    @NotNull
    public Locker readLock() {
        Locker locker = this.myReadLocker.lock();
        if (locker == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(4);
        }
        return locker;
    }

    @NotNull
    public Locker writeLock() {
        Locker locker = this.myWriteLocker.lock();
        if (locker == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(5);
        }
        return locker;
    }

    @Nullable
    public Pair<List<ObjectPath>, List<ObjectPath>> list(@Nullable ObjectPath object, @NotNull ObjectKind group2, boolean staging) {
        Path[] paths;
        Path path;
        if (group2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(6);
        }
        if (!Files.isDirectory(path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, group2, null), new LinkOption[0])) {
            return null;
        }
        try {
            Path[] pathArray = null;
            try (Stream<Path> list = Files.list(path);){
                paths = (Path[])list.toArray(Path[]::new);
            }
            catch (Throwable object2) {
                pathArray = object2;
                throw object2;
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        HashMap names = ContainerUtil.newHashMap();
        for (Path p : paths) {
            String name = p.getFileName().toString();
            if (!name.endsWith(".meta")) continue;
            name = StringUtil.trimEnd((String)name, (String)".meta");
            try {
                byte[] bytes = Files.readAllBytes(p);
                Pair<String, String> id = DbSrcBackendUtils.extractNameAndIdentity(bytes);
                if (id == null) continue;
                names.put(name, id);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        ArrayList files = ContainerUtil.newArrayList();
        ArrayList dirs = ContainerUtil.newArrayList();
        for (Path p : paths) {
            Pair id;
            String name = p.getFileName().toString();
            boolean dir = Files.isDirectory(p, new LinkOption[0]);
            if (!dir) {
                if (name.endsWith(".sql")) {
                    name = StringUtil.trimEnd((String)name, (String)".sql");
                } else if (name.endsWith(".zip")) {
                    name = StringUtil.trimEnd((String)name, (String)".zip");
                    dir = true;
                } else {
                    if (!name.endsWith(".zip.tmp")) continue;
                    name = StringUtil.trimEnd((String)name, (String)".zip.tmp");
                    dir = true;
                }
            }
            if ((id = (Pair)names.get(name)) == null) continue;
            (dir ? dirs : files).add(DbSrcBackendUtils.createPath(object, (String)id.first, group2, (String)id.second));
        }
        return Pair.create((Object)dirs, (Object)files);
    }

    @NotNull
    public Iterable<ObjectKind> listGroups(@Nullable ObjectPath object, boolean staging) {
        Object[] paths;
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbSrcBackendFiles.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        try (Stream<Path> list = Files.list(path);){
            paths = (Path[])list.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toArray(Path[]::new);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbSrcBackendFiles.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        Set set = JBIterable.of((Object[])paths).filterMap(p -> DbSrcUtils.findKind(p.getFileName().toString())).toSet();
        if (set == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(9);
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(@Nullable ObjectPath object, boolean staging) {
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> list = Files.list(path);){
            boolean bl = list.anyMatch(p -> Files.isDirectory(p, new LinkOption[0]));
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group2, boolean staging) {
        Path path;
        if (group2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(10);
        }
        if (!Files.isDirectory(path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null), new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> list = Files.list(path);){
            String code = group2.code();
            boolean bl = list.anyMatch(p -> Files.isDirectory(p, new LinkOption[0]) && code.equals(p.getFileName().toString()));
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(@Nullable ObjectPath object, boolean staging) throws IOException {
        ObjectPath root2 = object;
        try (Locker lock = this.writeLock();){
            root2 = object == null ? null : this.findCascadeRemovalRoot(object, staging);
            Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, root2, null, null);
            if (!staging) {
                if (object != null && DbSrcBackendFiles.isZipRoot(object.kind)) {
                    DbSrcBackendZipData zip = this.myZipDataCache.remove(object);
                    if (zip != null) {
                        zip.closeWriter();
                    }
                } else {
                    for (DbSrcBackendZipData zip : DbSrcBackendUtils.clearAndGet(this.myZipDataCache.values())) {
                        zip.closeWriter();
                    }
                }
                this.removeCachedMetaDataRec(root2);
            }
            FileUtil.delete((File)path.toFile());
            if (root2 != null) {
                Files.deleteIfExists(path.resolveSibling(path.getFileName() + ".meta"));
                Files.deleteIfExists(path.resolveSibling(path.getFileName() + ".sql"));
            }
        }
        finally {
            this.getListener().dirChanged(root2, staging, true);
            if (root2 != null) {
                this.getListener().fileChanged(root2, staging);
            }
        }
    }

    void removeCachedMetaDataRec(@Nullable ObjectPath root2) {
        if (root2 == null) {
            this.myMetaDataCache.clear();
        } else {
            this.myMetaDataCache.keySet().removeIf(o -> root2.isAncestorOf(o, false));
        }
    }

    @Nullable
    public byte[] getContent(@NotNull ObjectPath object, boolean staging) throws IOException {
        Path path;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(11);
        }
        if (Files.isRegularFile(path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, ".sql"), new LinkOption[0])) {
            try (Locker lock = this.readLock();){
                byte[] byArray = FileUtil.loadFileBytes((File)path.toFile());
                return byArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputStream getContentInputStream(@NotNull ObjectPath object, boolean staging) throws IOException {
        Path path;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(12);
        }
        if (Files.isRegularFile(path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, ".sql"), new LinkOption[0])) {
            DbSrcBackendUtils.InputStreamWrapper result2 = null;
            final Locker lock = this.readLock();
            try {
                DbSrcBackendUtils.InputStreamWrapper inputStreamWrapper = result2 = new DbSrcBackendUtils.InputStreamWrapper(Files.newInputStream(path, new OpenOption[0])){

                    @Override
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            lock.close();
                        }
                    }
                };
                return inputStreamWrapper;
            }
            finally {
                if (result2 == null) {
                    lock.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(@NotNull ObjectPath object, boolean staging, @Nullable byte[] content) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(13);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, ".sql");
        try (Locker lock = this.writeLock();){
            if (content == null) {
                Files.deleteIfExists(path);
            } else {
                FileUtil.writeToFile((File)path.toFile(), (byte[])content);
            }
        }
        finally {
            this.getListener().fileChanged(object, staging);
        }
    }

    @Nullable
    public ObjectPath findCascadeRemovalRoot(@NotNull ObjectPath object, boolean staging) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(14);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null);
        return this.findCascadeRemovalRootImpl(path, object, staging);
    }

    @Nullable
    private ObjectPath findCascadeRemovalRootImpl(@NotNull Path path, @NotNull ObjectPath object, boolean staging) {
        Path group2;
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(15);
        }
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(16);
        }
        if ((group2 = path.getParent()) == null) {
            return object;
        }
        if (DbSrcBackendFiles.hasOtherChild(group2, object)) {
            return object;
        }
        Path parentPath = group2.getParent();
        if (parentPath == null) {
            return object;
        }
        if (DbSrcBackendFiles.hasOtherGroup(parentPath, object.kind)) {
            return object;
        }
        ObjectPath parent = object.parent;
        if (parent == null) {
            return null;
        }
        if (this.hasSrcOrMeta(parentPath, object, staging)) {
            return object;
        }
        return this.findCascadeRemovalRootImpl(parentPath, parent, staging);
    }

    boolean hasSrcOrMeta(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(17);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, false, object, null, null);
        return this.hasSrcOrMeta(path, object, false);
    }

    private boolean hasSrcOrMeta(@NotNull Path path, @NotNull ObjectPath object, boolean staging) {
        Path sqlPath;
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(18);
        }
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(19);
        }
        return Files.exists(sqlPath = path.resolveSibling(path.getFileName().toString() + ".sql"), new LinkOption[0]) || !staging && !DbSrcStorageDsMetadata.MetaData.isEmpty(this.getMetaData(object));
    }

    void dropSrcAndMeta(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(20);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, false, object, null, null);
        Files.deleteIfExists(path.resolveSibling(path.getFileName() + ".meta"));
        Files.deleteIfExists(path.resolveSibling(path.getFileName() + ".sql"));
    }

    public void resetCaches() {
        this.finish();
        this.myMetaDataCache.clear();
        this.myZipDataCache.clear();
    }

    public void finish() {
        try (Locker lock = this.writeLock();){
            for (DbSrcBackendZipData data : this.myZipDataCache.values()) {
                data.closeWriter();
            }
        }
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getStagingMetaData(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(21);
        }
        return Files.isRegularFile(DbSrcBackendUtils.getDir(this.myRoot, true, object, null, ".meta"), new LinkOption[0]) ? DbSrcStorageDsMetadata.MetaData.EMPTY : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() {
        try (Locker lock = this.writeLock();){
            for (DbSrcBackendZipData zip : DbSrcBackendUtils.clearAndGet(this.myZipDataCache.values())) {
                zip.closeWriter();
            }
            FileUtil.delete((File)new File(this.myRoot));
        }
        finally {
            this.getListener().dirChanged(null, true, true);
            this.getListener().dirChanged(null, false, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasOtherChild(@NotNull Path group2, @NotNull ObjectPath object) {
        if (group2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(22);
        }
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(23);
        }
        if (!Files.isDirectory(group2, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> list = Files.list(group2);){
            boolean foundObj = false;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                boolean isMe;
                Path p = (Path)it.next();
                String name = p.getFileName().toString();
                if (!Files.isRegularFile(p, new LinkOption[0]) || !name.endsWith(".meta")) continue;
                if (foundObj) {
                    boolean bl = true;
                    return bl;
                }
                String curName = DbSrcBackendUtils.getSimpleName(object.getName(), object.getIdentity());
                boolean bl = isMe = curName.length() + ".meta".length() == name.length() && name.startsWith(curName);
                if (!isMe) {
                    boolean bl2 = true;
                    return bl2;
                }
                foundObj = true;
            }
            return false;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasOtherGroup(@NotNull Path path, @NotNull ObjectKind group2) {
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(24);
        }
        if (group2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(25);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> list = Files.list(path);){
            Path p;
            String code = group2.code();
            Iterator it = list.iterator();
            do {
                if (!it.hasNext()) return false;
            } while (!Files.isDirectory(p = (Path)it.next(), new LinkOption[0]) || p.endsWith(code));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMetaData(@NotNull ObjectPath object, boolean staging, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(26);
        }
        if (metaData == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(27);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, ".meta");
        try (Locker lock = this.writeLock();){
            FileUtil.writeToFile((File)path.toFile(), (byte[])DbSrcBackendUtils.serializeMetaData(object, metaData));
        }
        finally {
            this.getListener().dirChanged(object, staging, false);
            this.getListener().fileChanged(object, staging);
        }
    }

    @Nullable
    private DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath object) {
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(28);
        }
        if ((metaData = this.getCachedMetaData(object)) == null && (metaData = this.readMetaData(object)) != null) {
            this.putMetaDataToCache(object, metaData);
        }
        return metaData;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public DbSrcStorageDsMetadata.MetaData readMetaData(@NotNull ObjectPath object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object, boolean staging) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(30);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, ".sql");
        return FileSystemUtil.getAttributes((String)path.toString());
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getCachedMetaData(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(31);
        }
        return this.myMetaDataCache.get(object);
    }

    public void putMetaDataToCache(@NotNull ObjectPath object, @Nullable DbSrcStorageDsMetadata.MetaData metaData) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(32);
        }
        if (metaData == null) {
            this.myMetaDataCache.remove(object);
        } else {
            this.myMetaDataCache.put(object, metaData);
        }
    }

    @Nullable
    DbSrcBackendZipData getCachedZipData(@NotNull ObjectPath root2) {
        if (root2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(33);
        }
        return this.myZipDataCache.get(root2);
    }

    @NotNull
    DbSrcBackendZipData getZipData(@NotNull ObjectPath root2) {
        DbSrcBackendZipData data;
        if (root2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(34);
        }
        if ((data = this.myZipDataCache.get(root2)) == null) {
            String path = DbSrcBackendUtils.getDir(this.myRoot, false, root2, null, ".zip").toString();
            data = new DbSrcBackendZipData(path, root2, this);
            DbSrcBackendZipData prev = this.myZipDataCache.putIfAbsent(root2, data);
            data = (DbSrcBackendZipData)ObjectUtils.chooseNotNull((Object)prev, (Object)data);
        }
        data.build();
        DbSrcBackendZipData dbSrcBackendZipData = data;
        if (dbSrcBackendZipData == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(35);
        }
        return dbSrcBackendZipData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(@NotNull ObjectPath object, boolean staging, long timestamp) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(36);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, ".sql");
        try (Locker lock = this.writeLock();){
            FileUtil.setLastModified((File)path.toFile(), (long)timestamp);
        }
        finally {
            this.getListener().fileChanged(object, staging);
        }
    }

    static boolean isZipRoot(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(37);
        }
        return ObjectKind.SCHEMA == kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendFiles";
                break;
            }
            case 6: 
            case 10: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 15: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readLock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "writeLock";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "listGroups";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 35: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContentInputStream";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRoot";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRootImpl";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasSrcOrMeta";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "dropSrcAndMeta";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getStagingMetaData";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherChild";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherGroup";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readMetaData";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMetaData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "putMetaDataToCache";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCachedZipData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getZipData";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isZipRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Locker
    implements AutoCloseable {
        private final Lock myLock;

        public Locker(Lock lock) {
            this.myLock = lock;
        }

        @Override
        public void close() {
            this.myLock.unlock();
        }

        public Locker lock() {
            this.myLock.lock();
            return this;
        }
    }
}

