/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DbSrcMigration;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

final class DbSrcModificationSession {
    private static final Logger LOG = Logger.getInstance(DbSrcModificationSession.class);
    private static final CountedThreadExecutor ourStorageWriter = new CountedThreadExecutor(10);
    @Nullable
    private final Project myProject;
    private final List<ObjectPath> myRemoveQueue;
    private final Set<ObjectPath> myInvalidatedSchemas;
    private final Rdbms myRdbms;
    private int myBalanceCheck;
    private volatile Pair<BasicSourceAware, CompositeText> myCurrentSource;
    private final DbSrcStorage myStorage;
    private final TransactionId myTransactionId;
    private volatile SqlLanguageDialect myDialect;
    private final ScriptingFactory myScriptingFactory;
    private volatile boolean mySession;

    public DbSrcModificationSession(@Nullable Project project, @NotNull DbSrcStorage storage, @Nullable TransactionId transactionId) {
        if (storage == null) {
            DbSrcModificationSession.$$$reportNull$$$0(0);
        }
        this.myRemoveQueue = ContainerUtil.newArrayList();
        this.myInvalidatedSchemas = ContainerUtil.newLinkedHashSet();
        this.myBalanceCheck = 0;
        this.myCurrentSource = null;
        this.myProject = project;
        this.myStorage = storage;
        this.myTransactionId = transactionId;
        this.myRdbms = DbSrcUtils.getRdbms(project, this.myStorage.getDataSourceId());
        this.myScriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
    }

    public synchronized void save(@NotNull BasicSourceAware object, @Nullable CompositeText text) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(1);
        }
        if (this.myBalanceCheck <= 0) {
            LOG.error("ModelTextStorage.beginWrite should be called");
        }
        if (!this.mySession) {
            this.initSessions();
        }
        this.flushDeleteQueue();
        ObjectPath srcPath = ObjectPaths.of(object, (CasingProvider)object.getModel());
        if (text == null) {
            ourStorageWriter.execute(() -> this.processDelete(srcPath));
        } else {
            CompositeText generated = this.generate(object, text);
            int genVersion = this.myScriptingFactory.getScriptingService(this.myRdbms).capabilities(object).getCreateVersion();
            int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(this.myRdbms, object.getKind());
            ourStorageWriter.execute(() -> this.processSave(srcPath, generated, introVersion, genVersion));
        }
    }

    public synchronized void queueDelete(@NotNull BasicElement object) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(2);
        }
        ObjectPath srcPath = ObjectPaths.of(object, (CasingProvider)object.getModel());
        if (!this.mySession) {
            this.myRemoveQueue.add(srcPath);
        } else {
            ourStorageWriter.execute(() -> this.processDrop(srcPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompositeText generate(@NotNull BasicSourceAware object, @NotNull CompositeText text) {
        CompositeText compositeText;
        BasicScriptable so;
        BasicModel model;
        block11: {
            if (object == null) {
                DbSrcModificationSession.$$$reportNull$$$0(3);
            }
            if (text == null) {
                DbSrcModificationSession.$$$reportNull$$$0(4);
            }
            this.myCurrentSource = Pair.create((Object)object, (Object)text);
            model = object.getModel();
            so = (BasicScriptable)ObjectUtils.tryCast((Object)object, BasicScriptable.class);
            if (model != null && so != null) break block11;
            CompositeText compositeText2 = text;
            this.myCurrentSource = null;
            CompositeText compositeText3 = compositeText2;
            if (compositeText3 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(5);
            }
            return compositeText3;
        }
        try {
            ScriptingService service = this.myScriptingFactory.getScriptingService(model.getRdbms());
            ScriptingSingleModelTaskBuilder task = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_DEFINITION);
            task.getElements().add(so);
            task.setCurrentNamespace((BasicNamespace)ObjectUtils.chooseNotNull((Object)so.getSchema(), (Object)so.getDatabase()));
            ScriptingResult result2 = service.makeScript(task.build());
            CompositeText compositeText4 = result2.getScript();
            this.myCurrentSource = null;
            compositeText = compositeText4;
        }
        catch (Throwable e) {
            CompositeText compositeText5;
            try {
                LOG.warn("Code generation failed", e);
                CompositeText compositeText6 = text;
                compositeText5 = compositeText6;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.myCurrentSource = null;
            }
            if (compositeText5 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(7);
            }
            return compositeText5;
        }
        if (compositeText == null) {
            DbSrcModificationSession.$$$reportNull$$$0(6);
        }
        return compositeText;
    }

    private void initSessions() {
        if (this.mySession) {
            throw new AssertionError((Object)"Session already initialized");
        }
        this.mySession = true;
        ourStorageWriter.acquire();
    }

    private void flushDeleteQueue() {
        if (!this.mySession) {
            throw new AssertionError((Object)"Session should be initialized");
        }
        if (this.myRemoveQueue.isEmpty()) {
            return;
        }
        ObjectIntHashMap lens = new ObjectIntHashMap(this.myRemoveQueue.size(), ContainerUtil.identityStrategy());
        for (ObjectPath path : this.myRemoveQueue) {
            lens.put((Object)path, ObjectPaths.getLength(path));
        }
        this.myRemoveQueue.sort((p1, p2) -> Comparing.compare((int)lens.get(p1), (int)lens.get(p2)));
        LinkedHashSet processed = ContainerUtil.newLinkedHashSet();
        ArrayList toRemove = ContainerUtil.newArrayList();
        for (ObjectPath cur : this.myRemoveQueue) {
            if (!processed.add(cur)) continue;
            boolean skip = false;
            ObjectPath p = cur.parent;
            while (p != null && !(skip = processed.contains(p))) {
                p = p.parent;
            }
            if (skip) continue;
            toRemove.add(cur);
        }
        this.myRemoveQueue.clear();
        ourStorageWriter.execute(() -> this.runWriteAction(() -> {
            for (ObjectPath path : toRemove) {
                try {
                    this.processDrop(path);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        }));
    }

    public synchronized void beginWrite() {
        ++this.myBalanceCheck;
    }

    public synchronized void endWrite() {
        --this.myBalanceCheck;
        if (this.myBalanceCheck != 0) {
            return;
        }
        if (!this.mySession) {
            if (this.myRemoveQueue.isEmpty()) {
                return;
            }
            this.initSessions();
            this.flushDeleteQueue();
        }
        this.mySession = false;
        ourStorageWriter.execute(() -> this.processCloseSessions());
        ourStorageWriter.release();
    }

    @Nullable
    public CompositeText getTmpSource(@NotNull BasicSourceAware object) {
        Pair<BasicSourceAware, CompositeText> src;
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(8);
        }
        return (src = this.myCurrentSource) == null || src.first != object ? null : (CompositeText)src.second;
    }

    @NotNull
    private Project getAnyProject() {
        if (this.myProject != null && !this.myProject.isDisposed()) {
            Project project = this.myProject;
            if (project == null) {
                DbSrcModificationSession.$$$reportNull$$$0(9);
            }
            return project;
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        Project project = projects.length != 0 ? projects[0] : ProjectManager.getInstance().getDefaultProject();
        if (project == null) {
            DbSrcModificationSession.$$$reportNull$$$0(10);
        }
        return project;
    }

    @NotNull
    private SqlLanguageDialect getSqlDialect() {
        if (this.myDialect == null) {
            Project project = this.getAnyProject();
            LocalDataSource dataSource = DbSrcUtils.findDataSource(project, this.myStorage.getDataSourceId());
            this.myDialect = DbSqlUtil.getSqlDialect(dataSource);
        }
        SqlLanguageDialect sqlLanguageDialect = this.myDialect;
        if (sqlLanguageDialect == null) {
            DbSrcModificationSession.$$$reportNull$$$0(11);
        }
        return sqlLanguageDialect;
    }

    private void processDelete(@NotNull ObjectPath srcPath) {
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(12);
        }
        try {
            this.myStorage.putOriginalContent(srcPath, null, DbSrcStorageDsMetadata.MetaData.EMPTY);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this.invalidateSchema(srcPath);
    }

    private void processDrop(@NotNull ObjectPath srcPath) {
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(13);
        }
        try {
            this.myStorage.dropObject(srcPath, true);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this.invalidateSchema(srcPath);
    }

    @NotNull
    private PersistentMarkup format(@NotNull ObjectPath srcPath, @NotNull CompositeText text) {
        PersistentMarkup persistentMarkup;
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(14);
        }
        if (text == null) {
            DbSrcModificationSession.$$$reportNull$$$0(15);
        }
        try {
            persistentMarkup = DbSrcMigration.formatCompositeText(this.getAnyProject(), this.getSqlDialect(), text);
        }
        catch (Throwable e) {
            LOG.warn("Formatting for " + srcPath + " failed, passing unformatted", e);
            PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
            for (CompositeText.Fragment f : text.getFragments()) {
                builder.add(f.getKind(), f.getBegin(), f.getEnd(), f.getError());
            }
            PersistentMarkup persistentMarkup2 = builder.build(text.getText());
            if (persistentMarkup2 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(17);
            }
            return persistentMarkup2;
        }
        if (persistentMarkup == null) {
            DbSrcModificationSession.$$$reportNull$$$0(16);
        }
        return persistentMarkup;
    }

    private void synchronizeFs(boolean async) {
        this.submitTransaction(() -> this.myStorage.flushToFs(async));
    }

    private void processSave(@NotNull ObjectPath srcPath, @NotNull CompositeText text, int introVersion, int genVersion) {
        FileDocumentManager manager;
        Document document;
        VirtualFile dbFile;
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(18);
        }
        if (text == null) {
            DbSrcModificationSession.$$$reportNull$$$0(19);
        }
        PersistentMarkup sql = this.format(srcPath, text);
        DbSrcStorageDsMetadata.MetaData data = this.myStorage.getMetaData(srcPath);
        DbSrcStorageDsMetadata.MetaData expected = sql.getExpectedMetaData(data, introVersion, genVersion);
        VirtualFile virtualFile = dbFile = this.myProject != null && this.myProject.isDisposed() ? null : DbSrcFileSystem.getInstance().findFileByPathIfCached(DbSrcFileSystem.getPathFromNormalized(this.myProject, this.myStorage.getDataSourceId(), srcPath, DbSrcFileSystem.ItemType.SRC));
        if (dbFile != null && (document = (manager = FileDocumentManager.getInstance()).getCachedDocument(dbFile)) != null && manager.isDocumentUnsaved(document)) {
            manager.saveDocument(document);
        }
        try {
            this.myStorage.putOriginalContent(srcPath, sql.getText().toString().getBytes(CharsetToolkit.UTF8_CHARSET), expected);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (data == null || data.introContentVersion != expected.introContentVersion || data.genContentVersion != expected.genContentVersion) {
            this.invalidateSchema(srcPath);
        }
    }

    private void processCloseSessions() {
    }

    private void runWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbSrcModificationSession.$$$reportNull$$$0(20);
        }
        this.submitTransaction(() -> {
            if (runnable == null) {
                DbSrcModificationSession.$$$reportNull$$$0(24);
            }
            Application app = ApplicationManager.getApplication();
            if (!(this.myProject == null ? app : this.myProject).isDisposed()) {
                app.runWriteAction(runnable);
            }
        });
    }

    private void submitTransaction(@NotNull Runnable runnable) {
        Application app;
        if (runnable == null) {
            DbSrcModificationSession.$$$reportNull$$$0(21);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable.run();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            TransactionGuard.getInstance().submitTransaction(Disposer.newDisposable(), this.myTransactionId, () -> {
                if (runnable == null) {
                    DbSrcModificationSession.$$$reportNull$$$0(23);
                }
                try {
                    runnable.run();
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitForWriteFinished(boolean asyncRefresh) {
        if (!ourStorageWriter.isRunning()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ourStorageWriter.acquire();
        try {
            ourStorageWriter.execute(() -> {
                try {
                    this.synchronizeFs(asyncRefresh);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        finally {
            ourStorageWriter.release();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void invalidateSchema(@NotNull ObjectPath path) {
        ObjectPath schema;
        if (path == null) {
            DbSrcModificationSession.$$$reportNull$$$0(22);
        }
        if ((schema = path.findParent(ObjectKind.SCHEMA, false)) != null && !this.myInvalidatedSchemas.contains(schema)) {
            this.myInvalidatedSchemas.add(schema);
            DbSrcValidator.invalidate(this.myStorage, schema);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcPath";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "queueDelete";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTmpSource";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDelete";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDrop";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processSave";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "submitTransaction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSchema";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$submitTransaction$9";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runWriteAction$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CountedThreadExecutor
    implements Executor {
        private final Logger LOG = Logger.getInstance(CountedThreadExecutor.class);
        private final BlockingQueue<Runnable> myQueue = new LinkedBlockingQueue<Runnable>(100);
        private final int myTimeoutSec;
        private volatile int myRefCount = 0;
        private volatile boolean myRunning = false;

        private CountedThreadExecutor(int timeoutSec) {
            this.myTimeoutSec = timeoutSec;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                ++this.myRefCount;
                if (!this.myRunning) {
                    this.myRunning = true;
                    ApplicationManager.getApplication().executeOnPooledThread(this::processQueue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                assert (this.myRefCount > 0);
                assert (this.myRunning);
                --this.myRefCount;
            }
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                CountedThreadExecutor.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Operation not allowed from EDT");
            }
            assert (this.myRefCount > 0);
            assert (this.myRunning);
            try {
                this.myQueue.put(command);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            block25: {
                boolean running = true;
                block19: while (true) {
                    try {
                        while (true) {
                            Runnable task;
                            if ((task = this.myQueue.poll(this.myTimeoutSec, TimeUnit.SECONDS)) == null) {
                                BlockingQueue<Runnable> blockingQueue = this.myQueue;
                                synchronized (blockingQueue) {
                                    if (this.myQueue.isEmpty() && this.myRefCount == 0) {
                                        running = false;
                                        this.myRunning = false;
                                        break block25;
                                    }
                                    continue block19;
                                }
                            }
                            try {
                                task.run();
                                continue block19;
                            }
                            catch (Throwable e2) {
                                this.LOG.warn(e2);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        BlockingQueue<Runnable> e2 = this.myQueue;
                        synchronized (e2) {
                            running = false;
                            this.myRunning = false;
                        }
                        Thread.currentThread().interrupt();
                        break block25;
                    }
                }
                finally {
                    if (running) {
                        BlockingQueue<Runnable> blockingQueue = this.myQueue;
                        synchronized (blockingQueue) {
                            Application app = ApplicationManager.getApplication();
                            if (this.myRunning) {
                                this.LOG.warn("DbSrcWriter accidentally stopped, rescheduling...");
                                app.invokeLater(() -> app.executeOnPooledThread(this::processQueue), app.getDisposed());
                            }
                        }
                    }
                    this.LOG.info("DbSrcWriter stopped");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession$CountedThreadExecutor", "execute"));
        }
    }
}

