/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMapping {
    private static final DbSrcMapping INSTANCE = new DbSrcMapping();

    @NotNull
    public static DbSrcMapping getInstance() {
        DbSrcMapping dbSrcMapping = INSTANCE;
        if (dbSrcMapping == null) {
            DbSrcMapping.$$$reportNull$$$0(0);
        }
        return dbSrcMapping;
    }

    @Nullable
    public DbElement getDbElement(@NotNull PsiObject object) {
        VirtualFile vfile;
        if (object == null) {
            DbSrcMapping.$$$reportNull$$$0(1);
        }
        if (object instanceof DbElement) {
            return (DbElement)object;
        }
        PsiFile file = object.getContainingFile();
        file = file == null ? null : file.getOriginalFile();
        VirtualFile virtualFile = vfile = file == null ? null : file.getVirtualFile();
        if (!DbSrcUtils.isDbSrcFile(vfile)) {
            return null;
        }
        return DbSrcUtils.findObject(vfile.getPath(), (PairFunction<Project, String, DasModel>)((PairFunction)(p, id) -> {
            DbDataSource ds;
            if (object == null) {
                DbSrcMapping.$$$reportNull$$$0(4);
            }
            return (ds = DbPsiFacade.getInstance((Project)object.getProject()).findDataSource(id)) == null ? null : ds.getModel();
        }), DbElement.class);
    }

    public boolean processSources(@NotNull DbElement el, @NotNull Consumer<PsiElement> consumer) {
        PsiObject psiSrc;
        DbDataSource ds;
        LocalDataSource local;
        if (el == null) {
            DbSrcMapping.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            DbSrcMapping.$$$reportNull$$$0(3);
        }
        boolean result2 = false;
        PsiElement delegate = (PsiElement)ObjectUtils.tryCast((Object)el.getDelegate(), PsiElement.class);
        if (delegate != null) {
            consumer.consume((Object)delegate);
            result2 = true;
        }
        if ((local = (LocalDataSource)ObjectUtils.tryCast((Object)(ds = el.getDataSource()).getDelegate(), LocalDataSource.class)) == null || el == ds) {
            return false;
        }
        Project project = local.isGlobal() ? null : ds.getProject();
        VirtualFile file = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, ds.getUniqueId(), (DasObject)el, (CasingProvider)local.getModel(), DbSrcFileSystem.ItemType.SRC));
        PsiFile psiFile = file == null ? null : el.getManager().findFile(file);
        PsiObject psiObject = psiSrc = psiFile == null ? null : (PsiObject)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)psiFile).expand(psi -> !(psi instanceof SqlStatement))).filter(PsiObject.class).filter(DasUtil.byKind((ObjectKind)el.getKind())).first();
        if (psiSrc != null) {
            consumer.consume(psiSrc);
            result2 = true;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcMapping";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcMapping";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDbElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processSources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDbElement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

