/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcFileStatus {
    private final Map<String, StatusEntry> myCache = ContainerUtil.createConcurrentSoftValueMap();

    @NotNull
    public StatusEntry getStatus(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileStatus.$$$reportNull$$$0(0);
        }
        String url = file.getUrl();
        assert (DbSrcUtils.isDbSrcFile(file)) : "DbSrcFile expected, got: " + url;
        if (file.isDirectory()) {
            StatusEntry statusEntry = StatusEntry.NON_MODIFIED_ENTRY;
            if (statusEntry == null) {
                DbSrcFileStatus.$$$reportNull$$$0(1);
            }
            return statusEntry;
        }
        StatusEntry entry = this.myCache.get(url);
        if (entry == null || !entry.isValid(file)) {
            entry = StatusEntry.of(file);
            this.myCache.put(url, entry);
        }
        StatusEntry statusEntry = entry;
        if (statusEntry == null) {
            DbSrcFileStatus.$$$reportNull$$$0(2);
        }
        return statusEntry;
    }

    private static long getStamp(@Nullable VirtualFile baseFile) {
        return baseFile == null ? Long.MIN_VALUE : baseFile.getModificationStamp();
    }

    public static String getContent(@Nullable VirtualFile vFile, boolean latest) {
        if (vFile == null) {
            return null;
        }
        Document doc = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        if (doc == null) {
            return null;
        }
        if (latest || !FileDocumentManager.getInstance().isDocumentUnsaved(doc)) {
            return doc.getText();
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)vFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StatusEntry {
        private static final StatusEntry NON_MODIFIED_ENTRY = new StatusEntry(StatusEntryKey.access$200(), null);
        private final StatusEntryKey myKey;
        private final FileStatus myStatus;

        private StatusEntry(@NotNull StatusEntryKey key2, @Nullable FileStatus status) {
            if (key2 == null) {
                StatusEntry.$$$reportNull$$$0(0);
            }
            this.myKey = key2;
            this.myStatus = status;
        }

        @NotNull
        public static StatusEntry of(@NotNull VirtualFile file) {
            StatusEntryKey key2;
            VirtualFile baseFile;
            if (file == null) {
                StatusEntry.$$$reportNull$$$0(1);
            }
            VirtualFile virtualFile = baseFile = (key2 = StatusEntryKey.of(file)).myBaseFileUrl == null ? null : VirtualFileManager.getInstance().findFileByUrl(key2.myBaseFileUrl);
            if (baseFile == null) {
                if (key2.myBaseStamp == key2.myStagingStamp) {
                    StatusEntry statusEntry = NON_MODIFIED_ENTRY;
                    if (statusEntry == null) {
                        StatusEntry.$$$reportNull$$$0(2);
                    }
                    return statusEntry;
                }
                StatusEntry statusEntry = new StatusEntry(key2, FileStatus.UNKNOWN);
                if (statusEntry == null) {
                    StatusEntry.$$$reportNull$$$0(3);
                }
                return statusEntry;
            }
            StatusEntry statusEntry = new StatusEntry(key2, Comparing.equal((String)DbSrcFileStatus.getContent(file, false), (String)DbSrcFileStatus.getContent(baseFile, true)) ? null : FileStatus.MODIFIED);
            if (statusEntry == null) {
                StatusEntry.$$$reportNull$$$0(4);
            }
            return statusEntry;
        }

        @Nullable
        public FileStatus getStatus() {
            return this.myStatus;
        }

        public boolean isValid(@NotNull VirtualFile file) {
            if (file == null) {
                StatusEntry.$$$reportNull$$$0(5);
            }
            return StatusEntryKey.of(file).equals(this.myKey);
        }

        @Nullable
        public String getBaseFileUrl() {
            return this.myKey.myBaseFileUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntry";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StatusEntryKey {
        private static final StatusEntryKey NON_MODIFIED_KEY = new StatusEntryKey(0L, 0L, null);
        private final long myStagingStamp;
        private final long myBaseStamp;
        private final String myBaseFileUrl;

        public StatusEntryKey(long stagingStamp, long baseStamp, @Nullable String baseFileUrl) {
            this.myStagingStamp = stagingStamp;
            this.myBaseStamp = baseStamp;
            this.myBaseFileUrl = baseFileUrl;
        }

        @NotNull
        public static StatusEntryKey of(@NotNull VirtualFile file) {
            long stamp;
            FileDocumentManager documentManager;
            boolean isDocumentModified;
            boolean isFileModified;
            DbSrcFileSystem dbFs;
            if (file == null) {
                StatusEntryKey.$$$reportNull$$$0(0);
            }
            if ((dbFs = (DbSrcFileSystem)((Object)ObjectUtils.tryCast((Object)file.getFileSystem(), DbSrcFileSystem.class))) == null || DbSrcUtils.isOriginal(file)) {
                StatusEntryKey statusEntryKey = NON_MODIFIED_KEY;
                if (statusEntryKey == null) {
                    StatusEntryKey.$$$reportNull$$$0(1);
                }
                return statusEntryKey;
            }
            VirtualFile baseFile = dbFs.getBaseFile(file, false);
            boolean bl = isFileModified = !file.equals(baseFile);
            if (!isFileModified && dbFs.isOrphaned(file)) {
                baseFile = null;
            }
            Document document = (isDocumentModified = (documentManager = FileDocumentManager.getInstance()).isFileModified(file)) ? StatusEntryKey.getDocument(file, documentManager) : null;
            long l = stamp = document != null ? document.getModificationStamp() : DbSrcFileStatus.getStamp(file);
            if (baseFile != null && !isDocumentModified && !isFileModified) {
                StatusEntryKey statusEntryKey = NON_MODIFIED_KEY;
                if (statusEntryKey == null) {
                    StatusEntryKey.$$$reportNull$$$0(2);
                }
                return statusEntryKey;
            }
            StatusEntryKey statusEntryKey = new StatusEntryKey(stamp, DbSrcFileStatus.getStamp(baseFile), baseFile == null ? null : baseFile.getUrl());
            if (statusEntryKey == null) {
                StatusEntryKey.$$$reportNull$$$0(3);
            }
            return statusEntryKey;
        }

        @Nullable
        private static Document getDocument(@NotNull VirtualFile file, FileDocumentManager documentManager) {
            if (file == null) {
                StatusEntryKey.$$$reportNull$$$0(4);
            }
            Application app = ApplicationManager.getApplication();
            Ref res = Ref.create();
            app.invokeAndWait(() -> {
                if (file == null) {
                    StatusEntryKey.$$$reportNull$$$0(5);
                }
                app.runReadAction(() -> {
                    if (file == null) {
                        StatusEntryKey.$$$reportNull$$$0(6);
                    }
                    res.set((Object)documentManager.getDocument(file));
                });
            });
            return (Document)res.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatusEntryKey key2 = (StatusEntryKey)o;
            if (this.myStagingStamp != key2.myStagingStamp) {
                return false;
            }
            if (this.myBaseStamp != key2.myBaseStamp) {
                return false;
            }
            return !(this.myBaseFileUrl != null ? !this.myBaseFileUrl.equals(key2.myBaseFileUrl) : key2.myBaseFileUrl != null);
        }

        public int hashCode() {
            int result2 = (int)(this.myStagingStamp ^ this.myStagingStamp >>> 32);
            result2 = 31 * result2 + (int)(this.myBaseStamp ^ this.myBaseStamp >>> 32);
            result2 = 31 * result2 + (this.myBaseFileUrl != null ? this.myBaseFileUrl.hashCode() : 0);
            return result2;
        }

        static /* synthetic */ StatusEntryKey access$200() {
            return NON_MODIFIED_KEY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileStatus$StatusEntryKey";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocument";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getDocument$1";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

