/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DBFacadeProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.GenericIntrospector;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DatabaseModelLoader {
    private static final Logger LOG = Logger.getInstance(DatabaseModelLoader.class);
    private static final BasicNamespace[] NO_NAMESPACES = new BasicNamespace[0];

    public static boolean matches(@NotNull DasObject o, @NotNull IntrospectionScope scope) {
        if (o == null) {
            DatabaseModelLoader.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(1);
        }
        if (o.getKind() == ObjectKind.DATABASE) {
            return DatabaseModelLoader.databaseMatches(o, scope);
        }
        if (DbImplUtil.isSchema(o)) {
            return DatabaseModelLoader.schemaMatches(o, scope);
        }
        return true;
    }

    public static boolean databaseMatches(@NotNull DasObject database, @NotNull IntrospectionScope scope) {
        if (database == null) {
            DatabaseModelLoader.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(3);
        }
        String name = database.getName();
        boolean cur = database instanceof BasicNamespace && ((BasicNamespace)database).isCurrent();
        return cur && scope.containsDatabase("@") || scope.containsDatabase(name);
    }

    public static boolean schemaMatches(@NotNull DasObject schema, @NotNull IntrospectionScope scope) {
        if (schema == null) {
            DatabaseModelLoader.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(5);
        }
        String name = schema.getName();
        boolean cur = schema instanceof BasicNamespace && ((BasicNamespace)schema).isCurrent();
        DasObject db = schema.getDasParent();
        if (db != null && db.getKind() != ObjectKind.DATABASE) {
            db = null;
        }
        String dbName = db == null ? "*" : db.getName();
        boolean dbCur = db == null || db instanceof BasicNamespace && ((BasicNamespace)db).isCurrent();
        return scope.containsSchema(dbName, name) || dbCur && scope.containsSchema("@", name) || cur && scope.containsSchema(dbName, "@") || dbCur && cur && scope.containsSchema("@", "@");
    }

    public static IntrospectionScope updateIntrospectionScope(@NotNull BasicModel model, @NotNull IntrospectionScope scope, boolean merge) {
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(7);
        }
        MultiMap pairs2 = MultiMap.createLinkedSet();
        if (merge) {
            for (String string : scope.databases()) {
                pairs2.getModifiable((Object)string).addAll(scope.schemas(string));
            }
        }
        for (BasicSchema basicSchema : model.getRoot().getAllSchemas()) {
            if (!basicSchema.isVisible()) continue;
            BasicNamespaceOwner p = basicSchema.getParent();
            if (p != null && p.getKind() != ObjectKind.DATABASE) {
                p = null;
            }
            String dbName = p == null ? "*" : p.getName();
            String scName = basicSchema.getName();
            if (merge && DatabaseModelLoader.schemaMatches(basicSchema, scope)) continue;
            pairs2.putValue((Object)dbName, (Object)scName);
        }
        Family<? extends BasicElement> dbs = model.getRoot().familyOf(ObjectKind.DATABASE);
        if (dbs != null) {
            for (BasicNamespace db : dbs.jbi().filter(BasicNamespace.class)) {
                if (!db.isVisible()) continue;
                pairs2.getModifiable((Object)db.getName());
            }
        }
        return IntrospectionScopes.scopeOf((MultiMap<String, String>)pairs2);
    }

    public static void updateModelVisibility(@NotNull DasModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(9);
        }
        if (model instanceof BasicModModel) {
            DatabaseModelLoader.updateModelVisibility((BasicModModel)model, scope);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static BasicNamespace[] getNamespacesToIntrospect(@NotNull LoaderContext context, @NotNull BasicModModel model) {
        List namespaces;
        boolean allSchemas;
        if (context == null) {
            DatabaseModelLoader.$$$reportNull$$$0(10);
        }
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(11);
        }
        if (context.isSchemaListOnly()) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(12);
            }
            return NO_NAMESPACES;
        }
        if (context.getSelection().contains("*")) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(13);
            }
            return NO_NAMESPACES;
        }
        JBIterable fromDasObjects = JBIterable.from(context.getSelection()).filter(DasObject.class).filterMap(DasUtil::getSchemaObject).filterMap(o -> {
            DasObject parent = o.getDasParent();
            return parent == null ? null : IntrospectionScope.scopeOf(parent.getName(), o.getName());
        });
        @NotNull JBIterable fromStringPatterns = JBIterable.from(context.getSelection()).filter(String.class).transform(s -> IntrospectionScopes.importScope(s));
        List scopes = fromStringPatterns.append((Iterable)fromDasObjects).unique().toList();
        boolean bl = allSchemas = !JBIterable.from((Iterable)scopes).filter(s -> s.containsSchema("*", "*")).isEmpty();
        if (allSchemas) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(14);
            }
            return NO_NAMESPACES;
        }
        JBIterable visibleNamespaces = ((JBTreeTraverser)model.traverser(false).expand(object -> !DbImplUtil.isSchema(object))).filter(BasicNamespace.class);
        int nonLimitedCount = visibleNamespaces.filter(n -> DbImplUtil.isSchema(n) || n.getKind() == ObjectKind.DATABASE && !n.hasChildren()).size();
        if (nonLimitedCount == (namespaces = visibleNamespaces.filter(object -> {
            if (DbImplUtil.isSchema(object)) {
                for (IntrospectionScope scope : scopes) {
                    if (!DatabaseModelLoader.schemaMatches(object, scope)) continue;
                    return true;
                }
            }
            if (object.getKind() == ObjectKind.DATABASE && !object.hasChildren()) {
                for (IntrospectionScope scope : scopes) {
                    if (!scope.containsDatabase(object.getName())) continue;
                    return true;
                }
            }
            return false;
        }).toList()).size()) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(15);
            }
            return NO_NAMESPACES;
        }
        BasicNamespace[] basicNamespaceArray = namespaces.toArray(new BasicNamespace[0]);
        if (basicNamespaceArray == null) {
            DatabaseModelLoader.$$$reportNull$$$0(16);
        }
        return basicNamespaceArray;
    }

    private static Set<BasicDatabase> getDatabases(LoaderContext context) {
        if (context.getSelection().contains("*")) {
            return Collections.emptySet();
        }
        DasModel model = context.getDataSource().getModel();
        JBIterable sel = JBIterable.from(context.getSelection());
        return sel.append((Iterable)sel.filter(DbElement.class).transform(DbElement::getDelegate)).filter(BasicDatabase.class).filter(o -> o.getModel() == model).append((Iterable)sel.filter(String.class).flatten(s -> DatabaseModelLoader.scopeToDatabases(model, IntrospectionScopes.importScope(s)))).toSet();
    }

    private static Set<BasicDatabase> getDatabasesFromScope(LoaderContext context) {
        LocalDataSource source = context.getDataSource();
        IntrospectionScope scope = source.getIntrospectionScope();
        if (scope.isEmpty()) {
            return Collections.emptySet();
        }
        DasModel model = source.getModel();
        JBIterable<BasicDatabase> dbs = DatabaseModelLoader.scopeToDatabases(model, scope);
        return dbs.toSet();
    }

    @NotNull
    private static JBIterable<BasicDatabase> scopeToDatabases(DasModel model, IntrospectionScope scope) {
        JBIterable dbs = model.getModelRoots().filter(BasicDatabase.class);
        if (scope.containsDatabase("*")) {
            JBIterable jBIterable = dbs;
            if (jBIterable == null) {
                DatabaseModelLoader.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        JBIterable jBIterable = dbs.filter(db -> db.isCurrent() && scope.containsDatabase("@") || scope.containsDatabase(db.getName()));
        if (jBIterable == null) {
            DatabaseModelLoader.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    static void updateModelVisibility(@NotNull BasicModModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(20);
        }
        model.modify(BasicModRoot.class, r -> {
            if (scope == null) {
                DatabaseModelLoader.$$$reportNull$$$0(24);
            }
            DatabaseModelLoader.updateDatabasesVisibility(r.familyOf(ObjectKind.DATABASE), scope);
            DatabaseModelLoader.updateSchemasVisibility(r.familyOf(ObjectKind.SCHEMA), null, scope);
            DatabaseModelLoader.updateSchemasVisibility(r.familyOf(ObjectKind.EXTERNAL_SCHEMA), null, scope);
        });
    }

    private static void updateDatabasesVisibility(@Nullable Family<? extends BasicElement> databases, @NotNull IntrospectionScope scope) {
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(21);
        }
        if (databases == null) {
            return;
        }
        boolean all = scope.containsDatabase("*");
        for (BasicModMateDatabase database : databases.jbi().filter(BasicModMateDatabase.class)) {
            boolean visible = all || scope.containsDatabase(database.getName()) || database.isCurrent() && scope.containsDatabase("@");
            database.setVisible(visible);
            DatabaseModelLoader.updateSchemasVisibility(database.familyOf(ObjectKind.SCHEMA), database, scope);
            DatabaseModelLoader.updateSchemasVisibility(database.familyOf(ObjectKind.EXTERNAL_SCHEMA), database, scope);
        }
    }

    private static void updateSchemasVisibility(@Nullable Family<? extends BasicElement> schemas, @Nullable BasicDatabase database, @NotNull IntrospectionScope scope) {
        boolean hasDatabase;
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(22);
        }
        if (schemas == null) {
            return;
        }
        String db = database == null ? "*" : database.getName();
        boolean dbCurrent = database != null && database.isCurrent();
        boolean bl = hasDatabase = scope.containsDatabase(db) || dbCurrent && scope.containsDatabase("@");
        if (!hasDatabase) {
            schemas.jbi().filter(BasicModMateNamespace.class).forEach(s -> s.setVisible(false));
            return;
        }
        for (BasicModMateNamespace schema : schemas.jbi().filter(BasicModMateNamespace.class)) {
            boolean visible = scope.containsSchema(db, schema.getName());
            visible |= dbCurrent && scope.containsSchema("@", schema.getName());
            visible |= schema.isCurrent() && scope.containsSchema(db, "@");
            schema.setVisible(visible |= schema.isCurrent() && dbCurrent && scope.containsSchema("@", "@"));
        }
    }

    @NotNull
    private static DBIntrospectionOptions getIntrospectionOptions(LocalDataSource dataSource) {
        DBIntrospectionOptions.SourceLoading withSources = dataSource.getSourceLoading();
        DBIntrospectionOptions dBIntrospectionOptions = new DBIntrospectionOptions(withSources);
        if (dBIntrospectionOptions == null) {
            DatabaseModelLoader.$$$reportNull$$$0(23);
        }
        return dBIntrospectionOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseModelLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesToIntrospect";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeToDatabases";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectionOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "databaseMatches";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "schemaMatches";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateIntrospectionScope";
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateModelVisibility";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesToIntrospect";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabasesVisibility";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateSchemasVisibility";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateModelVisibility$9";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class IntrospectionSession {
        private final LoaderContext myContext;
        private final ProgressIndicator myIndicator;
        private final TransactionId myTransactionId;
        private final Rdbms myRdbms;
        private DBIntrospector myIntrospector;
        private GuardedRef mySrcSession;
        private boolean myFirstTime;
        private boolean myUpdateScopeFromIntrospector;

        public IntrospectionSession(@NotNull LoaderContext context, @NotNull ProgressIndicator indicator, @Nullable TransactionId transactionId) {
            if (context == null) {
                IntrospectionSession.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                IntrospectionSession.$$$reportNull$$$0(1);
            }
            this.myContext = context;
            this.myIndicator = indicator;
            this.myTransactionId = transactionId;
            this.myRdbms = (Rdbms)ObjectUtils.chooseNotNull((Object)DataSourceUiUtil.getRdbmsForIntrospection(this.myContext.getFamilyId()), (Object)UnknownDatabase.RDBMS);
        }

        public abstract void perform(@Nullable ObjectPath var1, @NotNull @NotNull @NotNull ThrowableConsumer<DatabaseConnection, Exception> var2) throws SQLException;

        public void run() throws SQLException {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Introspection should not be run in EDT");
            }
            this.myIndicator.checkCanceled();
            if (this.myContext.loadNothing()) {
                this.updateDatabaseInfo();
                DatabaseModelLoader.updateModelVisibility(this.myContext.getDataSource().getModel(), this.myContext.getDataSource().getIntrospectionScope());
            } else {
                this.myContext.getDataSource().performBatch(() -> {
                    try {
                        this.introspect();
                    }
                    catch (SQLException e) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                        ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
                    }
                });
            }
        }

        private void updateDatabaseInfo() throws SQLException {
            this.perform(null, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection -> this.myContext.getDataSource().refreshDatabaseInfo(connection.getMetaData())));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspect() throws SQLException {
            try {
                MultiMap tasks = MultiMap.createLinkedSet();
                ObjectPath initial = this.getInitialConnectionPath();
                this.perform(initial, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection -> {
                    this.myContext.renewFamilyId(connection.getMetaData());
                    this.myContext.getDataSource().setupDefaults((DatabaseConnection)connection);
                    this.withFacade((DatabaseConnection)connection, (ThrowableConsumer<DBFacade, Exception>)((ThrowableConsumer)facade -> {
                        this.prepareIntrospection((DBFacade)facade);
                        try {
                            this.myIntrospector.attachToDB((DBFacade)facade);
                            this.myIntrospector.introspectSessionState();
                            this.myFirstTime = this.myIntrospector.getModel().getModelRoots().isEmpty();
                            this.myIndicator.setText("Preparing to " + (this.myFirstTime ? "complete" : "incremental") + " introspection (" + facade.rdbms().code + ")");
                            this.introspectDatabaseList();
                            this.distributeDatabaseTasks(facade.getConnectionInfo().databaseName, (MultiMap<ObjectPath, BasicDatabase>)tasks);
                            if (!this.myContext.isSchemaListOnly()) {
                                this.myIndicator.setText("Introspecting server objects");
                                this.myIntrospector.introspectServerObjects();
                            }
                            if (tasks.isEmpty()) {
                                this.introspectDatabases(Collections.emptyList());
                            } else {
                                Collection databases = tasks.remove(null);
                                if (!ContainerUtil.isEmpty((Collection)databases)) {
                                    this.introspectDatabases(databases);
                                }
                            }
                        }
                        finally {
                            this.myIntrospector.detachFromDB();
                        }
                    }));
                }));
                for (Map.Entry task : tasks.entrySet()) {
                    if (task.getKey() == null || ((Collection)task.getValue()).isEmpty()) continue;
                    this.reconnectAndIntrospectDatabases((ObjectPath)task.getKey(), (Collection)task.getValue());
                }
                String extra = this.myContext.isSchemaListOnly() ? " [schemas only]" : "";
                this.myIndicator.setText("Finishing introspection (" + this.myRdbms.code + ")" + extra);
            }
            finally {
                if (this.mySrcSession != null) {
                    this.mySrcSession.close();
                }
            }
        }

        @Nullable
        private ObjectPath getInitialConnectionPath() {
            LocalDataSource dataSource = this.myContext.getDataSource();
            if (!JdbcUrlParserUtil.isDatabaseBounded(dataSource)) {
                return null;
            }
            IntrospectionScope scope = dataSource.getIntrospectionScope();
            MultiMap<String, String> scopeMap = scope.to((MultiMap<String, String>)MultiMap.createLinkedSet());
            MultiMap<String, String> contextMap = IntrospectionSession.contextToMap(this.myContext);
            String any = IntrospectionSession.getAnyFromIntersection(scopeMap.keySet(), contextMap.keySet());
            return any == null ? null : ObjectPath.create((String)any, (ObjectKind)ObjectKind.DATABASE);
        }

        @Nullable
        private static String getAnyFromIntersection(@NotNull Collection<String> set1, @NotNull Collection<String> set2) {
            String any;
            if (set1 == null) {
                IntrospectionSession.$$$reportNull$$$0(2);
            }
            if (set2 == null) {
                IntrospectionSession.$$$reportNull$$$0(3);
            }
            if (set1.contains("@") || set2.contains("@")) {
                return null;
            }
            Condition notStar = x -> !"*".equals(x);
            if (set2.contains("*") && (any = (String)ContainerUtil.find(set1, (Condition)notStar)) != null) {
                return any;
            }
            if (set1.contains("*") && (any = (String)ContainerUtil.find(set2, (Condition)notStar)) != null) {
                return any;
            }
            return (String)ContainerUtil.find((Iterable)JBIterable.from(set1).filter(set2::contains), (Condition)notStar);
        }

        @NotNull
        private static MultiMap<String, String> contextToMap(@NotNull LoaderContext context) {
            if (context == null) {
                IntrospectionSession.$$$reportNull$$$0(4);
            }
            MultiMap map = MultiMap.createLinkedSet();
            for (Object o : context.getSelection()) {
                if (o instanceof DasObject) {
                    DasObject sc = DasUtil.getSchemaObject((DasObject)((DasObject)o));
                    DasObject db = DasUtil.getCatalogObject((DasObject)sc);
                    if (sc == null) continue;
                    map.putValue((Object)(db == null ? "*" : db.getName()), (Object)sc.getName());
                    continue;
                }
                if (!(o instanceof String)) continue;
                IntrospectionScopes.importScope((String)o).to((MultiMap<String, String>)map);
            }
            MultiMap multiMap = map;
            if (multiMap == null) {
                IntrospectionSession.$$$reportNull$$$0(5);
            }
            return multiMap;
        }

        private void reconnectAndIntrospectDatabases(@NotNull ObjectPath destination, @NotNull Collection<BasicDatabase> databases) throws SQLException {
            if (destination == null) {
                IntrospectionSession.$$$reportNull$$$0(6);
            }
            if (databases == null) {
                IntrospectionSession.$$$reportNull$$$0(7);
            }
            this.perform(destination, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection -> {
                if (destination == null) {
                    IntrospectionSession.$$$reportNull$$$0(14);
                }
                if (databases == null) {
                    IntrospectionSession.$$$reportNull$$$0(15);
                }
                this.withFacade((DatabaseConnection)connection, (ThrowableConsumer<DBFacade, Exception>)((ThrowableConsumer)facade -> {
                    if (destination == null) {
                        IntrospectionSession.$$$reportNull$$$0(16);
                    }
                    if (databases == null) {
                        IntrospectionSession.$$$reportNull$$$0(17);
                    }
                    this.myIndicator.setText("Performing " + (this.myFirstTime ? "complete" : "incremental") + " introspection (" + facade.rdbms().code + ") of " + destination.kind.code() + " " + destination.getName());
                    try {
                        this.myIntrospector.attachToDB((DBFacade)facade);
                        this.introspectDatabases(databases);
                    }
                    finally {
                        this.myIntrospector.detachFromDB();
                    }
                }));
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspectDatabases(@NotNull Collection<BasicDatabase> dbs) {
            IntrospectionScope firstScope;
            if (dbs == null) {
                IntrospectionSession.$$$reportNull$$$0(8);
            }
            IntrospectionScope introspectionScope = firstScope = this.myContext.getDataSource().getIntrospectionScope();
            BasicModModel model = this.myIntrospector.getModel();
            BasicDatabase[] databases = (BasicDatabase[])ContainerUtil.toArray(dbs, BasicDatabase[]::new);
            try {
                if (model.getRoot().familyOf(ObjectKind.DATABASE) != null) {
                    this.myIntrospector.introspectDatabaseSchemas(databases);
                    this.setFakeCurrentSc(model);
                    introspectionScope = this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                }
            }
            finally {
                if (this.myUpdateScopeFromIntrospector) {
                    introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                } else if (!introspectionScope.equals(firstScope)) {
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                }
            }
            DatabaseModelLoader.updateModelVisibility(model, introspectionScope);
            if (this.myContext.isSchemaListOnly()) {
                return;
            }
            Object[] namespaces = DatabaseModelLoader.getNamespacesToIntrospect(this.myContext, model);
            if (!dbs.isEmpty()) {
                Collection<Object> current = JBIterable.of((Object[])namespaces).filter(n -> {
                    if (dbs == null) {
                        IntrospectionSession.$$$reportNull$$$0(13);
                    }
                    return dbs.contains(n) || dbs.contains(n.getParent());
                }).toList();
                if (current.isEmpty()) {
                    current = dbs;
                }
                namespaces = current.toArray(new BasicNamespace[0]);
            }
            this.myIntrospector.introspectAuto((BasicNamespace[])namespaces);
        }

        private void distributeDatabaseTasks(@Nullable String currentDb, @NotNull MultiMap<ObjectPath, BasicDatabase> tasks) {
            DatabaseDriver driver;
            if (tasks == null) {
                IntrospectionSession.$$$reportNull$$$0(9);
            }
            DatabaseDriver.Bounds bounds = (driver = this.myContext.getDataSource().getDatabaseDriver()) == null ? null : driver.getConnectionBounds();
            Set<BasicDatabase> databases = this.getDatabasesForIntrospection();
            if (bounds == null || bounds.boundTo != ObjectKind.DATABASE) {
                tasks.put(null, databases);
                return;
            }
            for (BasicDatabase database : databases) {
                if (database.getName().equals(currentDb)) {
                    tasks.putValue(null, (Object)database);
                    continue;
                }
                tasks.putValue((Object)ObjectPaths.of(database), (Object)database);
            }
        }

        private Set<BasicDatabase> getDatabasesForIntrospection() {
            Set dbs = DatabaseModelLoader.getDatabases(this.myContext);
            return dbs.isEmpty() ? DatabaseModelLoader.getDatabasesFromScope(this.myContext) : dbs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspectDatabaseList() {
            IntrospectionScope firstScope;
            IntrospectionScope introspectionScope = firstScope = this.myContext.getDataSource().getIntrospectionScope();
            BasicModModel model = this.myIntrospector.getModel();
            try {
                this.myIntrospector.introspectNamespaces();
                this.setFakeCurrentDb(model);
                introspectionScope = this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
            }
            catch (Throwable throwable) {
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
                if (this.myUpdateScopeFromIntrospector) {
                    introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                } else if (!introspectionScope.equals(firstScope)) {
                    this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
                }
                throw throwable;
            }
            if (this.myUpdateScopeFromIntrospector) {
                introspectionScope = DatabaseModelLoader.updateIntrospectionScope(model, introspectionScope, true);
                this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
            } else if (!introspectionScope.equals(firstScope)) {
                this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
            }
        }

        private void setFakeCurrentDb(BasicModModel model) {
            Couple<String> fakeCurrent = this.getFakeCurrentSchema();
            if (fakeCurrent == null) {
                return;
            }
            NamingFamily<? extends BasicMateNamespace> namespaces = model.getRoot().getNamespaces();
            if (namespaces.isEmpty()) {
                return;
            }
            if (!namespaces.jbi().filter(n -> n.isCurrent()).isEmpty()) {
                return;
            }
            if (model.getRoot().familyOf(ObjectKind.DATABASE) != null) {
                if (fakeCurrent.first != null) {
                    model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, (String)fakeCurrent.first, ObjectKind.DATABASE));
                }
            } else if (fakeCurrent.second != null) {
                model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, (String)fakeCurrent.second, ObjectKind.SCHEMA));
            }
        }

        private void setFakeCurrentSc(BasicModModel model) {
            Couple<String> fakeCurrent = this.getFakeCurrentSchema();
            if (fakeCurrent == null || fakeCurrent.second == null) {
                return;
            }
            BasicDatabase database = model.getRoot().getCurrentDatabase();
            if (database == null) {
                return;
            }
            model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r.mod(database), (String)fakeCurrent.second, ObjectKind.SCHEMA));
        }

        private static void setCurrent(BasicModElement parent, String name, ObjectKind kind) {
            BasicModMateNamespace namespace;
            ModNamingFamily dbs = (ModNamingFamily)ObjectUtils.tryCast((Object)parent.familyOf(kind), ModNamingFamily.class);
            BasicModMateNamespace basicModMateNamespace = namespace = dbs == null ? null : (BasicModMateNamespace)ObjectUtils.tryCast(dbs.get(name), BasicModMateNamespace.class);
            if (namespace != null) {
                namespace.setCurrent(true);
            }
        }

        @Nullable
        private Couple<String> getFakeCurrentSchema() {
            return this.myIntrospector instanceof GenericIntrospector ? this.myContext.getDataSource().getFakeCurrentSchema() : null;
        }

        private void prepareIntrospection(@NotNull DBFacade facade) {
            LocalDataSource dataSource;
            if (facade == null) {
                IntrospectionSession.$$$reportNull$$$0(10);
            }
            ModelFactory modelFactory = DbSrcModelStorage.createFactory((dataSource = this.myContext.getDataSource()).isGlobal() ? null : this.myContext.getProject(), dataSource.getUniqueId());
            DBIntrospectionOptions options = DatabaseModelLoader.getIntrospectionOptions(dataSource);
            boolean forceGeneric = dataSource.useLegacyIntrospector();
            if (!forceGeneric) {
                forceGeneric = !DBIntrospectorFactory.supportedByNativeIntrospector(facade);
            }
            this.initIntrospector(facade, dataSource, modelFactory, options, forceGeneric);
        }

        private void initIntrospector(DBFacade facade, LocalDataSource dataSource, ModelFactory modelFactory, DBIntrospectionOptions options, boolean forceGeneric) {
            DbSrcModelStorage storage;
            if (this.myIntrospector != null || this.mySrcSession != null) {
                throw new AssertionError((Object)"Already have introspector");
            }
            this.myIntrospector = DBIntrospectorFactory.createIntrospector(modelFactory, facade, forceGeneric);
            this.myIntrospector.setOptions(options);
            this.myIntrospector.setErrorSink((PairConsumer<String, Throwable>)((PairConsumer)this.myContext.getErrorHandler()::addError));
            this.myIntrospector.setProgressIndicator(this.myIndicator);
            BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class);
            this.myIntrospector.init(model);
            model = this.myIntrospector.getModel();
            if (model != dataSource.getModel()) {
                dataSource.setModel(model);
            }
            if ((storage = (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class)) != null) {
                this.mySrcSession = storage.startWriteSession(model, this.myTransactionId, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void withFacade(@NotNull DatabaseConnection connection, @NotNull @NotNull @NotNull ThrowableConsumer<DBFacade, Exception> consumer) {
            if (connection == null) {
                IntrospectionSession.$$$reportNull$$$0(11);
            }
            if (consumer == null) {
                IntrospectionSession.$$$reportNull$$$0(12);
            }
            try {
                DBFacade facade = DBFacadeProvider.createFacadeWithSingleLeasedConnection(connection, this.myRdbms);
                try {
                    consumer.consume((Object)facade);
                }
                finally {
                    facade.disconnect();
                }
            }
            catch (Throwable e) {
                AsyncUtil.addUnhandledError(this.myContext.getErrorHandler(), e, this.myContext.getDataSource().getName(), this.myContext.getFamilyId());
                throw new ProcessCanceledException();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set2";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession";
                    break;
                }
                case 6: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 7: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "databases";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbs";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contextToMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnyFromIntersection";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "contextToMap";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "reconnectAndIntrospectDatabases";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "introspectDatabases";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "distributeDatabaseTasks";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareIntrospection";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "withFacade";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$introspectDatabases$8";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$reconnectAndIntrospectDatabases$6";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$5";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

