/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseDriverManager {
    private static DatabaseDriverManager ourInstance;

    public static DatabaseDriverManager getInstance() {
        return ourInstance != null ? ourInstance : (DatabaseDriverManager)ServiceManager.getService(DatabaseDriverManager.class);
    }

    public static void setInstance(DatabaseDriverManager inst) {
        ourInstance = inst;
    }

    public abstract Collection<? extends DatabaseDriver> getDrivers();

    public abstract DatabaseDriver getDriver(String var1);

    public abstract void resetToPredefined(@NotNull DatabaseDriver var1);

    public abstract boolean isInPredefinedState(@NotNull DatabaseDriver var1);

    public abstract DatabaseDriver createDriver(String var1, String var2, UrlTemplate var3);

    public abstract void updateDriver(@NotNull DatabaseDriver var1);

    public abstract void removeDriver(@NotNull DatabaseDriver var1);

    public abstract void addDriverListener(@NotNull DatabaseDriverListener var1, @NotNull Disposable var2);

    public static DatabaseDriver createDefaultDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> drivers) {
        if (drivers == null) {
            DatabaseDriverManager.$$$reportNull$$$0(0);
        }
        return DatabaseDriverManager.getInstance().createDriver(DatabaseDriverManager.chooseNewDriverName(drivers, "Database Driver"), "java.sql.Driver", null);
    }

    @NotNull
    public static String chooseNewDriverName(@NotNull Collection<? extends DatabaseDriver> drivers, @NotNull String baseName) {
        if (drivers == null) {
            DatabaseDriverManager.$$$reportNull$$$0(1);
        }
        if (baseName == null) {
            DatabaseDriverManager.$$$reportNull$$$0(2);
        }
        HashSet names = ContainerUtil.newHashSet();
        for (DatabaseDriver databaseDriver : drivers) {
            names.add(databaseDriver.getName());
        }
        String string = DbUtil.createNewDataSourceName((String)baseName, (Set)names);
        if (string == null) {
            DatabaseDriverManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drivers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseNewDriverName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDatabaseDriver";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "chooseNewDriverName";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

