/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceOptionsEditor;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public class DataSourceOptionsPanel {
    private JPanel myRootPanel;
    private JBCheckBox myLegacyIntrospector;
    private JEditorPane myObjectFilterHelp;
    private RawCommandLineEditor myObjectFilterField;
    private final DataSourceOptionsEditor myOptionsPanel;
    private JPanel myOptionsPanelComponent;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private ComboBox<DatabaseDriver.SchemaControl> mySwitchControlBox;

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable dialog) {
        if (dialog == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(0);
        }
        this.myOptionsPanel = new DataSourceOptionsEditor(dialog);
        this.$$$setupUI$$$();
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DBIntrospectionOptions.SourceLoading>(){

            public void customize(JList list, DBIntrospectionOptions.SourceLoading value, int index2, boolean selected, boolean hasFocus) {
                String text = "None";
                if (value == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES) {
                    text = "All schemas";
                }
                if (value == DBIntrospectionOptions.SourceLoading.USER_SOURCES) {
                    text = "All excl. system schemas";
                }
                this.setText(text);
            }
        });
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(DatabaseDriver.SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DatabaseDriver.SchemaControl>(){

            public void customize(JList list, DatabaseDriver.SchemaControl value, int index2, boolean selected, boolean hasFocus) {
                this.setText(DataSourceOptionsPanel.getText(value));
            }
        });
        this.myRootPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        LocalDataSource dataSource = (LocalDataSource)dialog.getDataSource();
        this.myObjectFilterField.setText(StringUtil.notNullize((String)dataSource.getObjectPattern()));
        this.myObjectFilterHelp.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                RegExHelpPopup.createRegExLinkRunnable((Component)this.myRootPanel, null).run();
            }
        });
        this.myLegacyIntrospector.setVisible(DBIntrospectorFactory.hasNativeIntrospector(GenericIntrospectorLegacyModelUtils.findRdbms(DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource))));
        this.myLegacyIntrospector.setSelected(dataSource.useLegacyIntrospector());
        this.mySourceLoading.setSelectedItem((Object)dataSource.getSourceLoading());
    }

    @NotNull
    private static String getText(DatabaseDriver.SchemaControl value) {
        if (value == DatabaseDriver.SchemaControl.FORBID) {
            if ("Disabled" == null) {
                DataSourceOptionsPanel.$$$reportNull$$$0(1);
            }
            return "Disabled";
        }
        String string = StringUtil.capitalize((String)StringUtil.toLowerCase((String)((DatabaseDriver.SchemaControl)((Object)ObjectUtils.chooseNotNull((Object)((Object)value), (Object)((Object)DatabaseDriver.SchemaControl.AUTOMATIC)))).name()));
        if (string == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(3);
        }
        this.mySourceLoading.setSelectedItem((Object)mode);
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(4);
        }
        dataSource.setObjectPattern(StringUtil.nullize((String)this.myObjectFilterField.getText()));
        dataSource.setUseLegacyIntrospector(this.myLegacyIntrospector.isSelected());
        dataSource.setSourceLoading((DBIntrospectionOptions.SourceLoading)((Object)ObjectUtils.chooseNotNull((Object)((Object)((DBIntrospectionOptions.SourceLoading)((Object)this.mySourceLoading.getSelectedItem()))), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))));
        dataSource.setSchemaControl((DatabaseDriver.SchemaControl)((Object)ObjectUtils.chooseNotNull((Object)((Object)((DatabaseDriver.SchemaControl)((Object)this.mySwitchControlBox.getSelectedItem()))), (Object)((Object)DatabaseDriver.SchemaControl.AUTOMATIC))));
        this.myOptionsPanel.saveData(dataSource);
    }

    public void reset(LocalDataSource source) {
        this.myOptionsPanel.reset(source);
        this.mySourceLoading.setSelectedItem((Object)source.getSourceLoading());
        this.mySwitchControlBox.setSelectedItem((Object)source.getSchemaControl());
    }

    private void createUIComponents() {
        this.myObjectFilterField = new RawCommandLineEditor(s -> JBIterable.of((Object[])s.split("\\|\\|")).transform(StringUtil.TRIMMER).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil.TRIMMER), (String)"||"));
        this.myObjectFilterField.setDialogCaption("Object Filter");
        this.myObjectFilterHelp = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
        this.myObjectFilterHelp.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)this.myObjectFilterHelp);
        this.myObjectFilterHelp.setBorder(null);
        this.myObjectFilterHelp.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        StyleSheet sheet = ((HTMLDocument)this.myObjectFilterHelp.getDocument()).getStyleSheet();
        sheet.addRule("a { color: #" + ColorUtil.toHex((Color)JBColor.link()) + " }");
        sheet.addRule("ol { margin: 0px; padding-left: 10px; padding-bottom: 4px; list-style-type:none; }");
        sheet.addRule(UIUtil.displayPropertiesToCSS((Font)JBUI.Fonts.smallFont(), (Color)UIUtil.getLabelDisabledForeground()));
        this.myObjectFilterHelp.setText("<html>A &lt;pattern&gt; or a list of &lt;type&gt;:[-]&lt;pattern&gt; separated by ||. Where:<ol>  <li>&lt;type&gt; is a <b>" + StringUtil.join((Collection)ContainerUtil.sorted(DataSourceUiUtil.FILTER_BY_NAME.keySet()), (String)"</b>, <b>") + "</b>,</li>  <li>&lt;pattern&gt is a <a href=\"#help\">regular expression</a>; prepend with - (minus) for exclusion.</li></ol>Examples: <b>table:CUR_.*</b> or <b>table:-OLD_.*||routine:DO.*||view:V_.*</b></html>");
        this.myObjectFilterHelp.setPreferredSize(new Dimension(150, 90));
        this.myObjectFilterHelp.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)4));
        this.myOptionsPanelComponent = this.myOptionsPanel.getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        ComboBox comboBox2;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JEditorPane jEditorPane = this.myObjectFilterHelp;
        jPanel.add((Component)jEditorPane, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Object filter:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myObjectFilterField;
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel2 = this.myOptionsPanelComponent;
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 8, 2, 3, 3, null, null, null, 0, true));
        this.myLegacyIntrospector = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Introspect using JDBC metadata");
        jBCheckBox.setMnemonic('M');
        jBCheckBox.setDisplayedMnemonicIndex(22);
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 8, 2, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Load sources for:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox2 = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox2.setModel(defaultComboBoxModel);
        jPanel3.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Switch schema:");
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySwitchControlBox = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

