/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DataSourceSchemasPanel;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverPropertiesPanel;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.concurrent.CompletionStage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceConfigurable
extends AbstractDataSourceConfigurable<DefaultDbPsiManager, LocalDataSource> {
    private static final String TAB_GENERAL = "General";
    private static final String TAB_SCHEMAS = "Schemas";
    private static final String TAB_SSH_SSL = "SSH/SSL";
    private static final String TAB_OPTIONS = "Options";
    private static final String TAB_ADVANCED = "Advanced";
    private final JPanel myPanel = new JPanel(new BorderLayout(0, 5));
    private TabbedPaneWrapper myTabbedPane;
    private final LocalDataSource myTempDataSource;
    private long myLastSaveStamp;
    private DatabaseNameComponent myNameComponent;
    private DataSourceGeneralPanel myGeneralPanel;
    private DataSourceSchemasPanel mySchemasPanel;
    private DataSourceOptionsPanel myOptionsPanel;
    private DataSourceSshSslPanel mySshSslPanel;
    private DatabaseDriverPropertiesPanel myAdvancedPanel;
    private boolean mySyncOnClose;
    private boolean myGlobal;
    private final MyTestAction myTestAction = this.createTestAction();

    public DataSourceConfigurable(DefaultDbPsiManager manager, LocalDataSource dataSource, Project project) {
        super(manager, dataSource, project);
        this.mySyncOnClose = !DbImplUtil.canConnectTo((LocalDataSource)this.myDataSource);
        this.myTempDataSource = dataSource.copy(project);
    }

    Object createKey(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(0);
        }
        StringBuilder cpString = new StringBuilder();
        for (SimpleClasspathElement cpe : dataSource.getClasspathElements()) {
            cpString.append(cpe.getClassesRootUrls()).append(";");
        }
        Credentials credentials = dataSource == this.myTempDataSource ? new Credentials(this.myGeneralPanel.getUserName(), this.myGeneralPanel.getPassword()) : this.getSecretService().getCredentials(dataSource);
        String cre = StringUtil.notNullize((String)(credentials == null ? null : credentials.getUserName())) + "@" + StringHash.calc((String)StringUtil.notNullize((String)(credentials == null ? null : credentials.getPasswordAsString())));
        return "auth:" + cre + ";driver:" + dataSource.getDriverClass() + "; url:" + dataSource.getUrl() + "; cp:" + cpString + "; vm-options: " + dataSource.getVmOptions();
    }

    @Nullable
    String getUserName() {
        return this.myGeneralPanel.getUserName();
    }

    void updateDatabaseInfo(@NotNull LocalDataSource source) {
        if (source == null) {
            DataSourceConfigurable.$$$reportNull$$$0(1);
        }
        if (Comparing.equal((Object)this.createKey(source), (Object)this.createKey((LocalDataSource)this.myDataSource))) {
            ((LocalDataSource)this.myDataSource).copyDatabaseInfo(source);
        }
    }

    @Override
    @NotNull
    public LocalDataSource getTempDataSource() {
        long curStamp = this.myController.getModificationTracker().getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveData(this.myTempDataSource, false, true);
        }
        LocalDataSource localDataSource = this.myTempDataSource;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(2);
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getTempDataSourceForConnection() {
        LocalDataSource ds = ((LocalDataSource)this.myDataSource).copy(this.myProject);
        this.saveData(ds, true, true);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return localDataSource;
    }

    public void testConnection() {
        this.setConnectionStatus(null);
        LocalDataSource tempDataSource = this.getTempDataSourceForConnection();
        if (StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl())) {
            Messages.showErrorDialog((String)DatabaseMessages.message((String)"message.text.specify.database.url", (Object[])new Object[0]), (String)"Connect to Database...");
            this.myGeneralPanel.requestUrlFocus();
            return;
        }
        LoaderContext context = new LoaderContext(this.getProject(), tempDataSource);
        CompletionStage<DataSourceSyncManager.SyncResult> syncResult = DataSourceSyncManager.getInstance().tryPerform(context, true, false);
        if (syncResult == null) {
            return;
        }
        this.myTestAction.setBusy(true);
        syncResult.whenCompleteAsync((r, e) -> {
            this.myTestAction.setBusy(false);
            AsyncUtil.addUnhandledError(context.getErrorHandler(), e, tempDataSource.getName(), DbImplUtil.getDatabaseDialect(tempDataSource).getFamilyId());
            if (AsyncUtil.isCancellation(e) && !context.getErrorHandler().hasErrors()) {
                return;
            }
            boolean failed = context.getErrorHandler().hasErrors();
            String summary = context.getErrorHandler().getSummary();
            this.myController.showErrorNotification((Configurable)this, "TEST_CONNECTION", failed ? "Error" : null, summary, new Object[0]);
            this.updateDatabaseInfo(tempDataSource);
            this.myGeneralPanel.resetCredentials(tempDataSource);
            DataSourceUiUtil.Status status = failed ? DataSourceUiUtil.Status.failed() : DataSourceUiUtil.Status.successful(DataSourceUiUtil.formatDataSourceInfoString(tempDataSource));
            this.setConnectionStatus(status);
        }, AsyncUtil.EDT_EXECUTOR);
    }

    private void setConnectionStatus(@Nullable DataSourceUiUtil.Status status) {
        for (DataSourceUiUtil.StatusPanel panel : UIUtil.uiTraverser((Component)this.myPanel).traverse().filter(DataSourceUiUtil.StatusPanel.class)) {
            panel.setStatus(status);
        }
    }

    protected JComponent createCenterPanel() {
        this.myNameComponent = new DatabaseNameComponent(this, this.myController);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane = new TabbedPaneWrapper((Disposable)this);
        this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        this.myGeneralPanel = new DataSourceGeneralPanel(this);
        this.mySchemasPanel = new DataSourceSchemasPanel(this);
        this.myOptionsPanel = new DataSourceOptionsPanel(this);
        this.myAdvancedPanel = new DatabaseDriverPropertiesPanel(this.myProject, ((LocalDataSource)this.myDataSource).getDriverProperties(), ((LocalDataSource)this.myDataSource).getVmOptions(), (Configurable)this, this.myController);
        this.myTabbedPane.addTab(TAB_GENERAL, (JComponent)this.myGeneralPanel.getComponent());
        this.mySshSslPanel = new DataSourceSshSslPanel(this.getProject(), (LocalDataSource)this.myDataSource, this);
        this.myTabbedPane.addTab(TAB_SSH_SSL, (JComponent)this.mySshSslPanel.getComponent());
        this.myTabbedPane.addTab(TAB_SCHEMAS, this.mySchemasPanel.getComponent());
        this.myTabbedPane.addTab(TAB_OPTIONS, (JComponent)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab(TAB_ADVANCED, (JComponent)this.myAdvancedPanel.getComponent());
        this.myTabbedPane.setSelectedIndex(this.getDefaultTabIndex());
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DataSourceConfigurable.this.updateDefaultTabIndex();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceConfigurable$1", "stateChanged"));
            }
        });
        Disposer.register((Disposable)this, () -> ApplicationManager.getApplication().invokeLater(this::syncSchemaOnClose, ModalityState.NON_MODAL));
        return this.myPanel;
    }

    @Override
    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(this.getDefaultTabIndex());
    }

    @Override
    public void onUserActivity() {
        this.saveGeneralSettings(this.myTempDataSource, false, true);
        this.setConnectionStatus(null);
        this.mySshSslPanel.updateInfoLabel();
        this.myGeneralPanel.setCanConnect(DbImplUtil.canConnectTo(this.myTempDataSource));
        this.myGeneralPanel.updateDriverLink();
        this.myGeneralPanel.onActivity();
    }

    private int getDefaultTabIndex() {
        Pair p = (Pair)this.myController.getUserData(DatabaseConfigEditor.SELECTED_TAB_KEY);
        if (p == null) {
            return 0;
        }
        if ((Integer)p.second < this.myTabbedPane.getTabCount() && (Integer)p.second >= 0 && Comparing.equal((String)((String)p.first), (String)this.myTabbedPane.getTitleAt(((Integer)p.second).intValue()))) {
            return (Integer)p.second;
        }
        for (int i2 = this.myTabbedPane.getTabCount() - 1; i2 > 0; --i2) {
            if (!Comparing.equal((String)((String)p.first), (String)this.myTabbedPane.getTitleAt(i2))) continue;
            return i2;
        }
        return 0;
    }

    private void updateDefaultTabIndex() {
        Pair p = Pair.create((Object)this.myTabbedPane.getSelectedTitle(), (Object)this.myTabbedPane.getSelectedIndex());
        this.myController.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, p);
    }

    public String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    public void setGeneratedName(@NotNull String name) {
        if (name == null) {
            DataSourceConfigurable.$$$reportNull$$$0(4);
        }
        this.myNameComponent.setGeneratedName(name);
    }

    public void saveData(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(5);
        }
        this.saveGeneralSettings(dataSource, copyCredentials, actual);
        if (dataSource.getFirstSync() == ThreeState.UNSURE && this.isNewDataSource()) {
            dataSource.setFirstSync(ThreeState.YES);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(dataSource);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveProperties(dataSource.getDriverProperties());
            dataSource.setVmOptions(StringUtil.nullize((String)this.myAdvancedPanel.getVmOptions()));
            dataSource.setVmEnv(this.myAdvancedPanel.getVmEnv());
        }
        if (this.mySshSslPanel != null) {
            this.mySshSslPanel.saveData(dataSource, copyCredentials);
        }
    }

    public void saveGeneralSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(6);
        }
        dataSource.setGlobal(this.myGlobal);
        this.myNameComponent.apply(dataSource);
        this.myGeneralPanel.saveSettings(dataSource, copyCredentials, actual);
        this.mySchemasPanel.saveSettings(dataSource);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.database.dataSource.DataSourceConfigurable";
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.tools.datasource.properties";
    }

    @Nullable
    public JComponent createComponent() {
        return this.createCenterPanel();
    }

    public void apply() throws ConfigurationException {
        int ret;
        LocalDataSource tempDataSource = ((LocalDataSource)this.myDataSource).copy(this.myProject);
        this.saveData(tempDataSource, true, true);
        String error2 = StringUtil.isEmpty((String)tempDataSource.getDriverClass()) ? DatabaseMessages.message((String)"error.text.database.driver.not.configured", (Object[])new Object[0]) : null;
        if (error2 != null && (ret = Messages.showYesNoDialog((String)DatabaseMessages.message((String)"confirmation.text.error.occured.save.datasource", (Object[])new Object[]{error2}), (String)DatabaseMessages.message((String)"message.title.invalid.datasource", (Object[])new Object[0]), (Icon)Messages.getErrorIcon())) != 0) {
            return;
        }
        boolean newDataSource = this.isNewDataSource();
        boolean isGlobalChanged = !newDataSource && tempDataSource.isGlobal() != ((LocalDataSource)this.myDataSource).isGlobal();
        boolean resetConnections = !Comparing.equal((String)tempDataSource.getDriverClass(), (String)((LocalDataSource)this.myDataSource).getDriverClass()) || !tempDataSource.getClasspathElements().equals(((LocalDataSource)this.myDataSource).getClasspathElements()) || !DataSourceSshTunnelConfiguration.equal(tempDataSource.getSshConfiguration(), ((LocalDataSource)this.myDataSource).getSshConfiguration()) || !DataSourceSslConfiguration.equal(tempDataSource.getSslCfg(), ((LocalDataSource)this.myDataSource).getSslCfg());
        boolean schemaChanged = newDataSource || tempDataSource.isAutoSynchronize() && !((LocalDataSource)this.myDataSource).isAutoSynchronize() || !this.equalCredentials(tempDataSource, (LocalDataSource)this.myDataSource) || !Comparing.strEqual((String)tempDataSource.getUrl(), (String)((LocalDataSource)this.myDataSource).getUrl()) || !Comparing.equal((Object)this.myTempDataSource.getIntrospectionScope(), (Object)((LocalDataSource)this.myDataSource).getIntrospectionScope()) || !Comparing.strEqual((String)tempDataSource.getObjectPattern(), (String)((LocalDataSource)this.myDataSource).getObjectPattern());
        this.saveData((LocalDataSource)this.myDataSource, true, false);
        this.myGeneralPanel.onApply();
        this.mySshSslPanel.onApply();
        ((LocalDataSource)this.myDataSource).setFirstSync(tempDataSource.getFirstSync());
        this.updateDatabaseInfo(tempDataSource);
        if (isGlobalChanged) {
            this.myController.queueFinishTask(indicator -> {
                try {
                    indicator.setText("Moving storage of " + ((LocalDataSource)this.myDataSource).getName());
                    if (((LocalDataSource)this.myDataSource).isGlobal()) {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, this.getProject(), null);
                    } else {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, null, this.getProject());
                    }
                }
                catch (IOException e) {
                    DbUIUtil.createNotification(this.myDataSource, "Failed to migrate storage: " + e.getMessage(), NotificationType.ERROR).notify(this.myProject);
                }
            });
        }
        if (resetConnections) {
            JdbcDriverManager.getDriverManager(this.myProject).releaseDriver((LocalDataSource)this.myDataSource, null);
        }
        if (newDataSource) {
            ((DefaultDbPsiManager)this.myManager).processAddOrRemove((LocalDataSource)this.myDataSource, true);
        } else {
            ((DefaultDbPsiManager)this.myManager).fireDataSourceUpdated((LocalDataSource)this.myDataSource);
        }
        this.mySyncOnClose |= schemaChanged;
    }

    private void syncSchemaOnClose() {
        if (!this.myController.isObjectApplied(this.myDataSource)) {
            return;
        }
        if (this.mySyncOnClose) {
            DataSourceUiUtil.performAutoSyncTask(this.myProject, (LocalDataSource)this.myDataSource);
        }
    }

    public void resetFromTemp() {
        ((SettingsEditor)this.myController).bulkUpdate(() -> {
            this.myGeneralPanel.reset(this.myTempDataSource);
            this.mySchemasPanel.reset(this.myTempDataSource);
        });
    }

    @Override
    protected void reset(@NotNull LocalDataSource o) {
        if (o == null) {
            DataSourceConfigurable.$$$reportNull$$$0(7);
        }
        this.setGlobal(o.isGlobal());
        this.myGeneralPanel.reset(o);
        this.myAdvancedPanel.setVmOptions(o.getVmOptions());
        this.myAdvancedPanel.setVmEnv(o.getVmEnv());
        this.myNameComponent.reset(o, (Computable<String>)((Computable)() -> this.myGeneralPanel.generateNameFromParameters()));
        this.mySshSslPanel.reset(o);
        this.myOptionsPanel.reset(o);
        this.mySchemasPanel.reset(o);
        this.myGeneralPanel.setCanConnect(DbImplUtil.canConnectTo(o));
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        LocalDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((LocalDataSource)this.myDataSource).getName())) {
            return true;
        }
        if (tempDataSource.isUseMasterKeyStorage() != ((LocalDataSource)this.myDataSource).isUseMasterKeyStorage()) {
            return true;
        }
        if (this.myGeneralPanel.isPasswordChanged() || !Comparing.equal((String)tempDataSource.getUsername(), (String)((LocalDataSource)this.myDataSource).getUsername())) {
            return true;
        }
        if (this.mySshSslPanel.isPasswordChanged() || this.mySshSslPanel.isPassphraseChanged()) {
            return true;
        }
        return !tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource);
    }

    private boolean equalCredentials(LocalDataSource d1, LocalDataSource d2) {
        Credentials c2;
        Credentials c1;
        if (!d1.isAuthRequired() || !d2.isAuthRequired()) {
            return !d1.isAuthRequired() && !d2.isAuthRequired();
        }
        DatabaseCredentials cre = this.getSecretService();
        if (d1.isUseMasterKeyStorage() != d2.isUseMasterKeyStorage()) {
            return false;
        }
        if (!Comparing.equal((String)d1.getUsername(), (String)d2.getUsername())) {
            return false;
        }
        if (this.myGeneralPanel.isPasswordChanged() && !Comparing.equal((Object)(c1 = cre.getCredentials(d1)), (Object)(c2 = cre.getCredentials(d2)))) {
            return false;
        }
        if (this.mySshSslPanel.isPasswordChanged() || this.mySshSslPanel.isPassphraseChanged()) {
            Pair<String, String> ssh1 = cre.getSshCredentials(d1);
            Pair<String, String> ssh2 = cre.getSshCredentials(d2);
            return ssh1.equals(ssh2);
        }
        return true;
    }

    public void showErrorNotification(String message, @NotNull Object id) {
        if (id == null) {
            DataSourceConfigurable.$$$reportNull$$$0(8);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (id == null) {
                DataSourceConfigurable.$$$reportNull$$$0(11);
            }
            this.myController.showErrorNotification((Configurable)this, id, message == null ? null : "Error", message, new Object[0]);
        });
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        DatabaseDriver prevActualDriver = this.myGeneralPanel.getActualDriver();
        this.myGeneralPanel.setDriver(driver);
        DatabaseDriver newActualDriver = this.myGeneralPanel.getActualDriver();
        if (prevActualDriver != newActualDriver) {
            this.myAdvancedPanel.migrateDriver(prevActualDriver, newActualDriver);
        }
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    @NotNull
    private MyTestAction createTestAction() {
        MyTestAction myTestAction = new MyTestAction();
        if (myTestAction == null) {
            DataSourceConfigurable.$$$reportNull$$$0(9);
        }
        return myTestAction;
    }

    public Action getTestAction() {
        return this.myTestAction;
    }

    public void actualizeDriver() {
        this.setDriver(this.myGeneralPanel.getDriver());
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myGeneralPanel.getUrlEditorModel().getMeaningfullParser();
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceConfigurable.$$$reportNull$$$0(10);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.setSourceLoading(mode);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSourceForConnection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabaseInfo";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGeneratedName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveGeneralSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showErrorNotification$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTestAction
    extends AbstractAction {
        private boolean myBusy;

        public MyTestAction() {
            super(DatabaseMessages.message((String)"button.test.connection", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                MyTestAction.$$$reportNull$$$0(0);
            }
            DataSourceConfigurable.this.testConnection();
        }

        public void setBusy(boolean busy) {
            boolean o = this.isEnabled();
            this.myBusy = busy;
            boolean n = this.isEnabled();
            this.firePropertyChange("enabled", o, n);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && !this.myBusy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceConfigurable$MyTestAction", "actionPerformed"));
        }
    }
}

