/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;
import com.intellij.database.data.types.registry.PostgresBaseDomains;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PostgresDomains
extends PostgresBaseDomains {
    private static final int MAX_BIT = 0x5000000;
    private static final int MONEY_SCALE = 2;
    private static final int MAX_PRECISION = 1000;
    private static final int MAX_CHAR = 0xA00000;

    public PostgresDomains() {
        super(PostgresDialect.INSTANCE, 1000, 1000, 0xA00000, 0xA00000);
        this.add(new PostgresBaseDomains.MyZonedDomain(new FractionDomain("time with time zone", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true), "TIME"));
        this.add(new PostgresBaseDomains.MyZonedDomain(new FractionDomain("timestamp with time zone", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true), "timestamp"));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add(new FractionDomain("timestamptz", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 1000, 2, false));
        this.add(new IntegerDomain("serial", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallserial", ConversionPoint.SERIAL_NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("bigserial", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new MyTextLikeDomain("int4range", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("int8range", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("numrange", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new SimpleDomain("json", ConversionPoint.JSON, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("daterange", ConversionPoint.DATE_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("tsrange", ConversionPoint.TIMESTAMP_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("tstzrange", ConversionPoint.TIMESTAMP_TZ_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("point", ConversionPoint.POINT, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("interval", ConversionPoint.INTERVAL, PhysicalDomainType.TEXT));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, 6, true));
        this.add(new FractionDomain("timetz", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true));
        this.add(new BinaryDomain("bytea", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new TextDomain("bit", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true));
        this.add(new TextDomain("bit varying", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE));
        this.add(new TextDomain("tid", ConversionPoint.TEXT_ID, Integer.MAX_VALUE));
        this.add(new SimpleDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.TEXT));
    }

    private static class MyTextLikeDomain
    extends TextLikeDomain {
        public MyTextLikeDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type) {
            if (name == null) {
                MyTextLikeDomain.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                MyTextLikeDomain.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyTextLikeDomain.$$$reportNull$$$0(2);
            }
            super(name, descriptor, type);
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                MyTextLikeDomain.$$$reportNull$$$0(3);
            }
            Compatibility compatibility = domain instanceof MyTextLikeDomain ? (StringUtil.equals((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatible()) : super.getCompatibility(domain);
            if (compatibility == null) {
                MyTextLikeDomain.$$$reportNull$$$0(4);
            }
            return compatibility;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

