/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryDomain
extends Domain {
    private final Cardinality.ElementsCardinality myCardinality;
    private final long myUpperBound;
    private final long myDefaultValue;
    private final boolean myNarrowable;

    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long upperBound) {
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            BinaryDomain.$$$reportNull$$$0(1);
        }
        this(name, descriptor, upperBound, -1L, false);
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long upperBound, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            BinaryDomain.$$$reportNull$$$0(3);
        }
        this(name, descriptor, PhysicalDomainType.BINARY, upperBound, defaultValue, (boolean)narrowable);
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type, long upperBound, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            BinaryDomain.$$$reportNull$$$0(5);
        }
        if (type == null) {
            BinaryDomain.$$$reportNull$$$0(6);
        }
        super(descriptor, type, name);
        this.myUpperBound = upperBound;
        this.myDefaultValue = defaultValue;
        this.myNarrowable = narrowable;
        this.myCardinality = new Cardinality.ElementsCardinality(this.myUpperBound);
    }

    public long getUpperBound() {
        return this.myUpperBound;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.ElementsCardinality elementsCardinality = this.myCardinality;
        if (elementsCardinality == null) {
            BinaryDomain.$$$reportNull$$$0(7);
        }
        return elementsCardinality;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            BinaryDomain.$$$reportNull$$$0(8);
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? (((BinaryDomain)domain).getUpperBound() <= this.getUpperBound() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.uncompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            BinaryDomain.$$$reportNull$$$0(9);
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            BinaryDomain.$$$reportNull$$$0(10);
        }
        return o instanceof byte[] && this.getUpperBound() > 0L ? (Object)Arrays.copyOf((byte[])o, (int)Math.min(this.getUpperBound(), (long)((byte[])o).length)) : o;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            BinaryDomain.$$$reportNull$$$0(11);
        }
        BinaryDomain binaryDomain = this.myNarrowable && domain instanceof BinaryDomain ? new BinaryDomain(this.simpleName(), this.getPoint(), Math.min(((BinaryDomain)domain).getUpperBound(), this.getUpperBound()), this.myDefaultValue, true) : this;
        if (binaryDomain == null) {
            BinaryDomain.$$$reportNull$$$0(12);
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            BinaryDomain.$$$reportNull$$$0(13);
        }
        BinaryDomain binaryDomain = this.myNarrowable ? new BinaryDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.myUpperBound), this.myDefaultValue, true) : this;
        if (binaryDomain == null) {
            BinaryDomain.$$$reportNull$$$0(14);
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myNarrowable && this.myDefaultValue != this.getUpperBound() && this.getUpperBound() > 0L ? this.simpleName() + "(" + this.getUpperBound() + ")" : super.name();
        if (string == null) {
            BinaryDomain.$$$reportNull$$$0(15);
        }
        return string;
    }

    protected long getDefaultValue() {
        return this.myDefaultValue;
    }

    protected boolean isNarrowable() {
        return this.myNarrowable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/BinaryDomain";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/BinaryDomain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

