/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.ExecutionTargetDialog;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunSqlScriptAction
extends DumbAwareAction {
    private static final int BATCH_MAX_SIZE = 1000;
    private static final int BATCH_MAX_LENGTH = 512000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSqlScriptAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(DbSqlUtil.SQL_FILE_FILTER(project));
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = !((List)RunSqlScriptAction.getDataSources((Project)project, (JBIterable<VirtualFile>)files).second).isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(true);
        VirtualFile single = (VirtualFile)files.single();
        String title = single != null ? "'" + VfsPresentationUtil.getPresentableNameForAction((Project)project, (VirtualFile)single) + "'" : "selected files";
        e.getPresentation().setText("Run " + title + "... ");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunSqlScriptAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(DbSqlUtil.SQL_FILE_FILTER(project));
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Couple<List<DbDataSource>> dataSources2 = RunSqlScriptAction.getDataSources(project, (JBIterable<VirtualFile>)files);
        RunSqlScriptAction.chooseDataSourceAndRun(project, (List)dataSources2.first, (List)dataSources2.second, (JBIterable<VirtualFile>)files, (Processor<List<Pair<LocalDataSource, ObjectPath>>>)((Processor)selectedDataSources -> {
            RunSqlScriptAction.perform(project, (JBIterable<VirtualFile>)files, selectedDataSources);
            return true;
        }));
    }

    private static Couple<List<DbDataSource>> getDataSources(@NotNull Project project, @NotNull JBIterable<VirtualFile> files) {
        List allDataSources;
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(2);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(3);
        }
        if ((allDataSources = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources()).filter(DbImplUtil.CAN_CONNECT_TO).toList()).isEmpty()) {
            return Couple.of(Collections.emptyList(), Collections.emptyList());
        }
        boolean first = true;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList dataSources2 = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            boolean isDbFile = DbImplUtil.isDatabaseVirtualFile(file);
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null) continue;
            JBIterable<DbDataSource> o = DbImplUtil.getDataSourcesForExec(psiFile, !isDbFile, isDbFile);
            if (first) {
                o.addAllTo((Collection)dataSources2);
            } else {
                dataSources2.retainAll(o.toList());
            }
            first = false;
        }
        return Couple.of((Object)dataSources2, (Object)allDataSources);
    }

    @NotNull
    private static String getTaskName(@NotNull JBIterable<VirtualFile> files) {
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(4);
        }
        String title = files.size() == 1 ? ((VirtualFile)files.iterator().next()).getName() : files.size() + " files";
        String string = String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20)));
        if (string == null) {
            RunSqlScriptAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void perform(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @NotNull List<Pair<LocalDataSource, ObjectPath>> targets) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(7);
        }
        if (targets == null) {
            RunSqlScriptAction.$$$reportNull$$$0(8);
        }
        RunSqlScriptAction.perform(project, RunSqlScriptAction.getTaskName(files), files, targets);
    }

    public static void perform(final @NotNull Project project, @NotNull String taskName, final @NotNull JBIterable<VirtualFile> files, final @NotNull List<Pair<LocalDataSource, ObjectPath>> targets) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(9);
        }
        if (taskName == null) {
            RunSqlScriptAction.$$$reportNull$$$0(10);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(11);
        }
        if (targets == null) {
            RunSqlScriptAction.$$$reportNull$$$0(12);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RunSqlScriptAction.patchDialects(project, files, targets);
        final Ref reporter = Ref.create(null);
        final AtomicReference<ProgressIndicator> indicatorRef = new AtomicReference<ProgressIndicator>();
        Runnable runnable = () -> {
            if (project == null) {
                RunSqlScriptAction.$$$reportNull$$$0(31);
            }
            if (taskName == null) {
                RunSqlScriptAction.$$$reportNull$$$0(32);
            }
            if (files == null) {
                RunSqlScriptAction.$$$reportNull$$$0(33);
            }
            if (targets == null) {
                RunSqlScriptAction.$$$reportNull$$$0(34);
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, taskName, true, null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
                    List models = (List)ReadAction.compute(() -> {
                        if (files == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (project == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return files.map(file -> {
                            if (project == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            return PsiManager.getInstance((Project)project).findFile(file);
                        }).filter(Conditions.notNull()).map(file -> sqlPsiFacade.createScriptModel(file).subModel(null)).toList();
                    });
                    indicatorRef.set(indicator);
                    indicator.setFraction(0.0);
                    indicator.setIndeterminate(false);
                    for (ScriptModel scriptModel : models) {
                        VirtualFile virtualFile = scriptModel.getVirtualFile();
                        String title = "Run " + virtualFile.getPresentableUrl();
                        RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), MessageType.INFO, title);
                        try {
                            this.runImpl(scriptModel, indicator, models.size());
                        }
                        finally {
                            Disposer.dispose((Disposable)scriptModel);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void runImpl(@NotNull ScriptModel<?> scriptModel, @NotNull ProgressIndicator indicator, int progressMultiplier) {
                    if (scriptModel == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (indicator == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    long total = -1L;
                    long chars = -1L;
                    long executed = 0L;
                    long failed = 0L;
                    boolean aborted = false;
                    long t0 = System.currentTimeMillis();
                    for (Pair target : targets) {
                        long t1;
                        Ref doneAnything;
                        long[] counter;
                        ObjectPath destination;
                        LocalDataSource dataSource;
                        block12: {
                            dataSource = (LocalDataSource)target.first;
                            destination = target.second == null ? ObjectPaths.of((DasObject)RunSqlScriptAction.getTargetElement(project, scriptModel.getVirtualFile())) : (ObjectPath)target.second;
                            counter = new long[]{0L, 0L, 0L};
                            RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), MessageType.INFO, "Connecting to " + dataSource.getName() + "..." + (destination != null ? " (" + destination.getDisplayName() + ")" : ""));
                            doneAnything = Ref.create();
                            t1 = System.currentTimeMillis();
                            try {
                                RunSqlScriptAction.runStatements(project, dataSource, destination, scriptModel, (DataAuditor.PrintingAdapter)reporter.get(), indicator, counter, progressMultiplier * targets.size(), (Ref<Boolean>)doneAnything);
                                if (total < 0L) {
                                    total = counter[0];
                                }
                                if (chars >= 0L) break block12;
                                chars = counter[2];
                            }
                            catch (ProcessCanceledException e) {
                                try {
                                    aborted = true;
                                }
                                catch (Throwable throwable) {
                                    executed += counter[0];
                                    failed += counter[1];
                                    if (targets.size() > 1) {
                                        long t2 = System.currentTimeMillis() - t1;
                                        MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                                        RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, dataSource.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                                    }
                                    if (Boolean.TRUE.equals(doneAnything.get())) {
                                        ApplicationManager.getApplication().executeOnPooledThread(() -> DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.getConnectionContext(this.getProject(), dataSource, destination)));
                                    }
                                    throw throwable;
                                }
                                executed += counter[0];
                                failed += counter[1];
                                if (targets.size() > 1) {
                                    long t2 = System.currentTimeMillis() - t1;
                                    MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                                    RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, dataSource.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                                }
                                if (!Boolean.TRUE.equals(doneAnything.get())) break;
                                ApplicationManager.getApplication().executeOnPooledThread(() -> DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.getConnectionContext(this.getProject(), dataSource, destination)));
                                break;
                            }
                        }
                        executed += counter[0];
                        failed += counter[1];
                        if (targets.size() > 1) {
                            long t2 = System.currentTimeMillis() - t1;
                            MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                            RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, dataSource.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                        }
                        if (!Boolean.TRUE.equals(doneAnything.get())) continue;
                        ApplicationManager.getApplication().executeOnPooledThread(() -> DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.getConnectionContext(this.getProject(), dataSource, destination)));
                    }
                    long t3 = System.currentTimeMillis() - t0;
                    MessageType messageType = failed > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                    RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, "Summary: " + executed + (total < 0L ? "" : " of " + total * (long)targets.size()) + " statements executed" + (failed > 0L ? ", " + failed + " failed" : "") + " in " + StringUtil.formatDuration((long)t3) + (chars < 0L ? "" : " (" + chars + " symbols in file)") + (aborted ? " (aborted!)" : ""));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "scriptModel";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "files";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/console/RunSqlScriptAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "runImpl";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$run$2";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$null$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        };
        ConsoleView consoleView = RunSqlScriptAction.addConsole(project, taskName, files, runnable, indicatorRef);
        reporter.set((Object)new DataAuditor.ConsoleLogger(consoleView));
        runnable.run();
    }

    public static void patchDialects(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @NotNull List<Pair<LocalDataSource, ObjectPath>> targets) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(13);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(14);
        }
        if (targets == null) {
            RunSqlScriptAction.$$$reportNull$$$0(15);
        }
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        LinkedHashSet preferredDialects = ContainerUtil.newLinkedHashSet((Iterable)JBIterable.from(targets).transform(t -> DbSqlUtil.getSqlDialect((LocalDataSource)t.first)));
        SqlLanguageDialect genericDialect = DbSqlUtil.getGenericDialect();
        preferredDialects.remove(genericDialect);
        SqlLanguageDialect preferredDialect = (SqlLanguageDialect)ContainerUtil.getFirstItem((Collection)preferredDialects);
        if (preferredDialect == null) {
            return;
        }
        List remapDialect = files.filter(file -> {
            if (project == null) {
                RunSqlScriptAction.$$$reportNull$$$0(30);
            }
            return !preferredDialects.contains(LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file));
        }).toList();
        if (!remapDialect.isEmpty()) {
            WriteAction.run(() -> {
                for (VirtualFile file : remapDialect) {
                    sqlPsiFacade.setDialectMapping(file, preferredDialect);
                }
            });
        }
    }

    @Nullable
    public static Pair<LocalDataSource, ObjectPath> makeTargetPair(@NotNull LocalDataSource source, @NotNull Object object) {
        if (source == null) {
            RunSqlScriptAction.$$$reportNull$$$0(16);
        }
        if (object == null) {
            RunSqlScriptAction.$$$reportNull$$$0(17);
        }
        return object == source ? Pair.create((Object)source, null) : (object instanceof DasObject ? Pair.create((Object)source, (Object)ObjectPaths.of((DasObject)object)) : null);
    }

    @Nullable
    private static DbElement getTargetElement(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(18);
        }
        return DbImplUtil.findElement(project, file);
    }

    private static void reportAndLog(@NotNull Project project, @NotNull DataAuditor.PrintingAdapter logger, @NotNull MessageType messageType, @NotNull String message) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(19);
        }
        if (logger == null) {
            RunSqlScriptAction.$$$reportNull$$$0(20);
        }
        if (messageType == null) {
            RunSqlScriptAction.$$$reportNull$$$0(21);
        }
        if (message == null) {
            RunSqlScriptAction.$$$reportNull$$$0(22);
        }
        DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, messageType).notify(project);
        ConsoleViewContentType contentType = messageType == MessageType.ERROR ? ConsoleViewContentType.ERROR_OUTPUT : (messageType == MessageType.WARNING ? ConsoleViewContentType.LOG_WARNING_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
        logger.println(message, contentType);
    }

    @NotNull
    private static ConsoleView addConsole(@NotNull Project project, @NotNull String taskName, @NotNull JBIterable<VirtualFile> files, @NotNull Runnable rerunRunnable, @NotNull AtomicReference<ProgressIndicator> indicatorRef) {
        if (project == null) {
            RunSqlScriptAction.$$$reportNull$$$0(23);
        }
        if (taskName == null) {
            RunSqlScriptAction.$$$reportNull$$$0(24);
        }
        if (files == null) {
            RunSqlScriptAction.$$$reportNull$$$0(25);
        }
        if (rerunRunnable == null) {
            RunSqlScriptAction.$$$reportNull$$$0(26);
        }
        if (indicatorRef == null) {
            RunSqlScriptAction.$$$reportNull$$$0(27);
        }
        ConsoleView consoleView = DbUIUtil.addConsole(project, taskName, () -> {
            if (files == null) {
                RunSqlScriptAction.$$$reportNull$$$0(29);
            }
            for (VirtualFile file : files) {
                if (file.isValid()) continue;
                return false;
            }
            return true;
        }, rerunRunnable, indicatorRef);
        if (consoleView == null) {
            RunSqlScriptAction.$$$reportNull$$$0(28);
        }
        return consoleView;
    }

    public static void runStatements(Project project, LocalDataSource dataSource, ObjectPath destination, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter) {
        RunSqlScriptAction.runStatements(project, dataSource, destination, scriptModel, reporter, (ProgressIndicator)new EmptyProgressIndicator(), new long[3], 1, null);
    }

    private static void runStatements(Project project, LocalDataSource dataSource, ObjectPath destination, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter, ProgressIndicator progress, long[] counter, int progressMultiplier, Ref<Boolean> doneAnything) {
        Runner r = new Runner(project, dataSource, destination, scriptModel.getVirtualFile(), reporter);
        r.withConnected(() -> {
            try {
                r.prepare();
                progress.checkCanceled();
                progress.setText(dataSource.getName());
                if (r.connection == null) {
                    reporter.error("Unable to acquire connection", null);
                    return;
                }
                counter[2] = 0L;
                boolean inBatch = false;
                TokenSet dmlSet = TokenSet.create((IElementType[])new IElementType[]{SqlTokenRegistry.findCompositeType((String)"SQL_INSERT_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_UPDATE_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_DELETE_STATEMENT")});
                Condition notDml = o -> !dmlSet.contains(o.type());
                for (JBIterable itGroup : scriptModel.statements().split(JBIterable.Split.GROUP, notDml)) {
                    if (doneAnything != null) {
                        doneAnything.set((Object)true);
                    }
                    double fraction = -1.0;
                    if (inBatch) {
                        reporter.print("");
                    }
                    inBatch = false;
                    for (ScriptModel.StatementIt it : itGroup) {
                        progress.checkCanceled();
                        String sql = it.text();
                        if (!inBatch) {
                            reporter.println(StringUtil.first((String)sql, (int)240, (boolean)true), ConsoleViewContentType.USER_INPUT);
                            progress.setText2(StringUtil.first((String)sql, (int)120, (boolean)true));
                        }
                        counter[0] = counter[0] + 1L;
                        counter[2] = counter[2] + (long)sql.length();
                        long curOffset = it.rangeOffset() + (long)it.range().getEndOffset();
                        fraction = (double)curOffset * r.averageBytesPerChar / (double)r.fileSize / (double)progressMultiplier;
                        if (!r.batchUpdatesSupported || notDml.value((Object)it)) {
                            r.runSingle(sql);
                            progress.setFraction(fraction);
                        } else {
                            if (r.batchCount % 10L == 1L) {
                                reporter.rawPrint(".", ConsoleViewContentType.USER_INPUT);
                            }
                            inBatch = true;
                            r.addBatch(sql);
                            if (r.batchCount >= 1000L || r.batchLength >= 512000L) {
                                reporter.print("");
                                r.runBatch();
                                progress.setFraction(fraction);
                            }
                        }
                        counter[1] = counter[1] + r.getAndResetFailCount();
                    }
                    if (inBatch) {
                        reporter.print("");
                        r.runBatch();
                        progress.setFraction(fraction);
                    }
                    counter[1] = counter[1] + r.getAndResetFailCount();
                }
            }
            catch (TooLongStatementException e) {
                reporter.error(e.getMessage() + ". Increasing memory via -Xmx may help. Aborting.", null);
            }
            finally {
                counter[1] = counter[1] + r.getAndResetFailCount();
                Disposer.dispose((Disposable)scriptModel);
            }
        });
    }

    private static void chooseDataSourceAndRun(Project project, List<DbDataSource> dataSources2, List<DbDataSource> allDataSources, JBIterable<VirtualFile> files, Processor<List<Pair<LocalDataSource, ObjectPath>>> processor) {
        ExecutionTargetDialog dialog = new ExecutionTargetDialog(project, (Function<Boolean, Iterable<LocalDataSource>>)((Function)all -> JBIterable.from((Iterable)(all != false ? allDataSources : dataSources2)).transform(ds -> ds.getDelegate()).filter(LocalDataSource.class)), (Consumer<List<Pair<LocalDataSource, ObjectPath>>>)((Consumer)pairs2 -> processor.process(pairs2)));
        dialog.checkFilesForSchemaSwitches(files);
        dialog.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/RunSqlScriptAction";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 10: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunRunnable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/RunSqlScriptAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "addConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTaskName";
                break;
            }
            case 5: 
            case 28: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchDialects";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeTargetPair";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportAndLog";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addConsole";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addConsole$5";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$patchDialects$3";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$perform$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Runner {
        final Project project;
        final LocalDataSource dataSource;
        final ObjectPath destination;
        final DataAuditor.PrintingAdapter reporter;
        final SqlLanguageDialect dialect;
        long fileSize;
        double averageBytesPerChar;
        boolean batchUpdatesSupported;
        DatabaseConnection connection;
        Statement statement;
        long failCount;
        long batchCount;
        long batchLength;

        Runner(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable ObjectPath destination, @NotNull VirtualFile virtualFile, DataAuditor.PrintingAdapter reporter) {
            if (project == null) {
                Runner.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                Runner.$$$reportNull$$$0(1);
            }
            if (virtualFile == null) {
                Runner.$$$reportNull$$$0(2);
            }
            this.project = project;
            this.dataSource = dataSource;
            this.destination = destination;
            this.reporter = reporter;
            this.dialect = DbSqlUtil.getSqlDialect(dataSource);
            this.fileSize = virtualFile.getLength();
            this.averageBytesPerChar = virtualFile.getCharset().newEncoder().averageBytesPerChar();
        }

        long getAndResetFailCount() {
            long result2 = this.failCount;
            this.failCount = 0L;
            return result2;
        }

        void prepare() {
            try {
                if (!this.dialect.getDatabaseDialect().getFamilyId().isTransactSql()) {
                    DatabaseMetaData metaData = this.connection.getMetaData();
                    boolean bl = this.batchUpdatesSupported = metaData != null && metaData.supportsBatchUpdates();
                    if (this.batchUpdatesSupported) {
                        this.reporter.print("Using batch mode (1000 insert/update/delete statements max)");
                    }
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
            }
            if (this.destination != null) {
                DatabaseEditorHelper.setCurrentSchemaSafe((DatabaseDialectEx)this.dialect.getDatabaseDialect(), this.destination, this.connection);
            }
        }

        public void withConnected(@NotNull Runnable r) {
            if (r == null) {
                Runner.$$$reportNull$$$0(3);
            }
            ErrorHandler handler = new ErrorHandler();
            try {
                DatabaseConnectionManager.getInstance().build(this.project, this.dataSource).setDestination(this.destination).sync(connection -> {
                    if (r == null) {
                        Runner.$$$reportNull$$$0(4);
                    }
                    try {
                        this.connection = connection;
                        this.statement = connection.createStatement();
                        r.run();
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        this.connection = null;
                        if (this.statement != null) {
                            JdbcUtil.closeStatementSafe((Statement)this.statement);
                        }
                    }
                }, handler);
            }
            catch (ProcessCanceledException e) {
                if (handler.hasErrors()) {
                    this.reporter.error(handler.getSummary(), null);
                }
                throw e;
            }
            catch (Exception e) {
                this.reporter.error(null, e);
            }
        }

        public void runSingle(String sql) {
            try {
                int updateCount;
                long updateTotal = -1L;
                long timestamp = System.currentTimeMillis();
                boolean resultSetHere = this.statement.execute(sql);
                String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                int n = updateCount = resultSetHere ? -1 : JdbcEngine.getUpdateCountSafe(this.statement);
                do {
                    if (updateCount >= 0) {
                        if (updateTotal < 0L) {
                            updateTotal = 0L;
                        }
                        updateTotal += (long)updateCount;
                    }
                    int n2 = updateCount = (resultSetHere = this.statement.getMoreResults()) ? -1 : JdbcEngine.getUpdateCountSafe(this.statement);
                } while (resultSetHere || updateCount != -1);
                if (updateTotal >= 0L) {
                    this.reporter.print(updateTotal + " row(s) affected in " + executionTime);
                } else {
                    this.reporter.print("completed in " + executionTime);
                }
            }
            catch (Exception ex) {
                ++this.failCount;
                if (DbImplUtil.isRemoteProcessDown(ex)) {
                    this.reporter.error("Connection is closed", null);
                    throw new ProcessCanceledException();
                }
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
            }
        }

        public void addBatch(String sql) {
            if (!this.batchUpdatesSupported) {
                this.runSingle(sql);
                return;
            }
            try {
                this.statement.addBatch(sql);
                ++this.batchCount;
                this.batchLength += (long)sql.length();
            }
            catch (SQLException e) {
                this.batchUpdatesSupported = false;
                if (this.batchCount > 0L) {
                    this.runBatch();
                }
                this.runSingle(sql);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runBatch() {
            if (!this.batchUpdatesSupported) {
                return;
            }
            if (this.batchCount == 0L) {
                return;
            }
            try {
                int[] longs;
                long updateCount = 0L;
                long timestamp = System.currentTimeMillis();
                int[] nArray = longs = this.statement.executeBatch();
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    long c = nArray[j];
                    if (c >= 0L) {
                        updateCount += c;
                        continue;
                    }
                    if (c != -3L) continue;
                    ++this.failCount;
                }
                String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                if (updateCount == 0L) {
                    this.reporter.print("completed in " + executionTime);
                } else {
                    this.reporter.print(updateCount + " row(s) affected in " + executionTime);
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
                this.failCount += this.batchCount;
            }
            finally {
                try {
                    this.statement.clearBatch();
                }
                catch (SQLException e) {
                    this.reporter.error(JdbcEngine.getErrorMessage(e, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
                }
                this.batchCount = 0L;
                this.batchLength = 0L;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/RunSqlScriptAction$Runner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withConnected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$withConnected$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

