/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.console.BaseJdbcSession;
import com.intellij.database.console.BaseJdbcSessionView;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.session.SessionToolWindowHelper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JdbcSessionToolWindowHelper
extends SessionToolWindowHelper {
    public static final String SESSION_TOOLWINDOW_ID = DatabaseMessages.message((String)"jdbc.console.tab.title", (Object[])new Object[0]);
    static final JdbcSessionToolWindowHelper INSTANCE = new JdbcSessionToolWindowHelper();
    private static final Map<Project, ConsoleToolWindowStateTracker> ourTrackers = ContainerUtil.newIdentityHashMap();

    JdbcSessionToolWindowHelper() {
        super(SESSION_TOOLWINDOW_ID, DatabaseIcons.ToolWindowConsole);
    }

    @Override
    protected void setup(@NotNull Project project, @NotNull ToolWindowEx toolWindow) {
        if (project == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(1);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        MyAutoScrollFromHandler scrollFromHandler = new MyAutoScrollFromHandler(project, toolWindow);
        MyAutoScrollToHandler scrollToHandler = new MyAutoScrollToHandler(project, toolWindow);
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll from Editor", (Getter<Boolean>)((Getter)scrollFromHandler::isAutoScrollEnabled), (Setter<Boolean>)((Setter)scrollFromHandler::setAutoScrollEnabled)));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll to Editor", (Getter<Boolean>)((Getter)scrollToHandler::isAutoScrollMode), (Setter<Boolean>)((Setter)scrollToHandler::setAutoScrollMode)));
        toolWindow.setAdditionalGearActions((ActionGroup)group2);
        ScrollFromEditorAction scrollFromEditorAction = new ScrollFromEditorAction(scrollFromHandler);
        scrollFromEditorAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.LocateHover);
        toolWindow.setTitleActions(new AnAction[]{scrollFromEditorAction});
        JdbcSessionToolWindowHelper.installToolWindowManagerListener(project);
    }

    private static void installToolWindowManagerListener(@NotNull Project project) {
        if (project == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(2);
        }
        ToolWindowManagerEx manager = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project);
        ConsoleToolWindowStateTracker listener = new ConsoleToolWindowStateTracker(project);
        ConsoleToolWindowStateTracker old = ourTrackers.put(project, listener);
        if (old != null) {
            Disposer.dispose((Disposable)old);
        }
        Disposer.register((Disposable)project, (Disposable)listener);
        manager.addToolWindowManagerListener((ToolWindowManagerListener)listener, (Disposable)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroy(@NotNull Project project, @NotNull ToolWindow w, @NotNull ToolWindowManager manager) {
        if (project == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(3);
        }
        if (w == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(5);
        }
        try {
            super.destroy(project, w, manager);
        }
        finally {
            JdbcSessionToolWindowHelper.stopTrackToolWindowState(project);
        }
    }

    public static void stopTrackToolWindowState(@NotNull Project project) {
        ConsoleToolWindowStateTracker listener;
        if (project == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(6);
        }
        if ((listener = ourTrackers.get(project)) != null) {
            Disposer.dispose((Disposable)listener);
        }
    }

    public static boolean wasActiveLastTime(@NotNull Project project) {
        if (project == null) {
            JdbcSessionToolWindowHelper.$$$reportNull$$$0(7);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean("database.console.LAST_STATE", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/console/JdbcSessionToolWindowHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installToolWindowManagerListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "destroy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "stopTrackToolWindowState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "wasActiveLastTime";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConsoleToolWindowStateTracker
    extends ToolWindowManagerAdapter
    implements Disposable {
        private static final String PROPERTY_LAST_CONSOLE_STATE = "database.console.LAST_STATE";
        private final Project myProject;

        ConsoleToolWindowStateTracker(@NotNull Project project) {
            if (project == null) {
                ConsoleToolWindowStateTracker.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void stateChanged() {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(SESSION_TOOLWINDOW_ID);
            PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
            properties.setValue(PROPERTY_LAST_CONSOLE_STATE, String.valueOf(window != null && window.isVisible()));
        }

        public void dispose() {
            ourTrackers.remove(this.myProject, (Object)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcSessionToolWindowHelper$ConsoleToolWindowStateTracker", "<init>"));
        }
    }

    private static class ScrollFromEditorAction
    extends DumbAwareAction {
        private final MyAutoScrollFromHandler myScrollFromHandler;

        ScrollFromEditorAction(MyAutoScrollFromHandler scrollFromHandler) {
            super("Scroll from Editor", "Select console open in the active editor", AllIcons.General.Locate);
            this.myScrollFromHandler = scrollFromHandler;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor[] editors = manager.getSelectedEditors();
            if (editors.length == 0) {
                return;
            }
            for (FileEditor editor : editors) {
                if (!this.myScrollFromHandler.select(editor)) continue;
                return;
            }
        }
    }

    private static class MyAutoScrollToHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_TO_SOURCE";
        private final Project myProject;
        private boolean myEnabled;

        MyAutoScrollToHandler(final @NotNull Project project, @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(ContentManagerEvent event) {
                    if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                        TransactionGuard.submitTransaction((Disposable)project, () -> this.selectContentEditor(event.getContent()));
                    }
                }
            });
        }

        protected boolean isAutoScrollMode() {
            return this.myEnabled;
        }

        protected void setAutoScrollMode(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        private void selectContentEditor(@NotNull Content content) {
            if (content == null) {
                MyAutoScrollToHandler.$$$reportNull$$$0(2);
            }
            if (!this.myEnabled || !this.myProject.isOpen()) {
                return;
            }
            FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject);
            VirtualFile currentFile = manager.getCurrentFile();
            BaseJdbcSession<?> currentSession = currentFile == null ? null : DatabaseEditorHelper.findSession(currentFile, (FileEditorManager)manager);
            BaseJdbcSession session = (BaseJdbcSession)AbstractQueryLanguageConsole.getSessionIfPresent(content);
            if (session == null || currentSession == session) {
                return;
            }
            VirtualFile virtualFile = session.getVirtualFile();
            manager.openFile(virtualFile, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcSessionToolWindowHelper$MyAutoScrollToHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectContentEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAutoScrollFromHandler
    extends AutoScrollFromSourceHandler {
        private static final String PROPERTY = "database.console.AUTO_SCROLL_FROM_SOURCE";
        private boolean myEnabled;

        MyAutoScrollFromHandler(@NotNull Project project, @NotNull ToolWindowEx toolWindow) {
            if (project == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(1);
            }
            super(project, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
            this.myEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(PROPERTY, true);
            this.install();
        }

        protected boolean isAutoScrollEnabled() {
            return this.myEnabled;
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            this.myEnabled = enabled;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PROPERTY, enabled, true);
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(2);
            }
            this.select(editor);
        }

        boolean select(@NotNull FileEditor editor) {
            BaseJdbcSessionView view;
            FileEditorManagerEx manager;
            VirtualFile virtualFile;
            if (editor == null) {
                MyAutoScrollFromHandler.$$$reportNull$$$0(3);
            }
            if ((virtualFile = (manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject)).getFile(editor)) == null) {
                return false;
            }
            BaseJdbcSession<?> console = DatabaseEditorHelper.findSession(virtualFile, (FileEditorManager)manager);
            BaseJdbcSessionView baseJdbcSessionView = view = console == null ? null : (BaseJdbcSessionView)console.getView();
            if (view != null && view.isToolWindowContentPresent()) {
                view.show(true, false);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcSessionToolWindowHelper$MyAutoScrollFromHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

