/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.BaseJdbcSession;
import com.intellij.database.console.JdbcSessionToolWindowHelper;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.audit.JdbcSessionLogger;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.BaseSessionView;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BaseJdbcSessionView<S extends BaseJdbcSession<?>>
extends BaseSessionView<S>
implements Disposable.Parent {
    private final AnAction myTerminateAction;

    public BaseJdbcSessionView(@NotNull LanguageConsoleView languageConsole, @NotNull S session, @NotNull DataBus.Consuming messageBus) {
        if (languageConsole == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(0);
        }
        if (session == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(1);
        }
        if (messageBus == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(2);
        }
        super(languageConsole.getProject(), messageBus, languageConsole, JdbcSessionToolWindowHelper.INSTANCE, session);
        languageConsole.setPrompt("sql> ");
        this.myTerminateAction = new TerminateAction();
        JComponent shortcutTarget = this.getConsoleView().getConsoleEditor().getComponent();
        EmptyAction.setupAction((AnAction)this.myTerminateAction, (String)"Console.Jdbc.Terminate", (JComponent)shortcutTarget);
    }

    @NotNull
    public AnAction getTerminateAction() {
        AnAction anAction = this.myTerminateAction;
        if (anAction == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(3);
        }
        return anAction;
    }

    public boolean isToolWindowContentPresent() {
        return this.getContent().getManager() != null;
    }

    public void beforeTreeDispose() {
        ContentManager contentManager;
        Project project = this.getProject();
        ToolWindow window = this.getToolWindowHelper().getToolWindow(project);
        ContentManager contentManager2 = contentManager = window == null ? null : window.getContentManager();
        if (contentManager == null) {
            return;
        }
        Content[] contents = contentManager.getContents();
        if (contents.length == 1 && contents[0] == this.getContent()) {
            JdbcSessionToolWindowHelper.stopTrackToolWindowState(project);
        }
    }

    @Override
    @NotNull
    protected SessionLogger createAuditor() {
        JdbcSessionLogger jdbcSessionLogger = new JdbcSessionLogger(this);
        if (jdbcSessionLogger == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(4);
        }
        return jdbcSessionLogger;
    }

    @Override
    protected void buildConsoleUi(boolean focused) {
        this.getUi().getDefaults().initTabDefaults(0, this.getToolWindowHelper().getToolWindowId(), null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getConsoleView().getComponent(), (Object)"Center");
        final String title = DatabaseMessages.message((String)"jdbc.console.tab.title.console", (Object[])new Object[0]);
        JComponent toFocus = this.getConsoleView().getHistoryViewer().getContentComponent();
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, title, AllIcons.Debugger.Console, toFocus);
        DefaultActionGroup outputActions = new DefaultActionGroup();
        DbUIUtil.addLeftToolbarConsoleActions(outputActions, (ConsoleView)this.getConsoleView());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getConsoleView().getComponent());
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        this.populateActionGroup(consoleActions);
        for (AnAction action : consoleActions.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        this.getUi().getOptions().setLeftToolbar((ActionGroup)consoleActions, "toolbar");
        this.getConsoleView().setConsoleEditorEnabled(false);
        if (focused) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(this.getConsoleView().getVirtualFile(), true);
        }
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
        this.getUi().getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                BaseJdbcSession session = (BaseJdbcSession)BaseJdbcSessionView.this.getSession();
                if (!session.isValid()) {
                    return;
                }
                if (title.equals(event.getContent().getDisplayName())) {
                    FileEditorManager.getInstance((Project)BaseJdbcSessionView.this.getProject()).openFile(session.getVirtualFile(), true, true);
                }
            }
        });
    }

    @Override
    protected boolean readyToDie() {
        return false;
    }

    protected void populateActionGroup(@NotNull DefaultActionGroup group2) {
        if (group2 == null) {
            BaseJdbcSessionView.$$$reportNull$$$0(5);
        }
        group2.add(this.myTerminateAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/BaseJdbcSessionView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/BaseJdbcSessionView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminateAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateActionGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TerminateAction
    extends DumbAwareAction {
        TerminateAction() {
            super(null, null, AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TerminateAction.$$$reportNull$$$0(0);
            }
            BaseJdbcSession session = (BaseJdbcSession)BaseJdbcSessionView.this.getSession();
            session.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(session));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TerminateAction.$$$reportNull$$$0(1);
            }
            BaseJdbcSession session = (BaseJdbcSession)BaseJdbcSessionView.this.getSession();
            e.getPresentation().setEnabled(session.isValid() && !session.isIdle());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/console/BaseJdbcSessionView$TerminateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

