/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PostgresConfigurationBase
extends CliConfigurationBase {
    protected PostgresConfigurationBase(@NotNull CliArgumentGroup<? extends CliArgument>[] groups, @NotNull String[] fileArgs, @NotNull String propertyKey, @NotNull String name) {
        if (propertyKey == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(1);
        }
        if (groups == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(2);
        }
        if (fileArgs == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(3);
        }
        super(groups, CommonPgArguments.HOST, CommonPgArguments.PORT, CommonPgArguments.USER, CommonPgArguments.PASSWORD, fileArgs, "PGPASSWORD", propertyKey, name);
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        HashMap map = ContainerUtil.newHashMap();
        PostgresConfigurationBase.put(map, "Require names matching", CommonPgArguments.STRICT_NAMES);
        PostgresConfigurationBase.put(map, "Database name", CommonPgArguments.DB_NAME);
        PostgresConfigurationBase.put(map, "Concurrent jobs count", CommonPgArguments.JOBS);
        PostgresConfigurationBase.put(map, "Output for generated data", CommonPgArguments.FILE);
        PostgresConfigurationBase.put(map, "Off ownership commands", CommonPgArguments.NO_OWNER);
        PostgresConfigurationBase.put(map, "Obsolete", CommonPgArguments.NO_RECONNECT);
        PostgresConfigurationBase.put(map, "Superuser user name", CommonPgArguments.SUPERUSER);
        PostgresConfigurationBase.put(map, "Verbose mode", CommonPgArguments.VERBOSE);
        PostgresConfigurationBase.put(map, "Print version", CommonPgArguments.VERSION);
        PostgresConfigurationBase.put(map, "Turn off grant/revoke", CommonPgArguments.NO_PRIVILEGES);
        PostgresConfigurationBase.put(map, "Don't select tablespaces", "--no-tablespaces");
        PostgresConfigurationBase.put(map, "Output SET SESSION AUTHORIZATION", "--use-set-session-authorization");
        PostgresConfigurationBase.put(map, "Show help", CommonPgArguments.HELP);
        PostgresConfigurationBase.put(map, "Host name", CommonPgArguments.HOST);
        PostgresConfigurationBase.put(map, "TCP port", CommonPgArguments.PORT);
        PostgresConfigurationBase.put(map, "User name", CommonPgArguments.USER);
        PostgresConfigurationBase.put(map, "Restore in single transaction", CommonPgArguments.SINGLE_TX);
        PostgresConfigurationBase.put(map, "Never issue a password prompt", CommonPgArguments.NO_PASSWORD);
        PostgresConfigurationBase.put(map, "Force prompt password", CommonPgArguments.NO_PASSWORD);
        PostgresConfigurationBase.put(map, "Role name", CommonPgArguments.ROLE);
        PostgresConfigurationBase.put(map, "Set on row_security", "--enable-row-security");
        HashMap hashMap = map;
        if (hashMap == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public LexemeIndicators getPasswordIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(CommonPgArguments.NO_PASSWORD, false, true);
        if (lexemeIndicators == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(5);
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(6);
        }
        ContainerUtil.removeAll(variants, (Object[])CommonPgArguments.PASSWORD);
        List<String> list = variants;
        if (list == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static String windowsArg(@NotNull String arg) {
        if (arg == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(8);
        }
        Matcher matcher = Pattern.compile("(\\\\+)($|\")").matcher(arg);
        String string = matcher.replaceAll("$1$1$2");
        if (string == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.list((Object[])new String[]{"-f", "-F", "-j", "-n", "-S", "-t", "-T", "-d", "-h", "-p", "-U"});
        if (list == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterProcessor getParameterProcessor() {
        MyProcessor myProcessor = MyProcessor.INSTANCE;
        if (myProcessor == null) {
            PostgresConfigurationBase.$$$reportNull$$$0(11);
        }
        return myProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/PostgresConfigurationBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/PostgresConfigurationBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPasswordIndicators";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakAutocompletion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "windowsArg";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tweakAutocompletion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "windowsArg";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessor
    extends CliConfigurationBase.CliParameterProcessorBase {
        static final MyProcessor INSTANCE = new MyProcessor();

        private MyProcessor() {
        }

        @Override
        @NotNull
        public String process(@NotNull CliLexeme lexeme, @NotNull String parameter) {
            if (lexeme == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            String text = lexeme.getText();
            boolean isTable = ArrayUtil.contains((String)text, (String[])CommonPgArguments.TABLE);
            boolean isSchema = ArrayUtil.contains((String)text, (String[])CommonPgArguments.SCHEMA);
            String string = isTable ? MyProcessor.processTable(parameter) : (isSchema ? MyProcessor.processSimple(super.process(lexeme, parameter)) : super.process(lexeme, parameter));
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private static String processTable(@NotNull String parameter) {
            List splitted;
            if (parameter == null) {
                MyProcessor.$$$reportNull$$$0(3);
            }
            if ((splitted = StringUtil.splitHonorQuotes((String)DbCliUtil.unescapeAll(parameter), (char)'.')).size() != 2) {
                String string = MyProcessor.processSimple(parameter);
                if (string == null) {
                    MyProcessor.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = MyProcessor.processSimple((String)splitted.get(0)) + "." + MyProcessor.processSimple((String)splitted.get(1));
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private static String processSimple(@NotNull String parameter) {
            if (parameter == null) {
                MyProcessor.$$$reportNull$$$0(6);
            }
            String unquoted = StringUtil.unquoteString((String)parameter).replaceAll("\"", "\"\"");
            String processed = SystemInfo.isWindows ? PostgresConfigurationBase.windowsArg(unquoted) : unquoted;
            String string = StringUtil.isQuotedString((String)parameter) || !StringUtil.equals((CharSequence)parameter, (CharSequence)StringUtil.toLowerCase((String)parameter)) ? StringUtil.wrapWithDoubleQuote((String)processed) : processed;
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lexeme";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/PostgresConfigurationBase$MyProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processTable";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processSimple";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processTable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processSimple";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

