/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ImportDataSourceAction
extends AnAction {
    public boolean isDumbAware() {
        return false;
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        DataSourceDetector[] detectors = (DataSourceDetector[])Extensions.getExtensions((ExtensionPointName)DataSourceDetector.EP_NAME);
        boolean enabled = project != null && detectors.length != 0;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ImportDataSourceAction.doImportAction(project, false);
    }

    public static boolean doImportAction(@NotNull Project project, boolean newOnly) {
        if (project == null) {
            ImportDataSourceAction.$$$reportNull$$$0(0);
        }
        DataSourceRegistry registry = new DataSourceRegistry(project);
        DataSourceDetector[] detectors = (DataSourceDetector[])Extensions.getExtensions((ExtensionPointName)DataSourceDetector.EP_NAME);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (project == null) {
                ImportDataSourceAction.$$$reportNull$$$0(1);
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setIndeterminate(false);
            indicator.setText(DatabaseMessages.message((String)"message.discovering.datasources.to.import", (Object[])new Object[0]));
            double totalProgress = detectors.length;
            double curProgress = 0.0;
            for (DataSourceDetector detector : detectors) {
                indicator.setFraction((curProgress += 1.0) / totalProgress);
                String simpleName = StringUtil.trimEnd((String)detector.getClass().getSimpleName(), (String)DataSourceDetector.class.getSimpleName());
                indicator.setText2("Looking for " + simpleName + " connections...");
                ReadAction.run(() -> {
                    if (project == null) {
                        ImportDataSourceAction.$$$reportNull$$$0(2);
                    }
                    detector.collectDataSources(project, registry.getBuilder());
                });
            }
        }, DatabaseMessages.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), true, project);
        if (newOnly) {
            registry.retainNewOnly();
        }
        if (registry.isEmpty()) {
            Messages.showMessageDialog((Project)project, (String)DatabaseMessages.message((String)"message.no.datasources.to.import.found", (Object[])new Object[0]), (String)DatabaseMessages.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            return true;
        }
        return DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project), registry);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/database/actions/ImportDataSourceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doImportAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doImportAction$1";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

