/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.BasicElementAction;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.impl.ModelDescribing;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.util.containers.MultiMap;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DumpModelEntityDebugAction
extends BasicElementAction<BasicNode> {
    private transient boolean useSurrogates = false;

    @Override
    @Nullable
    protected BasicNode cast(@Nullable BasicNode node) {
        return node;
    }

    @Override
    protected void doIt(@NotNull AnActionEvent e, @NotNull Project project, @NotNull MultiMap<BasicModel, BasicNode> selection) {
        if (e == null) {
            DumpModelEntityDebugAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DumpModelEntityDebugAction.$$$reportNull$$$0(1);
        }
        if (selection == null) {
            DumpModelEntityDebugAction.$$$reportNull$$$0(2);
        }
        Dump dump = new Dump(selection.values());
        dump.doIt();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "selection";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/actions/DumpModelEntityDebugAction";
        objectArray[2] = "doIt";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class Dump
    implements Disposable {
        private final Collection<? extends BasicNode> nodes;
        private final EditorFactory editorFactory;
        private final Document document;
        private final Editor viewer;
        private RefreshAction refreshAction;
        private transient boolean ready;

        public Dump(Collection<? extends BasicNode> nodes2) {
            if (nodes2 == null) {
                Dump.$$$reportNull$$$0(0);
            }
            this.ready = false;
            this.nodes = nodes2;
            this.editorFactory = EditorFactory.getInstance();
            this.document = this.editorFactory.createDocument((CharSequence)"");
            this.viewer = this.editorFactory.createViewer(this.document);
        }

        public void doIt() {
            JComponent viewerComponent = this.viewer.getComponent();
            viewerComponent.setMinimumSize(new Dimension(200, 200));
            viewerComponent.setPreferredSize(new Dimension(500, 500));
            ToggleAction withSurrogatesAction = new ToggleAction("with synthetic stuff", "Include auto-generated objects and names", AllIcons.Webreferences.Server){

                public boolean isSelected(AnActionEvent e) {
                    return DumpModelEntityDebugAction.this.useSurrogates;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    DumpModelEntityDebugAction.this.useSurrogates = state;
                    Dump.this.populateDocument();
                }
            };
            this.refreshAction = new RefreshAction("Refresh", "", AllIcons.Actions.Refresh){

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(Dump.this.ready);
                }

                public void actionPerformed(AnActionEvent e) {
                    Dump.this.populateDocument();
                }
            };
            this.refreshAction.registerShortcutOn(viewerComponent);
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DbDump", (ActionGroup)new DefaultActionGroup(new AnAction[]{withSurrogatesAction, this.refreshAction}), true);
            toolbar.setTargetComponent(viewerComponent);
            DialogBuilder dia = new DialogBuilder();
            dia.setTitle("Database Model Dump");
            dia.setNorthPanel(toolbar.getComponent());
            dia.setCenterPanel(viewerComponent);
            dia.setPreferredFocusComponent(this.viewer.getContentComponent());
            dia.addDisposable((Disposable)this);
            dia.setDimensionServiceKey(DumpModelEntityDebugAction.class.getSimpleName());
            dia.showNotModal();
            this.populateDocument();
        }

        private synchronized void populateDocument() {
            this.ready = false;
            try {
                String text = ModelDescribing.describeForest(this.nodes, DumpModelEntityDebugAction.this.useSurrogates);
                ApplicationManager.getApplication().runWriteAction(() -> this.document.setText((CharSequence)text));
            }
            finally {
                this.ready = true;
            }
        }

        public void dispose() {
            this.editorFactory.releaseEditor(this.viewer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/database/actions/DumpModelEntityDebugAction$Dump", "<init>"));
        }
    }
}

