/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliDialog;
import com.intellij.database.cli.dump.DumpConfigurationsHolder;
import com.intellij.database.cli.restore.RestoreConfigurationsHolder;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseCliAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        LocalDataSource dataSource = DatabaseCliAction.getDataSource(e);
        CliConfigurationPack configurations = dataSource == null ? null : this.getConfigurations(DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        List selected = DatabaseCliAction.getSelectedElements(project).toList();
        CliConfigurationPack filtered = configurations == null ? null : configurations.filtered(selected);
        boolean enabled = project != null && configurations != null && DatabaseCliAction.isHostAndPortExists(dataSource) && !filtered.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            e.getPresentation().setText(this.getText(filtered, dataSource, true));
        }
    }

    @NotNull
    protected abstract String getMask();

    @NotNull
    protected abstract String getCommonText(boolean var1);

    @Nullable
    public abstract CliConfigurationPack getConfigurations(@NotNull DatabaseFamilyId var1);

    public void actionPerformed(AnActionEvent e) {
        LocalDataSource dataSource = DatabaseCliAction.getDataSource(e);
        if (dataSource == null) {
            return;
        }
        DatabaseFamilyId id = DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource);
        List selected = DatabaseCliAction.getSelectedElements(e.getProject()).toList();
        CliConfigurationPack configurations = ((CliConfigurationPack)ObjectUtils.notNull((Object)this.getConfigurations(id))).filtered(selected);
        Project project = (Project)ObjectUtils.notNull((Object)e.getProject());
        String dialogTitle = this.getText(configurations, dataSource, false);
        CliDialog dialog = new CliDialog(project, dataSource, selected, configurations, dialogTitle);
        dialog.show();
    }

    @NotNull
    private String getText(@NotNull CliConfigurationPack configurations, @NotNull DatabaseSystem system, boolean action) {
        if (configurations == null) {
            DatabaseCliAction.$$$reportNull$$$0(0);
        }
        if (system == null) {
            DatabaseCliAction.$$$reportNull$$$0(1);
        }
        String string = (configurations.isSingleConfiguration() ? this.getOneConfigurationText(configurations, action) : this.getCommonText(action)) + (action ? "" : String.format(" (%s)", system.getName()));
        if (string == null) {
            DatabaseCliAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String getOneConfigurationText(@NotNull CliConfigurationPack configurations, boolean action) {
        if (configurations == null) {
            DatabaseCliAction.$$$reportNull$$$0(3);
        }
        String name = configurations.first().getName();
        String string = String.format(this.getMask(), action ? "'" + StringUtil.escapeMnemonics((String)name) + "'" : name);
        if (string == null) {
            DatabaseCliAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElements(@Nullable Project project) {
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseCliAction.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        DatabaseView view = DatabaseView.getDatabaseView(project);
        if (view == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseCliAction.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)view));
        JBIterable jBIterable = DatabaseView.getSelectedElements(dataContext, (Condition<DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup && DbImplUtil.isDataTable(((DatabaseStructure.FamilyGroup)o).kidKind))).unique();
        if (jBIterable == null) {
            DatabaseCliAction.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    private static boolean isHostAndPortExists(@NotNull LocalDataSource source) {
        String url;
        if (source == null) {
            DatabaseCliAction.$$$reportNull$$$0(8);
        }
        DatabaseDriver driver = source.getDatabaseDriver();
        RawConnectionConfig config = source.getConnectionConfig();
        String string = url = config == null ? null : config.getUrl();
        if (url == null || driver == null) {
            return false;
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(parsers, url, (Ref<JdbcUrlParser>)Ref.create());
        return hostPort != null && hostPort.first != null && hostPort.second != null;
    }

    @Nullable
    private static LocalDataSource getDataSource(@NotNull AnActionEvent e) {
        if (e == null) {
            DatabaseCliAction.$$$reportNull$$$0(9);
        }
        return (LocalDataSource)JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(e.getDataContext()))).filterMap(o -> o instanceof DbElement ? ((DbElement)o).getDataSource() : (o instanceof DatabaseStructure.FamilyGroup ? ((DatabaseStructure.FamilyGroup)o).dataSource : null)).filterMap(DbImplUtil::getMaybeLocalDataSource).unique().single();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseCliAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseCliAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOneConfigurationText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOneConfigurationText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isHostAndPortExists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Restore
    extends DatabaseCliAction {
        @Override
        @Nullable
        public CliConfigurationPack getConfigurations(@NotNull DatabaseFamilyId family) {
            if (family == null) {
                Restore.$$$reportNull$$$0(0);
            }
            return RestoreConfigurationsHolder.of(family);
        }

        @Override
        @NotNull
        protected String getMask() {
            if ("Restore with %s" == null) {
                Restore.$$$reportNull$$$0(1);
            }
            return "Restore with %s";
        }

        @Override
        @NotNull
        protected String getCommonText(boolean action) {
            String string = "Restore" + (action ? "..." : "");
            if (string == null) {
                Restore.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "family";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseCliAction$Restore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseCliAction$Restore";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Dump
    extends DatabaseCliAction {
        @Override
        @Nullable
        public CliConfigurationPack getConfigurations(@NotNull DatabaseFamilyId family) {
            if (family == null) {
                Dump.$$$reportNull$$$0(0);
            }
            return DumpConfigurationsHolder.of(family);
        }

        @Override
        @NotNull
        protected String getMask() {
            if ("Dump with %s" == null) {
                Dump.$$$reportNull$$$0(1);
            }
            return "Dump with %s";
        }

        @Override
        @NotNull
        protected String getCommonText(boolean action) {
            String string = "Dump" + (action ? "..." : "");
            if (string == null) {
                Dump.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "family";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseCliAction$Dump";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseCliAction$Dump";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

