/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;

public abstract class ColumnsWidthAction
extends DumbAwareAction
implements GridAction {
    private static final int DELTA = 8;

    public void update(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ModelIndexSet<Object> columns2 = dataGrid.isTransposed() ? dataGrid.getSelectionModel().getSelectedRows() : dataGrid.getSelectionModel().getSelectedColumns();
        e.getPresentation().setEnabledAndVisible(!dataGrid.isEditing() && columns2.size() != 0);
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid != null) {
            dataGrid.changeSelectedColumnsWidth(this.getDelta());
        }
    }

    abstract int getDelta();

    public static class IncreaseColumnsWidthAction
    extends ColumnsWidthAction {
        @Override
        int getDelta() {
            return 8;
        }
    }

    public static class DecreaseColumnsWidthAction
    extends ColumnsWidthAction {
        @Override
        int getDelta() {
            return -8;
        }
    }
}

