/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDataSourceFromUrl
extends AnAction
implements DumbAware {
    private final DatabaseViewActions.DataSourceFactory myFactory;

    public AddDataSourceFromUrl(@NotNull DatabaseViewActions.DataSourceFactory factory) {
        if (factory == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(0);
        }
        super("Data Source from URL", null, DatabaseIcons.Connector);
        this.myFactory = factory;
    }

    public void update(AnActionEvent e) {
        boolean enabled = DatabaseViewActions.getDbFacade(e) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DbPsiFacade facade = DatabaseViewActions.getDbFacade(e);
        if (facade == null) {
            return;
        }
        AddDataSourceFromUrl.newDataSourceFromInput(facade, (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)((TripleFunction)(manager, template, s) -> {
            this.myFactory.create(facade, (DbPsiManager)manager, (DataSourceTemplate)template, (String)s);
            return null;
        }));
    }

    public static void newDataSourceFromInput(@NotNull DbPsiFacade facade, @NotNull TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> consumer) {
        if (facade == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            AddDataSourceFromUrl.$$$reportNull$$$0(2);
        }
        new FastDataSourceDialog(facade.getProject(), (TripleFunction)consumer){
            {
                this.setTitle("New Data Source from URL");
                this.getNameLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&URL:"));
            }

            @Override
            protected boolean looksLikeOk(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(0);
                }
                return str.startsWith("jdbc:");
            }

            @Override
            @Nullable
            protected DatabaseDriver selectDriver(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(1);
                }
                ArrayList filtered = ContainerUtil.newArrayList();
                for (Pair driverPair : this.myDrivers) {
                    for (StatelessJdbcUrlParser parser : ((DatabaseDriver)driverPair.second).getJDBCUrlParsers()) {
                        if (!parser.isUrlValueValid(this.getNameField().getText())) continue;
                        filtered.add(driverPair.second);
                    }
                }
                if (filtered.size() < 1) {
                    return (DatabaseDriver)ContainerUtil.getFirstItem((List)filtered);
                }
                return this.disambiguate(str, (JBIterable<DatabaseDriver>)JBIterable.from((Iterable)filtered));
            }

            @Nullable
            private DatabaseDriver disambiguate(@NotNull String url, JBIterable<DatabaseDriver> filtered) {
                if (url == null) {
                    1.$$$reportNull$$$0(2);
                }
                return DbImplUtil.disambiguate(url, filtered);
            }

            @Override
            @NotNull
            protected List<Pair<DbPsiManager, DatabaseDriver>> extractDrivers(@NotNull DbPsiFacade facade) {
                if (facade == null) {
                    1.$$$reportNull$$$0(3);
                }
                List<Pair<DbPsiManager, DatabaseDriver>> list = 1.allDrivers(facade);
                if (list == null) {
                    1.$$$reportNull$$$0(4);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "url";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facade";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromUrl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "extractDrivers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "looksLikeOk";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "selectDriver";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "disambiguate";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "extractDrivers";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "newDataSourceFromInput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class FastDataSourceDialog
    extends CreateFileFromTemplateDialog {
        private final TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> myConsumer;
        protected List<Pair<DbPsiManager, DatabaseDriver>> myDrivers;
        private boolean myKindUserEdited;
        private boolean myUpdating;

        public FastDataSourceDialog(@NotNull Project project, @NotNull TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> consumer) {
            if (project == null) {
                FastDataSourceDialog.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                FastDataSourceDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myConsumer = consumer;
            this.setup(project);
        }

        private void setup(@NotNull Project project) {
            if (project == null) {
                FastDataSourceDialog.$$$reportNull$$$0(2);
            }
            this.getKindLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&Driver:"));
            this.myDrivers = this.extractDrivers(DbPsiFacade.getInstance((Project)project));
            Collections.sort(this.myDrivers, (o1, o2) -> StringUtil.naturalCompare((String)((DatabaseDriver)o1.second).getFullName(), (String)((DatabaseDriver)o2.second).getFullName()));
            for (Pair<DbPsiManager, DatabaseDriver> driver : this.myDrivers) {
                this.getKindCombo().addItem(((DatabaseDriver)driver.getSecond()).getFullName(), ((DatabaseDriver)driver.getSecond()).getIcon(0), ((DatabaseDriver)driver.getSecond()).getFullName());
            }
            this.setTemplateKindComponentsVisible(true);
            this.getNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    myUpdating = true;
                    try {
                        DatabaseDriver driver = this.selectDriver(this.getNameField().getText());
                        if (driver != null) {
                            this.getKindCombo().setSelectedName(driver.getFullName());
                        } else if (!myKindUserEdited) {
                            this.getKindCombo().getComboBox().setSelectedItem(null);
                        }
                    }
                    finally {
                        myUpdating = false;
                    }
                }
            });
            String clipboardText = StringUtil.trim((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
            if (clipboardText != null && this.looksLikeOk(clipboardText)) {
                this.getNameField().setText(clipboardText);
            }
            this.getKindCombo().getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!myUpdating) {
                        myKindUserEdited = true;
                    }
                }
            });
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (this.getKindCombo().getComboBox().getSelectedItem() == null) {
                return new ValidationInfo("Please select driver");
            }
            return super.doValidate();
        }

        protected void doOKAction() {
            for (Pair<DbPsiManager, DatabaseDriver> driver : this.myDrivers) {
                if (!((DatabaseDriver)driver.second).getFullName().equals(this.getKindCombo().getSelectedName())) continue;
                String text = this.getNameField().getText();
                ApplicationManager.getApplication().invokeLater(() -> {
                    Void cfr_ignored_0 = (Void)this.myConsumer.fun(driver.first, driver.second, (Object)text);
                });
            }
            super.doOKAction();
        }

        protected abstract boolean looksLikeOk(@NotNull String var1);

        @Nullable
        protected abstract DatabaseDriver selectDriver(@NotNull String var1);

        @NotNull
        protected abstract List<Pair<DbPsiManager, DatabaseDriver>> extractDrivers(@NotNull DbPsiFacade var1);

        static List<Pair<DbPsiManager, DatabaseDriver>> allDrivers(@NotNull DbPsiFacade facade) {
            if (facade == null) {
                FastDataSourceDialog.$$$reportNull$$$0(3);
            }
            ArrayList allDrivers = ContainerUtil.newArrayList();
            for (DbPsiManager manager : facade.getDbManagers()) {
                for (DataSourceTemplate template0 : manager.getDataSourceTemplates()) {
                    for (DataSourceTemplate template : template0.getSubConfigurations()) {
                        DatabaseDriver databaseDriver = (DatabaseDriver)ObjectUtils.tryCast((Object)template, DatabaseDriver.class);
                        if (databaseDriver == null) continue;
                        allDrivers.add(Pair.create((Object)manager, (Object)databaseDriver));
                    }
                }
            }
            return allDrivers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromUrl$FastDataSourceDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setup";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "allDrivers";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

