/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config.style.rules;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintConfigOption;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintConfigWrapper;
import com.intellij.lang.javascript.linter.tslint.config.style.rules.TsLintRule;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0017\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0019\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J%\u0010\u001c\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/config/style/rules/TsLintSimpleRule;", "T", "Lcom/intellij/lang/javascript/linter/tslint/config/style/rules/TsLintRule;", "optionId", "", "(Ljava/lang/String;)V", "getOptionId", "()Ljava/lang/String;", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "languageSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "codeStyleSettings", "Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;", "config", "Lcom/intellij/lang/javascript/linter/tslint/config/style/rules/TsLintConfigWrapper;", "getConfigValue", "(Lcom/intellij/lang/javascript/linter/tslint/config/style/rules/TsLintConfigWrapper;)Ljava/lang/Object;", "getSettingsValue", "(Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;)Ljava/lang/Object;", "hasOption", "", "isAvailable", "setDirectValue", "value", "", "setValue", "(Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;Ljava/lang/Object;)V", "intellij.tslint"})
public abstract class TsLintSimpleRule<T>
implements TsLintRule {
    @NotNull
    private final String optionId;

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, @NotNull TsLintConfigWrapper config) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkParameterIsNotNull((Object)codeStyleSettings, (String)"codeStyleSettings");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        if (!this.hasOption(config)) {
            return false;
        }
        T configValue = this.getConfigValue(config);
        return configValue != null && Intrinsics.areEqual(this.getSettingsValue(languageSettings, codeStyleSettings), configValue) ^ true;
    }

    @Nullable
    public abstract T getConfigValue(@NotNull TsLintConfigWrapper var1);

    @Override
    public void apply(@NotNull Project project, @NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, @NotNull TsLintConfigWrapper config) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkParameterIsNotNull((Object)codeStyleSettings, (String)"codeStyleSettings");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        T t = this.getConfigValue(config);
        if (t == null) {
            return;
        }
        T value = t;
        this.setValue(languageSettings, codeStyleSettings, value);
    }

    public boolean hasOption(@NotNull TsLintConfigWrapper config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        TsLintConfigOption tsLintConfigOption = config.getOption(this.optionId);
        return tsLintConfigOption != null ? tsLintConfigOption.isTrue() : false;
    }

    public abstract T getSettingsValue(@NotNull CommonCodeStyleSettings var1, @NotNull JSCodeStyleSettings var2);

    public final void setDirectValue(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkParameterIsNotNull((Object)codeStyleSettings, (String)"codeStyleSettings");
        this.setValue(languageSettings, codeStyleSettings, value);
    }

    public abstract void setValue(@NotNull CommonCodeStyleSettings var1, @NotNull JSCodeStyleSettings var2, T var3);

    @NotNull
    public final String getOptionId() {
        return this.optionId;
    }

    public TsLintSimpleRule(@NotNull String optionId) {
        Intrinsics.checkParameterIsNotNull((Object)optionId, (String)"optionId");
        this.optionId = optionId;
    }
}

