/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.localization.LocaleElementType;
import com.jetbrains.localization.LocaleElementTypes;
import com.jetbrains.localization.LocaleTokenTypes;
import org.jetbrains.annotations.NotNull;

public class LocaleParser
implements PsiParser,
LocaleElementTypes,
LocaleTokenTypes {
    private boolean isParseSectionContents = false;

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        if (root == LocaleElementTypes.SECTION) {
            this.isParseSectionContents = true;
            Parsing parsing = new Parsing(builder);
            parsing.parseSection();
            ASTNode aSTNode = builder.getTreeBuilt();
            if (aSTNode == null) {
                LocaleParser.$$$reportNull$$$0(0);
            }
            return aSTNode;
        }
        PsiBuilder.Marker rootMarker = builder.mark();
        Parsing parsing = new Parsing(builder);
        while (!builder.eof()) {
            if (parsing.parseSection()) continue;
            parsing.skipSection();
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            LocaleParser.$$$reportNull$$$0(1);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/localization/LocaleParser", "parse"));
    }

    private class Parsing {
        private final PsiBuilder myBuilder;

        public Parsing(PsiBuilder builder) {
            this.myBuilder = builder;
        }

        public boolean parseSection() {
            PsiBuilder.Marker section = this.mark();
            while (this.myBuilder.getTokenType() == LocaleTokenTypes.LOCATION_PREFIX) {
                this.advance();
                this.parseLocation();
            }
            PsiBuilder.Marker line = this.mark();
            if (this.parseLine(LocaleTokenTypes.MSGCTXT_KEYWORD)) {
                this.doneOrCollapse(line, LocaleElementTypes.CTXT_LINE);
                line = this.mark();
            }
            boolean parsedIDStr = this.parseIDSTR(line);
            this.doneOrCollapse(section, (IElementType)LocaleElementTypes.SECTION);
            return parsedIDStr;
        }

        private void doneOrCollapse(PsiBuilder.Marker marker, IElementType type) {
            if (LocaleParser.this.isParseSectionContents) {
                marker.done(type);
            } else {
                marker.collapse(type);
            }
        }

        private void parseLocation() {
            PsiBuilder.Marker line = this.mark();
            while (this.myBuilder.getTokenType() == LocaleTokenTypes.LOCATION) {
                this.advance();
                this.doneOrCollapse(line, LocaleTokenTypes.LOCATION);
                line = this.mark();
            }
            line.drop();
        }

        private boolean parseIDSTR(PsiBuilder.Marker line) {
            boolean res = true;
            boolean shouldParsePlural = false;
            if (this.parseLine(LocaleTokenTypes.MSGID_KEYWORD)) {
                this.doneOrCollapse(line, LocaleElementTypes.ID_LINE);
                line = this.mark();
                if (this.parseLine(LocaleTokenTypes.MSGID_PLURAL_KEYWORD)) {
                    this.doneOrCollapse(line, LocaleElementTypes.PLURAL_ID_LINE);
                    shouldParsePlural = true;
                } else {
                    line.drop();
                }
                line = this.mark();
                if (!shouldParsePlural) {
                    if (this.parseLine(LocaleTokenTypes.MSGSTR_KEYWORD)) {
                        this.doneOrCollapse(line, LocaleElementTypes.STR_LINE);
                    } else {
                        this.error("Msgstr keyword without index expected");
                        line.drop();
                        res = false;
                    }
                } else if (!this.parseMsgstrPlural(line)) {
                    this.error("Msgstr keyword with index expected");
                    res = false;
                }
            } else {
                this.error("Msgid keyword expected");
                line.drop();
                res = false;
            }
            return res;
        }

        private boolean parseMsgstrPlural(PsiBuilder.Marker line) {
            boolean res = false;
            while (this.is(LocaleTokenTypes.MSGSTR_PLURAL_KEYWORD)) {
                if (!this.parseStringLiteral()) continue;
                this.doneOrCollapse(line, LocaleElementTypes.STR_LINE);
                line = this.mark();
                res = true;
            }
            line.drop();
            return res;
        }

        private boolean parseLine(LocaleElementType keyword) {
            if (this.is(keyword)) {
                return this.parseStringLiteral();
            }
            return false;
        }

        private boolean is(IElementType type) {
            return this.myBuilder.getTokenType() == type;
        }

        private void error(String message) {
            this.myBuilder.error(message);
        }

        private PsiBuilder.Marker mark() {
            return this.myBuilder.mark();
        }

        public void advance() {
            this.myBuilder.advanceLexer();
        }

        private void skipSection() {
            if (!this.is(LocaleTokenTypes.WHITESPACE)) {
                this.myBuilder.advanceLexer();
            }
            while (!(this.is(null) || this.is(LocaleTokenTypes.WHITESPACE) || this.is(LocaleTokenTypes.MSGID_KEYWORD) || this.is(LocaleTokenTypes.ERROR))) {
                this.myBuilder.advanceLexer();
            }
        }

        private boolean parseStringLiteral() {
            this.advance();
            PsiBuilder.Marker str = this.mark();
            boolean hasString = false;
            while (this.is(LocaleTokenTypes.STRING_LITERAL)) {
                this.advance();
                this.doneOrCollapse(str, LocaleElementTypes.STRING_LITERAL_EXPRESSION);
                str = this.mark();
                hasString = true;
            }
            str.drop();
            if (hasString) {
                return true;
            }
            this.error("String literal expected");
            return false;
        }
    }
}

