/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli;

import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class DockerCliParserBase<CMD> {
    private File myContextFolder;

    public final void setContextFolder(File contextFolder) {
        this.myContextFolder = contextFolder;
    }

    public List<OptionHandler<CMD>> createAllHandlers() {
        LinkedList<OptionHandler> result = new LinkedList<OptionHandler>();
        result.add(this.hostname(DockerCliParserBase.builder13("h").longOpt("hostname").hasArg().build()));
        result.add(this.user(DockerCliParserBase.builder13("u").longOpt("user").hasArg().build()));
        result.add(this.memory(DockerCliParserBase.builder13("m").longOpt("memory").hasArg().build()));
        result.add(this.memoryReservation(DockerCliParserBase.builder13().longOpt("memory-reservation").hasArg().build()));
        result.add(this.kernelMemory(DockerCliParserBase.builder13().longOpt("kernel-memory").hasArg().build()));
        result.add(this.shmSize(DockerCliParserBase.builder13().longOpt("shm-size").hasArg().build()));
        result.add(this.memorySwap(DockerCliParserBase.builder13().longOpt("memory-swap").hasArg().build()));
        result.add(this.memorySwappiness(DockerCliParserBase.builder13().longOpt("memory-swappiness").hasArg().build()));
        result.add(this.cpusetCpus(DockerCliParserBase.builder13().longOpt("cpuset-cpus").hasArg().build()));
        result.add(this.cpuShares(DockerCliParserBase.builder13("c").longOpt("cpu-shares").hasArg().build()));
        result.add(this.cpuPeriod(DockerCliParserBase.builder13().longOpt("cpu-period").hasArg().build()));
        result.add(this.cpuQuota(DockerCliParserBase.builder13().longOpt("cpu-quota").hasArg().build()));
        result.add(this.cpusetMems(DockerCliParserBase.builder13().longOpt("cpuset-mems").hasArg().build()));
        result.add(this.cpus(DockerCliParserBase.builder13().longOpt("cpus").hasArg().build()));
        result.add(this.blkioWeight(DockerCliParserBase.builder13().longOpt("blkio-weight").hasArg().build()));
        result.add(this.oomKillDisable(DockerCliParserBase.builder13().longOpt("oom-kill-disable").hasArg().optionalArg(true).build()));
        result.add(this.attach(DockerCliParserBase.builder13("a").longOpt("attach").hasArg().build()));
        result.add(this.detach(DockerCliParserBase.builder13("d").longOpt("detach").optionalArg(true).build()));
        result.add(this.tty(DockerCliParserBase.builder13("t").longOpt("tty").optionalArg(true).build()));
        result.add(this.interactive(DockerCliParserBase.builder13("i").longOpt("interactive").optionalArg(true).build()));
        result.add(this.env(DockerCliParserBase.builder13("e").longOpt("env").hasArg().build()));
        result.add(this.envFile(DockerCliParserBase.builder13().longOpt("env-file").hasArg().build()));
        result.add(this.entrypoint(DockerCliParserBase.builder13().longOpt("entrypoint").hasArg().build()));
        result.add(this.workingDir(DockerCliParserBase.builder13("w").longOpt("workdir").hasArg().build()));
        result.add(this.expose(DockerCliParserBase.builder13().longOpt("expose").hasArg().build()));
        result.add(this.addHost(DockerCliParserBase.builder13().longOpt("add-host").hasArg().build()));
        result.add(this.volume(DockerCliParserBase.builder13("v").longOpt("volume").hasArg().build()));
        result.add(this.link(DockerCliParserBase.builder13().longOpt("link").hasArg().build()));
        result.add(this.lxcConf(DockerCliParserBase.builder13().longOpt("lxc-conf").hasArg().build()));
        result.add(this.logDriver(DockerCliParserBase.builder13().longOpt("log-driver").hasArg().build()));
        result.add(this.logOpt(DockerCliParserBase.builder13().longOpt("log-opt").hasArg().build()));
        result.add(this.macAddress(DockerCliParserBase.builder13().longOpt("mac-address").hasArg().build()));
        result.add(this.publish(DockerCliParserBase.builder13("p").longOpt("publish").hasArg().build()));
        result.add(this.publishAll(DockerCliParserBase.builder13("P").longOpt("publish-all").optionalArg(true).build()));
        result.add(this.privileged(DockerCliParserBase.builder13().longOpt("privileged").hasArg().optionalArg(true).build()));
        result.add(this.dns(DockerCliParserBase.builder13().longOpt("dns").hasArg().build()));
        result.add(this.dnsSearch(DockerCliParserBase.builder13().longOpt("dns-search").hasArg().build()));
        result.add(this.volumesFrom(DockerCliParserBase.builder13().longOpt("volumes-from").hasArg().build()));
        result.add(this.cidfile(DockerCliParserBase.builder13().longOpt("cidfile").hasArg().build()));
        result.add(this.capAdd(DockerCliParserBase.builder13().longOpt("cap-add").hasArg().build()));
        result.add(this.capDrop(DockerCliParserBase.builder13().longOpt("cap-drop").hasArg().build()));
        result.add(this.restart(DockerCliParserBase.builder13().longOpt("restart").hasArg().build()));
        result.add(this.network(DockerCliParserBase.builder13().longOpt("network").hasArg().build()));
        result.add(this.network(DockerCliParserBase.builder13().longOpt("net").hasArg().build()));
        result.add(this.networkAlias(DockerCliParserBase.builder13().longOpt("network-alias").hasArg().build()));
        result.add(this.label(DockerCliParserBase.builder13("l").longOpt("label").hasArg().build()));
        result.add(this.ip(DockerCliParserBase.builder13().longOpt("ip").hasArg().build()));
        result.add(this.ip6(DockerCliParserBase.builder13().longOpt("ip6").hasArg().build()));
        result.add(this.device(DockerCliParserBase.builder13().longOpt("device").hasArg().build()));
        result.add(this.securityOpt(DockerCliParserBase.builder13().longOpt("security-opt").hasArg().build()));
        return result.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected final void doParse(CMD result, String[] arguments) throws ParseException {
        List<OptionHandler<CMD>> handlers = this.createAllHandlers();
        Options options = new Options();
        for (OptionHandler<CMD> handler : handlers) {
            options.addOption(handler.getOption());
        }
        CommandLine commandLine = new PosixParser().parse(options, arguments);
        for (OptionHandler<CMD> handler : handlers) {
            handler.handle(commandLine, result);
        }
    }

    protected File getContextFolder() {
        return this.myContextFolder;
    }

    protected abstract SingleValueHandler<CMD> hostname(Option var1);

    protected abstract SingleValueHandler<CMD> user(Option var1);

    protected abstract MemoryOptionHandler<CMD> memory(Option var1);

    protected abstract MemoryOptionHandler<CMD> memorySwap(Option var1);

    protected abstract IntegerOptionHandler<CMD> memorySwappiness(Option var1);

    protected abstract MemoryOptionHandler<CMD> memoryReservation(Option var1);

    protected abstract MemoryOptionHandler<CMD> kernelMemory(Option var1);

    protected abstract MemoryOptionHandler<CMD> shmSize(Option var1);

    protected abstract SingleValueHandler<CMD> cpusetCpus(Option var1);

    protected abstract IntegerOptionHandler<CMD> cpuShares(Option var1);

    protected abstract IntegerOptionHandler<CMD> cpuPeriod(Option var1);

    protected abstract IntegerOptionHandler<CMD> cpuQuota(Option var1);

    protected abstract SingleValueHandler<CMD> cpusetMems(Option var1);

    protected abstract DoubleOptionHandler<CMD> cpus(Option var1);

    protected abstract IntegerOptionHandler<CMD> blkioWeight(Option var1);

    protected abstract BooleanOptionHandler<CMD> oomKillDisable(Option var1);

    protected abstract AttachOptionHandler<CMD> attach(Option var1);

    protected abstract BooleanOptionHandler<CMD> detach(Option var1);

    protected abstract BooleanOptionHandler<CMD> tty(Option var1);

    protected abstract BooleanOptionHandler<CMD> interactive(Option var1);

    protected abstract ListHandler<CMD> env(Option var1);

    protected abstract EnvFileListHandler envFile(Option var1);

    protected abstract SingleValueHandler<CMD> entrypoint(Option var1);

    protected abstract SingleValueHandler<CMD> workingDir(Option var1);

    protected abstract ListHandler<CMD> expose(Option var1);

    protected abstract ListHandler<CMD> addHost(Option var1);

    protected abstract ListHandler<CMD> volume(Option var1);

    protected abstract LinkOptionHandler<CMD, ?> link(Option var1);

    protected abstract ListHandler<CMD> lxcConf(Option var1);

    protected abstract SingleValueHandler<CMD> logDriver(Option var1);

    protected abstract ListHandler<CMD> logOpt(Option var1);

    protected abstract SingleValueHandler<CMD> macAddress(Option var1);

    protected abstract PortBindingOptionHandler<CMD, ?> publish(Option var1);

    protected abstract BooleanOptionHandler<CMD> publishAll(Option var1);

    protected abstract BooleanOptionHandler<CMD> privileged(Option var1);

    protected abstract StringListHandler<CMD> dns(Option var1);

    protected abstract StringListHandler<CMD> dnsSearch(Option var1);

    protected abstract MappedListHandler<CMD, ?> volumesFrom(Option var1);

    protected abstract SingleValueHandler<CMD> cidfile(Option var1);

    protected abstract ListHandler<CMD> capAdd(Option var1);

    protected abstract ListHandler<CMD> capDrop(Option var1);

    protected abstract SingleValueHandler<CMD> restart(Option var1);

    protected abstract SingleValueHandler<CMD> network(Option var1);

    protected abstract ListHandler<CMD> networkAlias(Option var1);

    protected abstract ListHandler<CMD> device(Option var1);

    protected abstract SingleValueHandler<CMD> ip(Option var1);

    protected abstract SingleValueHandler<CMD> ip6(Option var1);

    protected abstract LabelListHandler<CMD> label(Option var1);

    protected abstract ListHandler<CMD> securityOpt(Option var1);

    private static OptionBuilder13 builder13(String opt) {
        return new OptionBuilder13(opt);
    }

    private static OptionBuilder13 builder13() {
        return DockerCliParserBase.builder13(null);
    }

    private static class OptionBuilder13 {
        private final String opt;
        private String longOpt;
        private boolean required;
        private boolean optionalArg;
        private int numberOfArgs = -1;

        private OptionBuilder13(String opt) throws IllegalArgumentException {
            this.opt = opt;
        }

        public OptionBuilder13 longOpt(String longOpt) {
            this.longOpt = longOpt;
            return this;
        }

        public OptionBuilder13 optionalArg(boolean isOptional) {
            this.optionalArg = isOptional;
            return this;
        }

        public OptionBuilder13 required() {
            return this.required(true);
        }

        public OptionBuilder13 required(boolean required) {
            this.required = required;
            return this;
        }

        public OptionBuilder13 hasArg() {
            return this.hasArg(true);
        }

        public OptionBuilder13 hasArg(boolean hasArg) {
            this.numberOfArgs = hasArg ? 1 : -1;
            return this;
        }

        public Option build() {
            if (this.opt == null && this.longOpt == null) {
                throw new IllegalArgumentException();
            }
            Option result = new Option(this.opt, null);
            result.setLongOpt(this.longOpt);
            result.setRequired(this.required);
            result.setArgs(this.numberOfArgs);
            result.setOptionalArg(this.optionalArg);
            return result;
        }
    }

    public static class IllegalOptionException
    extends IllegalArgumentException {
        private Option myOption;

        public IllegalOptionException(String message) {
            super(message);
        }

        public IllegalOptionException(Option option, String value) {
            this("Error parsing value: '" + value + "' for option '" + IllegalOptionException.getDisplayName(option) + "'");
            this.myOption = option;
        }

        public Option getOption() {
            return this.myOption;
        }

        private static String getDisplayName(Option option) {
            return Optional.ofNullable(option.getOpt()).orElseGet(() -> option.getLongOpt());
        }
    }

    protected static class DoubleOptionHandler<CMD>
    extends SingleValueHandler<CMD> {
        private final BiConsumer<CMD, Double> mySetter;

        public DoubleOptionHandler(Option option, BiConsumer<CMD, Double> setter) {
            super(option);
            this.mySetter = setter;
        }

        @Override
        protected void handleEachValue(String value) {
            double doubleValue;
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionException(this.getOption(), value);
            }
            this.mySetter.accept(this.getCmd(), doubleValue);
        }
    }

    protected static class IntegerOptionHandler<CMD>
    extends SingleValueHandler<CMD> {
        private final BiConsumer<CMD, Integer> mySetter;

        public IntegerOptionHandler(Option option, BiConsumer<CMD, Integer> setter) {
            super(option);
            this.mySetter = setter;
        }

        @Override
        protected void handleEachValue(String value) {
            int intValue;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionException(this.getOption(), value);
            }
            this.mySetter.accept(this.getCmd(), intValue);
        }
    }

    protected static abstract class LinkOptionHandler<CMD, LINK>
    extends ListHandler<CMD> {
        private final BiConsumer<CMD, List<LINK>> mySetter;

        public LinkOptionHandler(Option option, BiConsumer<CMD, List<LINK>> setter) {
            super(option);
            this.mySetter = setter;
        }

        @Override
        protected void handleValueList(String[] values) {
            ArrayList<LINK> links = new ArrayList<LINK>(values.length);
            for (String next : values) {
                LINK nextLink;
                String[] parts = next.split(":");
                switch (parts.length) {
                    case 1: {
                        nextLink = this.createLink(next, next);
                        break;
                    }
                    case 2: {
                        nextLink = this.createLink(parts[0], parts[1]);
                        break;
                    }
                    default: {
                        throw new IllegalOptionException(this.getOption(), next);
                    }
                }
                if (nextLink == null) continue;
                links.add(nextLink);
            }
            this.mySetter.accept(this.getCmd(), links);
        }

        protected abstract LINK createLink(String var1, String var2);
    }

    protected static abstract class LabelListHandler<CMD>
    extends ListHandler<CMD> {
        public LabelListHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleValueList(String[] values) {
            String SEPARATOR = "=";
            HashMap<String, String> resultLabels = new HashMap<String, String>();
            for (String next : values) {
                String value;
                String label;
                int splitIdx = next.indexOf("=");
                if (splitIdx == 0) {
                    throw new IllegalOptionException(this.getOption(), next);
                }
                if (splitIdx < 0) {
                    label = next;
                    value = "";
                } else {
                    label = next.substring(0, splitIdx);
                    value = next.substring(splitIdx + "=".length());
                }
                resultLabels.put(label, value);
            }
            this.handleLabelsMap(resultLabels);
        }

        protected abstract void handleLabelsMap(Map<String, String> var1);
    }

    protected abstract class EnvFileListHandler
    extends ListHandler<CMD> {
        public EnvFileListHandler(Option option) {
            super(option);
        }

        @Override
        protected void handleValueList(String[] values) {
            File contextFolder = DockerCliParserBase.this.getContextFolder();
            for (String nextValue : values) {
                File nextFile;
                Path nextPath = Paths.get(nextValue, new String[0]);
                if (!nextPath.isAbsolute() && contextFolder != null) {
                    nextPath = contextFolder.toPath().resolve(nextPath);
                }
                if (!(nextFile = nextPath.toFile()).exists() || !nextFile.isFile()) {
                    throw new IllegalOptionException("Can't read 'env-file' at " + nextValue);
                }
                this.handleEnvFile(nextValue, nextFile);
            }
        }

        protected abstract void handleEnvFile(String var1, File var2);
    }

    protected static class PortBindingOptionHandler<CMD, PORT>
    extends MappedListHandler<CMD, PORT> {
        public PortBindingOptionHandler(Option option, Class<PORT> valueClass, Function<String, PORT> mapper, BiConsumer<CMD, PORT[]> setter) {
            super(option, valueClass, mapper, setter);
        }

        @Override
        protected void handleValueList(String[] values) {
            for (String next : values) {
                try {
                    DockerPortBindingImpl.fromString(next);
                }
                catch (IllegalArgumentException ignored) {
                    throw new IllegalOptionException(this.getOption(), next);
                }
            }
            super.handleValueList(values);
        }
    }

    protected static class AttachOptionHandler<CMD>
    extends ListHandler<CMD> {
        public static final String STDIN = "stdin";
        public static final String STDOUT = "stdout";
        public static final String STDERR = "stderr";
        private final BiConsumer<CMD, Boolean> myAttachStdin;
        private final BiConsumer<CMD, Boolean> myAttachStdout;
        private final BiConsumer<CMD, Boolean> myAttachStderr;

        public AttachOptionHandler(Option option, BiConsumer<CMD, Boolean> attachStdin, BiConsumer<CMD, Boolean> attachStdout, BiConsumer<CMD, Boolean> attachStderr) {
            super(option);
            this.myAttachStdin = attachStdin;
            this.myAttachStdout = attachStdout;
            this.myAttachStderr = attachStderr;
        }

        @Override
        protected final void handleValueList(String[] values) {
            for (String nextAttach : values) {
                this.handleOneAttach(nextAttach);
            }
        }

        protected void handleOneAttach(String attachTo) {
            if (STDIN.equalsIgnoreCase(attachTo)) {
                this.myAttachStdin.accept(this.getCmd(), true);
            } else if (STDOUT.equalsIgnoreCase(attachTo)) {
                this.myAttachStdout.accept(this.getCmd(), true);
            } else if (STDERR.equalsIgnoreCase(attachTo)) {
                this.myAttachStderr.accept(this.getCmd(), true);
            } else {
                throw new IllegalOptionException(this.getOption(), attachTo);
            }
        }
    }

    protected static class MemoryOptionHandler<CMD>
    extends SingleValueHandler<CMD> {
        private static final Map<String, Long> MEMORY_UNIT_2_RATIO = new HashMap<String, Long>();
        private final BiConsumer<CMD, Long> mySetter;

        public MemoryOptionHandler(Option option, BiConsumer<CMD, Long> memorySetter) {
            super(option);
            this.mySetter = memorySetter;
        }

        @Override
        protected void handleEachValue(String value) {
            this.mySetter.accept(this.getCmd(), this.parseMemory(value));
        }

        protected long parseMemory(String value) {
            if (value.isEmpty()) {
                throw new IllegalOptionException(this.getOption(), value);
            }
            String unit = value.substring(value.length() - 1).toLowerCase(Locale.ENGLISH);
            Long ratio = MEMORY_UNIT_2_RATIO.get(unit);
            try {
                return ratio == null ? Long.parseLong(value) : Long.parseLong(value.substring(0, value.length() - 1)) * ratio;
            }
            catch (NumberFormatException e) {
                throw new IllegalOptionException(this.getOption(), value);
            }
        }

        static {
            MEMORY_UNIT_2_RATIO.put("b", 1L);
            MEMORY_UNIT_2_RATIO.put("k", 1024L);
            MEMORY_UNIT_2_RATIO.put("m", 0x100000L);
            MEMORY_UNIT_2_RATIO.put("g", 0x40000000L);
        }
    }

    protected static class MappedListHandler<CMD, VAL>
    extends ListHandler<CMD> {
        private final BiConsumer<CMD, VAL[]> mySetter;
        private final Function<String, VAL> myMapper;
        private final Class<VAL> myValueClass;

        public MappedListHandler(Option option, Class<VAL> valueClass, Function<String, VAL> mapper, BiConsumer<CMD, VAL[]> setter) {
            super(option);
            this.mySetter = setter;
            this.myMapper = mapper;
            this.myValueClass = valueClass;
        }

        @Override
        protected void handleValueList(String[] values) {
            VAL[] mappedValues = DockerUtil.mapArray(values, this.myValueClass, this.myMapper);
            this.mySetter.accept(this.getCmd(), mappedValues);
        }
    }

    protected static class StringListHandler<CMD>
    extends ListHandler<CMD> {
        private final BiConsumer<CMD, String[]> mySetter;

        public StringListHandler(Option option, BiConsumer<CMD, String[]> setter) {
            super(option);
            this.mySetter = setter;
        }

        @Override
        protected void handleValueList(String[] values) {
            this.mySetter.accept(this.getCmd(), values);
        }
    }

    protected static class EachValueHandler<CMD>
    extends SingleValueHandler<CMD> {
        private final BiConsumer<CMD, String> mySetter;

        public EachValueHandler(Option option, BiConsumer<CMD, String> setter) {
            super(option);
            this.mySetter = setter;
        }

        @Override
        protected void handleEachValue(String value) {
            this.mySetter.accept(this.getCmd(), value);
        }
    }

    public static class BooleanOptionHandlerImpl<CMD>
    extends BooleanOptionHandler<CMD> {
        private final BiConsumer<CMD, Boolean> mySetter;

        public BooleanOptionHandlerImpl(Option option, BiConsumer<CMD, Boolean> setter) {
            super(option);
            this.mySetter = setter;
        }

        @Override
        protected void handleBooleanValue(boolean value) {
            this.mySetter.accept(this.getCmd(), value);
        }
    }

    public static abstract class BooleanOptionHandler<CMD>
    extends OptionHandler<CMD> {
        public BooleanOptionHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleValueList(String[] values) {
        }

        @Override
        protected void handleOptionalValue(String value) {
            boolean boolValue = value == null || Boolean.parseBoolean(value);
            this.handleBooleanValue(boolValue);
        }

        protected abstract void handleBooleanValue(boolean var1);
    }

    public static abstract class ListHandler<CMD>
    extends OptionHandler<CMD> {
        public ListHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleOptionalValue(String value) {
        }
    }

    public static abstract class SingleValueHandler<CMD>
    extends OptionHandler<CMD> {
        public SingleValueHandler(Option option) {
            super(option);
        }

        @Override
        protected final void handleOptionalValue(String value) {
        }

        @Override
        protected final void handleValueList(String[] values) {
            for (String next : values) {
                this.handleEachValue(next);
            }
        }

        protected abstract void handleEachValue(String var1);
    }

    public static abstract class OptionHandler<CMD> {
        private final Option myOption;
        private CMD myCmd;

        public OptionHandler(Option option) {
            this.myOption = option;
        }

        public Option getOption() {
            return this.myOption;
        }

        public void handle(CommandLine commandLine, CMD cmd) {
            String opt;
            this.myCmd = cmd;
            String string = opt = this.myOption.getOpt() == null ? this.myOption.getLongOpt() : this.myOption.getOpt();
            if (commandLine.hasOption(opt)) {
                String[] values = commandLine.getOptionValues(opt);
                boolean noValues = values == null || values.length == 0;
                this.handleOptionalValue(noValues ? null : values[0]);
                if (!noValues) {
                    this.handleValueList(values);
                }
            }
        }

        protected abstract void handleValueList(String[] var1);

        protected CMD getCmd() {
            return this.myCmd;
        }

        protected abstract void handleOptionalValue(String var1);
    }
}

