/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Redshift;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.RedshiftExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.RedshiftIntermediateFacade;

public class RedshiftIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final RedshiftIntermediateProvider INSTANCE = new RedshiftIntermediateProvider();
    static final Pattern REDSHIFT_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:redshift://.+$");
    static final String REDSHIFT_CONNECTION_STRING_EXAMPLE = "jdbc:redshift:///";
    static final String REDSHIFT_DRIVER_CLASS_NAME = "com.amazon.redshift.jdbc.Driver";

    @Override
    @Nullable
    protected String getConnectionStringExample() {
        return REDSHIFT_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    @Nullable
    protected Driver loadDriver() {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(REDSHIFT_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("Redshift Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return RedshiftExceptionRecognizer.INSTANCE;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Redshift.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return REDSHIFT_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected JdbcIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new RedshiftIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, RedshiftExceptionRecognizer.INSTANCE);
    }
}

