/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.MysqlIntermediateSession;
import org.jetbrains.dekaf.util.Version;

public class MysqlIntermediateFacade
extends JdbcIntermediateFacade {
    private byte myFetchStrategy = 0;
    private static final String CONNECTION_INFO_QUERY = "select database(), schema(), left(user(),instr(concat(user(),'@'),'@')-1), @@version_comment";

    public MysqlIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public MysqlIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Mysql.RDBMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        Version serverVersion = null;
        JdbcIntermediateSession session = this.openSession();
        try {
            String rdbmsName;
            String driverVersionStr;
            String serverVersionStr;
            String verComment;
            String[] env = session.queryOneRow(CONNECTION_INFO_QUERY, 4, String.class);
            String string = verComment = env == null ? null : env[3];
            if (verComment != null) {
                verComment = verComment.toLowerCase(Locale.ENGLISH);
            }
            if (env == null) {
                env = new String[]{null, null, null};
            }
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                serverVersionStr = md.getDatabaseProductVersion();
                driverVersionStr = md.getDriverVersion();
                rdbmsName = md.getDatabaseProductName();
                if (rdbmsName == null) {
                    rdbmsName = session.getConnection().getClass().getName();
                }
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
            if (rdbmsName.equals("MySQL")) {
                int pos = serverVersionStr.indexOf("MariaDB");
                if (pos != -1) {
                    serverVersion = MysqlIntermediateFacade.extractVersion(serverVersionStr.substring(pos + "MariaDB".length()), SIMPLE_VERSION_PATTERN, 1);
                    if (serverVersion == Version.ZERO) {
                        serverVersion = MysqlIntermediateFacade.extractVersion(serverVersionStr.substring(0, pos), SIMPLE_VERSION_PATTERN, 1);
                    }
                    if (serverVersion != Version.ZERO) {
                        rdbmsName = "MariaDB";
                    } else {
                        serverVersion = null;
                    }
                } else if (verComment != null) {
                    if (verComment.startsWith("memsql")) {
                        rdbmsName = "MemSQL";
                        String[] memVer = session.queryOneRow("select @@memsql_version", 1, String.class);
                        if (memVer != null && memVer[0] != null) {
                            serverVersion = MysqlIntermediateFacade.extractVersion(memVer[0], SIMPLE_VERSION_PATTERN, 1);
                        }
                    } else if (verComment.startsWith("mariadb")) {
                        rdbmsName = "MariaDB";
                    }
                }
            }
            if (serverVersion == null) {
                serverVersion = MysqlIntermediateFacade.extractVersion(serverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            }
            Version driverVersion = MysqlIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
            return connectionInfo;
        }
        finally {
            session.close();
        }
    }

    @Override
    @NotNull
    protected MysqlIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new MysqlIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    public byte getFetchStrategy() {
        return this.myFetchStrategy;
    }

    public void setFetchStrategy(byte fetchStrategy) {
        this.myFetchStrategy = fetchStrategy;
    }
}

