/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;
import org.jetbrains.dekaf.jdbc.pooling.ConnectionPool;
import org.jetbrains.dekaf.jdbc.pooling.SimpleDataSource;
import org.jetbrains.dekaf.util.Objects;
import org.jetbrains.dekaf.util.Version;

public class JdbcIntermediateFacade
implements IntegralIntermediateFacade {
    @NotNull
    protected final ConnectionPool myPool;
    @NotNull
    protected final DBExceptionRecognizer myExceptionRecognizer;
    private final LinkedBlockingQueue<JdbcIntermediateSession> mySessions = new LinkedBlockingQueue();
    protected static final Pattern SIMPLE_VERSION_PATTERN = Pattern.compile("(\\d{1,2}(\\.\\d{1,3}){1,5})");

    public JdbcIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        this(JdbcIntermediateFacade.prepareDataSource(connectionString, connectionProperties, driver), connectionsLimit, exceptionRecognizer);
    }

    public JdbcIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        this.myPool = new ConnectionPool(dataSource);
        this.myPool.setConnectionsLimit(connectionsLimit);
        this.myExceptionRecognizer = exceptionRecognizer;
    }

    @NotNull
    private static DataSource prepareDataSource(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver) {
        SimpleDataSource dataSource = new SimpleDataSource(connectionString, connectionProperties, driver);
        dataSource.setLogWriter(new PrintWriter(System.out));
        return dataSource;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return UnknownDatabase.RDBMS;
    }

    @Override
    public synchronized void connect() {
        try {
            this.myPool.connect();
        }
        catch (SQLException sqle) {
            throw this.myExceptionRecognizer.recognizeException(sqle, "connect");
        }
    }

    @Override
    public synchronized void reconnect() {
        throw new RuntimeException("The JdbcInterFacade.reconnect has not been implemented yet.");
    }

    @Override
    public synchronized void disconnect() {
        try {
            while (!this.mySessions.isEmpty()) {
                Thread.sleep(10L);
                ArrayList sessionsToClose = new ArrayList(10);
                this.mySessions.drainTo(sessionsToClose, 10);
                for (JdbcIntermediateSession sessionToClose : sessionsToClose) {
                    sessionToClose.close();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myPool.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.myPool.isReady();
    }

    @Override
    @NotNull
    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo info = null;
        try {
            info = this.obtainConnectionInfoNatively();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (info == null) {
            info = this.obtainConnectionInfoFromJdbc();
        }
        return info;
    }

    @Nullable
    protected ConnectionInfo obtainConnectionInfoNatively() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ConnectionInfo obtainConnectionInfoFromJdbc() {
        Connection connection = this.myPool.borrow();
        try {
            DatabaseMetaData md = connection.getMetaData();
            String rdbmsName = md.getDatabaseProductName();
            if (rdbmsName == null) {
                rdbmsName = connection.getClass().getName();
            }
            String databaseName = connection.getCatalog();
            String schemaName = JdbcIntermediateFacade.getSchema(connection);
            String userName = this.getUserNameSafe(md);
            Version serverVersion = Version.of(md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion());
            Version driverVersion = Version.of(md.getDriverMajorVersion(), md.getDriverMinorVersion());
            ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, databaseName, schemaName, userName, serverVersion, driverVersion);
            this.myPool.release(connection);
            return connectionInfo;
        }
        catch (Throwable throwable) {
            try {
                this.myPool.release(connection);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw this.myExceptionRecognizer.recognizeException(sqle, "getting brief connection info using JDBC connection metadata");
            }
        }
    }

    private String getUserNameSafe(DatabaseMetaData md) {
        try {
            return md.getUserName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    private static String getSchema(Connection connection) {
        String schemaName = null;
        try {
            Class<?> connectionClass = connection.getClass();
            Method getSchemaMethod = connectionClass.getMethod("getSchema", new Class[0]);
            if (getSchemaMethod != null) {
                schemaName = (String)getSchemaMethod.invoke((Object)connection, new Object[0]);
            }
        }
        catch (NoSuchMethodException nsm) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schemaName;
    }

    @Override
    @NotNull
    public JdbcIntermediateSession openSession() {
        Connection connection;
        try {
            connection = this.myPool.borrow();
        }
        catch (SQLException sqle) {
            throw this.myExceptionRecognizer.recognizeException(sqle, "borrow a connection from the pool");
        }
        JdbcIntermediateSession session = this.instantiateSession(connection, false);
        this.mySessions.add(session);
        return session;
    }

    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new JdbcIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    @NotNull
    public DBExceptionRecognizer getExceptionRecognizer() {
        return this.myExceptionRecognizer;
    }

    void sessionIsClosed(@NotNull JdbcIntermediateSession session, @NotNull Connection connection) {
        this.mySessions.remove(session);
        this.myPool.release(connection);
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceName.equalsIgnoreCase("intermediate-service")) {
            return Objects.castTo(serviceClass, this);
        }
        return this.myPool.getSpecificService(serviceClass, serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ConnectionInfo getConnectionInfoSmartly(String envQuery, Pattern serverVersionPattern, int serverVersionGroupIndex, Pattern driverVersionPattern, int driverVersionGroupIndex) {
        JdbcIntermediateSession session = this.openSession();
        try {
            String driverVersionStr;
            String serverVersionStr;
            String rdbmsName;
            String[] env = session.queryOneRow(envQuery, 3, String.class);
            if (env == null) {
                env = new String[]{null, null, null};
            }
            assert (env.length == 3) : "Session info should contain 3 components";
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                rdbmsName = md.getDatabaseProductName();
                if (rdbmsName == null) {
                    rdbmsName = session.getConnection().getClass().getName();
                }
                serverVersionStr = md.getDatabaseProductVersion();
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
            Version serverVersion = JdbcIntermediateFacade.extractVersion(serverVersionStr, serverVersionPattern, serverVersionGroupIndex);
            Version driverVersion = JdbcIntermediateFacade.extractVersion(driverVersionStr, driverVersionPattern, driverVersionGroupIndex);
            ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
            return connectionInfo;
        }
        finally {
            session.close();
        }
    }

    @NotNull
    protected static Version extractVersion(@Nullable String serverVersionStr, @NotNull Pattern versionPattern, int groupIndex) {
        if (serverVersionStr == null || serverVersionStr.isEmpty()) {
            return Version.ZERO;
        }
        Matcher m = versionPattern.matcher(serverVersionStr);
        if (m.find()) {
            return Version.of(m.group(groupIndex));
        }
        return Version.ZERO;
    }

    public int countOpenedSessions() {
        return this.mySessions.size();
    }

    public int countOpenedConnections() {
        return this.myPool.countAllConnections();
    }

    public int countOpenedSeances() {
        int count = 0;
        for (JdbcIntermediateSession session : this.mySessions) {
            count += session.countOpenedSeances();
        }
        return count;
    }

    public int countOpenedCursors() {
        int count = 0;
        for (JdbcIntermediateSession session : this.mySessions) {
            count += session.countOpenedCursors();
        }
        return count;
    }
}

