/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class View {
    private final String myDepotPath;
    private final String myLocalPath;
    private final String myStringRepresentation;
    private final Mapping myDepotToLocalMapping;
    private final Mapping myLocalToDepotMapping;

    @Nullable
    public static View create(String viewString) {
        String[] params = ParametersList.parse((String)viewString);
        List<String> strings = Arrays.asList(params);
        if (strings.size() != 2) {
            return null;
        }
        String depot = strings.get(0).trim();
        String client = strings.get(1).trim();
        return new View(depot, client, viewString);
    }

    private View(String depotPath, String localPath, String viewString) {
        this.myDepotPath = depotPath;
        this.myLocalPath = localPath;
        this.myStringRepresentation = viewString;
        String rawDepot = depotPath.startsWith("-") || depotPath.startsWith("+") ? depotPath.substring(1) : depotPath;
        this.myDepotToLocalMapping = new Mapping(rawDepot, localPath);
        this.myLocalToDepotMapping = new Mapping(localPath, rawDepot);
    }

    public String getDepotPath() {
        return this.myDepotPath;
    }

    public String getLocalPath() {
        return this.myLocalPath;
    }

    public String toString() {
        return this.myStringRepresentation;
    }

    @Nullable
    public String match(String filePath, String clientName) {
        String result = this.myDepotToLocalMapping.replaceSrcPathWithDest(filePath);
        if (result == null) {
            return null;
        }
        String clientPrefix = "//" + clientName + "/";
        return StringUtil.startsWithIgnoreCase((String)result, (String)clientPrefix) ? result.substring(clientPrefix.length()) : result;
    }

    public boolean removeMatched() {
        return this.getDepotPath().startsWith("-");
    }

    @Nullable
    public static String getRelativePath(String filePath, String clientName, List<View> views) {
        String result = null;
        for (View view : views) {
            String localResult;
            if (clientName == null || (localResult = view.match(filePath, clientName)) == null) continue;
            if (view.removeMatched()) {
                result = null;
                continue;
            }
            result = localResult;
        }
        return result;
    }

    public static boolean isExcluded(@NotNull String clientPath, @NotNull List<View> views) {
        if (clientPath == null) {
            View.$$$reportNull$$$0(0);
        }
        if (views == null) {
            View.$$$reportNull$$$0(1);
        }
        for (int i = views.size() - 1; i >= 0; --i) {
            View view = views.get(i);
            if (view.myLocalToDepotMapping.replaceSrcPathWithDest(clientPath) == null) continue;
            return view.removeMatched();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processStringWithReferences(String stringWithReferences, ReferenceVisitor visitor) {
        int offset = 0;
        int refIndex = stringWithReferences.indexOf("%%", offset);
        int wildcardIndex = stringWithReferences.indexOf("\\.\\.\\.", offset);
        int starIndex = stringWithReferences.indexOf(".*", offset);
        while (refIndex >= 0 && stringWithReferences.length() > refIndex + 2 || wildcardIndex >= 0 || starIndex >= 0) {
            if (View.existsAndBefore(refIndex, wildcardIndex, starIndex)) {
                if (refIndex > offset) {
                    visitor.visitStringFragment(stringWithReferences.subSequence(offset, refIndex));
                }
                String referenceName = stringWithReferences.substring(refIndex + 2, refIndex + 3);
                try {
                    visitor.visitNextReference(Integer.parseInt(referenceName));
                }
                finally {
                    offset = refIndex + 3;
                }
                refIndex = stringWithReferences.indexOf("%%", offset);
                continue;
            }
            if (View.existsAndBefore(starIndex, wildcardIndex)) {
                if (starIndex > offset) {
                    visitor.visitStringFragment(stringWithReferences.subSequence(offset, starIndex));
                }
                try {
                    visitor.visitStar();
                }
                finally {
                    offset = starIndex + 2;
                }
                starIndex = stringWithReferences.indexOf(".*", offset);
                continue;
            }
            if (wildcardIndex > offset) {
                visitor.visitStringFragment(stringWithReferences.subSequence(offset, wildcardIndex));
            }
            try {
                visitor.visitWildcard();
            }
            finally {
                offset = wildcardIndex + 6;
            }
            wildcardIndex = stringWithReferences.indexOf("\\.\\.\\.", offset);
        }
        if (offset < stringWithReferences.length()) {
            visitor.visitStringFragment(stringWithReferences.subSequence(offset, stringWithReferences.length()));
        }
    }

    private static boolean existsAndBefore(int index, int ... otherIndices) {
        if (index == -1) {
            return false;
        }
        for (int otherIdx : otherIndices) {
            if (otherIdx >= index || otherIdx == -1) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "clientPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "views";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/perforce/perforce/View";
        objectArray[2] = "isExcluded";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Mapping {
        final String mySrcMask;
        final String myDestMask;
        private Matcher mySrcMatcher;
        private Map<Integer, Integer> mySrcPatternBackReferences;
        private List<Integer> myWildcardGroupNumbers;
        private List<Integer> myStarGroupNumbers;
        private int mySrcPatternGroupCount;
        private String myDestPattern;

        Mapping(String srcMask, String destMask) {
            this.mySrcMask = srcMask;
            this.myDestMask = destMask;
        }

        @Nullable
        private synchronized String replaceSrcPathWithDest(String filePath) {
            Matcher matcher = this.getMatcher(filePath);
            if (matcher.matches()) {
                return matcher.replaceFirst(this.convertDestMaskToReplacement(this.mySrcPatternBackReferences));
            }
            return null;
        }

        private Matcher getMatcher(String filePath) {
            if (this.mySrcMatcher == null) {
                String srcPattern = PatternUtil.convertToRegex((String)this.mySrcMask);
                this.mySrcPatternBackReferences = new HashMap<Integer, Integer>();
                this.myWildcardGroupNumbers = new ArrayList<Integer>();
                this.myStarGroupNumbers = new ArrayList<Integer>();
                this.mySrcPatternGroupCount = 1;
                final StringBuffer patternWithReferences = new StringBuffer();
                View.processStringWithReferences(srcPattern, new ReferenceVisitor(){

                    @Override
                    public void visitWildcard() {
                        this.visitGroup("(.*)", myWildcardGroupNumbers);
                    }

                    @Override
                    public void visitStar() {
                        this.visitGroup("([^/]+)", myStarGroupNumbers);
                    }

                    private void visitGroup(String patternToAdd, List<Integer> groupNumbersCollection) {
                        patternWithReferences.append(patternToAdd);
                        groupNumbersCollection.add(mySrcPatternGroupCount);
                        mySrcPatternGroupCount++;
                    }

                    @Override
                    public void visitNextReference(int referenceNum) {
                        patternWithReferences.append("(.*)");
                        mySrcPatternBackReferences.put(referenceNum, mySrcPatternGroupCount);
                        mySrcPatternGroupCount++;
                    }

                    @Override
                    public void visitStringFragment(CharSequence string) {
                        patternWithReferences.append(string.toString());
                    }
                });
                srcPattern = patternWithReferences.toString();
                Pattern pattern = Pattern.compile(srcPattern, 2);
                this.mySrcMatcher = pattern.matcher(filePath);
                return this.mySrcMatcher;
            }
            this.mySrcMatcher.reset(filePath);
            return this.mySrcMatcher;
        }

        private String convertDestMaskToReplacement(Map<Integer, Integer> backReferences) {
            StringBuilder result = new StringBuilder();
            View.processStringWithReferences(this.getDestPattern(), new MyReferenceVisitor(result, backReferences));
            return result.toString();
        }

        private String getDestPattern() {
            if (this.myDestPattern == null) {
                this.myDestPattern = PatternUtil.convertToRegex((String)this.myDestMask);
            }
            return this.myDestPattern;
        }

        private class MyReferenceVisitor
        implements ReferenceVisitor {
            private final StringBuilder myResult;
            private final Map<Integer, Integer> myBackReferences;
            private int myLastWildcardGroup = 0;
            private int myLastStarGroup = 0;

            public MyReferenceVisitor(StringBuilder result, Map<Integer, Integer> backReferences) {
                this.myResult = result;
                this.myBackReferences = backReferences;
            }

            @Override
            public void visitWildcard() {
                this.myLastWildcardGroup = this.visitGroup(this.myLastWildcardGroup, Mapping.this.myWildcardGroupNumbers);
            }

            @Override
            public void visitStar() {
                this.myLastStarGroup = this.visitGroup(this.myLastStarGroup, Mapping.this.myStarGroupNumbers);
            }

            private int visitGroup(int counter, List<Integer> groupNumbers) {
                if (counter < groupNumbers.size()) {
                    this.myResult.append("$").append(String.valueOf(groupNumbers.get(counter)));
                    return counter + 1;
                }
                return counter;
            }

            @Override
            public void visitNextReference(int referenceNum) {
                Integer refGroupNum = this.myBackReferences.get(referenceNum);
                if (refGroupNum != null) {
                    this.myResult.append("$");
                    this.myResult.append(refGroupNum);
                } else {
                    this.myResult.append("%%");
                    this.myResult.append(referenceNum);
                }
            }

            @Override
            public void visitStringFragment(CharSequence string) {
                this.myResult.append(string.toString());
            }
        }
    }

    static interface ReferenceVisitor {
        public void visitNextReference(int var1);

        public void visitStringFragment(CharSequence var1);

        public void visitWildcard();

        public void visitStar();
    }
}

