/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import com.intellij.util.text.SyncDateFormat;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.command.AbstractMessageParser;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateInformation;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.BugLog;

final class AnnotateMessageParser
extends AbstractMessageParser {
    @NonNls
    private static final String ANNOTATING = "Annotations for ";
    private static final String SEPARATOR1 = " (";
    private static final String SEPARATOR2 = "): ";
    @NonNls
    private static final String ANNOTATIONS_DATE_FORMAT_STR = "dd-MMM-yy";
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("dd-MMM-yy", Locale.US));
    private final IEventSender eventManager;
    private final ICvsFileSystem cvsFileSystem;
    private AnnotateInformation annotateInformation;

    public AnnotateMessageParser(IEventSender eventManager, ICvsFileSystem cvsFileSystem) {
        this.eventManager = eventManager;
        this.cvsFileSystem = cvsFileSystem;
    }

    @Override
    protected void outputDone() {
        if (this.annotateInformation == null) {
            return;
        }
        this.eventManager.notifyFileInfoListeners(this.annotateInformation);
        this.annotateInformation = null;
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (isErrorMessage) {
            if (line.startsWith(ANNOTATING)) {
                this.outputDone();
                String relativeFileName = line.substring(ANNOTATING.length());
                File file = this.cvsFileSystem.getLocalFileSystem().getFile(relativeFileName);
                this.annotateInformation = new AnnotateInformation(file);
            }
        } else {
            this.processLine(line);
        }
    }

    private void processLine(String line) {
        Date date;
        if (this.annotateInformation == null) {
            return;
        }
        int indexOpeningBracket = line.indexOf(SEPARATOR1);
        if (indexOpeningBracket < 0) {
            return;
        }
        int indexClosingBracket = line.indexOf(SEPARATOR2, indexOpeningBracket + 1);
        if (indexClosingBracket < 0) {
            return;
        }
        String revision = line.substring(0, indexOpeningBracket).trim();
        String authorAndDate = line.substring(indexOpeningBracket + SEPARATOR1.length(), indexClosingBracket);
        String contents = line.substring(indexClosingBracket + SEPARATOR2.length());
        int lastSpace = authorAndDate.lastIndexOf(32);
        if (lastSpace < 0) {
            return;
        }
        String author = authorAndDate.substring(0, lastSpace).trim();
        String dateString = authorAndDate.substring(lastSpace + 1);
        try {
            date = DATE_FORMAT.parse(dateString);
        }
        catch (ParseException ex) {
            BugLog.getInstance().showException(ex);
            return;
        }
        this.annotateInformation.addLine(new AnnotateLine(revision, author, date, contents));
    }
}

