/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReplaceIfWithConditionalIntention
extends JSIntention {
    private static final char TERNARY_QUESTION = '?';
    private static final char TERNARY_SEMICOLON = ':';
    @NonNls
    private static final String RETURN_KEYWORD = "return ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ReplaceIfWithConditionalPredicate replaceIfWithConditionalPredicate = new ReplaceIfWithConditionalPredicate();
        if (replaceIfWithConditionalPredicate == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(0);
        }
        return replaceIfWithConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(1);
        }
        JSIfStatement ifStatement = (JSIfStatement)(element.getParent() instanceof JSIfStatement ? element.getParent() : element);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)ifStatement);
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            StringBuilder newStatement = new StringBuilder();
            JSReplaceIfWithConditionalIntention.getAssignmentReplacement(newStatement, ifStatement);
            newStatement.append(semicolon);
            JSElementFactory.replaceStatement((JSStatement)ifStatement, (String)newStatement.toString());
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            JSReplaceIfWithConditionalIntention.replaceReturn(ifStatement, semicolon);
        }
    }

    private static void getAssignmentReplacement(StringBuilder buffer, JSIfStatement ifStatement) {
        JSExpression condition = ifStatement.getCondition();
        JSExpressionStatement thenBranch = (JSExpressionStatement)ConditionalUtils.stripBraces(ifStatement.getThen());
        JSAssignmentExpression thenAssign = (JSAssignmentExpression)thenBranch.getExpression();
        JSExpression thenRhs = thenAssign.getROperand();
        String operator = BinaryOperatorUtils.getOperatorText((IElementType)thenAssign.getOperationSign());
        JSStatement elseBranch = ifStatement.getElse();
        assert (thenRhs != null);
        buffer.append(thenAssign.getLOperand().getText()).append(operator).append(ParenthesesUtils.getParenthesized((JSExpression)condition, (int)15)).append('?').append(ParenthesesUtils.getParenthesized((JSExpression)thenRhs, (int)15)).append(':');
        if (elseBranch instanceof JSIfStatement) {
            JSReplaceIfWithConditionalIntention.getAssignmentReplacement(buffer, (JSIfStatement)elseBranch);
            return;
        }
        JSExpressionStatement strippedElseBranch = (JSExpressionStatement)ConditionalUtils.stripBraces(elseBranch);
        JSAssignmentExpression elseAssign = (JSAssignmentExpression)strippedElseBranch.getExpression();
        JSExpression elseRhs = elseAssign.getROperand();
        assert (elseRhs != null);
        buffer.append(ParenthesesUtils.getParenthesized((JSExpression)elseRhs, (int)15));
    }

    private static void replaceReturn(JSIfStatement ifStatement, String semicolon) {
        StringBuilder newStatement = new StringBuilder(RETURN_KEYWORD);
        JSReplaceIfWithConditionalIntention.getReturnReplacement(newStatement, ifStatement, JSReplaceIfWithConditionalIntention.getImplicitReturn(ifStatement));
        newStatement.append(semicolon);
        JSElementFactory.replaceStatement((JSStatement)ifStatement, (String)newStatement.toString());
    }

    private static void getReturnReplacement(StringBuilder buffer, JSIfStatement ifStatement, @Nullable JSReturnStatement implicitReturn) {
        JSReturnStatement thenReturn = (JSReturnStatement)ConditionalUtils.stripBraces(ifStatement.getThen());
        JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
        JSReplaceIfWithConditionalIntention.appendExpression(buffer, ifStatement.getCondition());
        buffer.append('?');
        JSReplaceIfWithConditionalIntention.appendExpression(buffer, thenReturn.getExpression());
        buffer.append(':');
        if (elseBranch instanceof JSIfStatement) {
            JSReplaceIfWithConditionalIntention.getReturnReplacement(buffer, (JSIfStatement)elseBranch, implicitReturn);
            return;
        }
        if (elseBranch instanceof JSReturnStatement) {
            JSReplaceIfWithConditionalIntention.appendExpression(buffer, ((JSReturnStatement)elseBranch).getExpression());
        }
        if (elseBranch == null && implicitReturn != null) {
            JSReplaceIfWithConditionalIntention.appendExpression(buffer, implicitReturn.getExpression());
            JSElementFactory.removeElement((PsiElement)implicitReturn);
        }
    }

    private static void appendExpression(StringBuilder buffer, JSExpression expression) {
        buffer.append(ParenthesesUtils.getParenthesized((JSExpression)expression, (int)15));
    }

    @Nullable
    private static JSReturnStatement getImplicitReturn(@NotNull JSIfStatement ifStatement) {
        if (ifStatement == null) {
            JSReplaceIfWithConditionalIntention.$$$reportNull$$$0(2);
        }
        return (JSReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement), JSReturnStatement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitReturn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceIfWithConditionalPredicate
    implements JSElementPredicate {
        private ReplaceIfWithConditionalPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ReplaceIfWithConditionalPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if (ErrorUtil.containsError((PsiElement)parent)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSExpression condition = ifStatement.getCondition();
            if (condition == null || !condition.isValid()) {
                return false;
            }
            return ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement) || ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement);
        }

        private static boolean isReplaceableReturn(@NotNull JSIfStatement ifStatement) {
            if (ifStatement == null) {
                ReplaceIfWithConditionalPredicate.$$$reportNull$$$0(1);
            }
            return ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement, JSReplaceIfWithConditionalIntention.getImplicitReturn(ifStatement) != null);
        }

        private static boolean isReplaceableReturn(@NotNull JSIfStatement ifStatement, boolean emptyReturnAllowed) {
            if (ifStatement == null) {
                ReplaceIfWithConditionalPredicate.$$$reportNull$$$0(2);
            }
            JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
            JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
            if (!(thenBranch instanceof JSReturnStatement) || ((JSReturnStatement)thenBranch).getExpression() == null) {
                return false;
            }
            if (elseBranch instanceof JSIfStatement) {
                return ReplaceIfWithConditionalPredicate.isReplaceableReturn((JSIfStatement)elseBranch, emptyReturnAllowed);
            }
            return emptyReturnAllowed && elseBranch == null || elseBranch instanceof JSReturnStatement && ((JSReturnStatement)elseBranch).getExpression() != null;
        }

        private static boolean isReplaceableAssignment(JSIfStatement ifStatement) {
            IElementType elseSign;
            JSStatement thenBranch = ConditionalUtils.stripBraces(ifStatement.getThen());
            if (thenBranch == null) {
                return false;
            }
            if (!ConditionalUtils.isAssignment(thenBranch)) {
                return false;
            }
            JSStatement elseBranch = ConditionalUtils.stripBraces(ifStatement.getElse());
            if (elseBranch == null) {
                return false;
            }
            if (elseBranch instanceof JSIfStatement) {
                return ReplaceIfWithConditionalPredicate.isReplaceableAssignment((JSIfStatement)elseBranch);
            }
            if (!ConditionalUtils.isAssignment(elseBranch)) {
                return false;
            }
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            if (thenExpression.getROperand() == null) {
                return false;
            }
            if (elseExpression.getROperand() == null || elseExpression.getLOperand() == null) {
                return false;
            }
            JSExpression thenRhs = thenExpression.getROperand();
            assert (thenRhs != null);
            JSExpression elseRhs = elseExpression.getROperand();
            if (elseRhs == null) {
                return false;
            }
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)thenLhs, (JSExpression)elseLhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSReplaceIfWithConditionalIntention$ReplaceIfWithConditionalPredicate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "satisfiedBy";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isReplaceableReturn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

