/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.increment;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSExtractIncrementIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        return this.getText(BinaryOperatorUtils.getOperatorText((IElementType)JSExtractIncrementIntention.getOperationSign(element)));
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ExtractIncrementPredicate extractIncrementPredicate = new ExtractIncrementPredicate();
        if (extractIncrementPredicate == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(0);
        }
        return extractIncrementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean isPostfix;
        if (element == null) {
            JSExtractIncrementIntention.$$$reportNull$$$0(1);
        }
        JSExpression operand = (isPostfix = element instanceof JSPostfixExpression) ? ((JSPostfixExpression)element).getExpression() : ((JSPrefixExpression)element).getExpression();
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        assert (statement != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)element.getContainingFile());
        ASTNode statementNode = JSChangeUtil.createStatementFromTextWithContext((String)(element.getText() + semicolon), (PsiElement)element);
        assert (statementNode != null) : element.getText();
        if (isPostfix) {
            statement.addStatementAfter((JSStatement)statementNode.getPsi());
        } else {
            statement.addStatementBefore((JSStatement)statementNode.getPsi());
        }
        JSElementFactory.replaceExpression((JSExpression)element, operand.getText());
    }

    private static IElementType getOperationSign(PsiElement element) {
        return element instanceof JSPostfixExpression ? ((JSPostfixExpression)element).getOperationSign() : ((JSPrefixExpression)element).getOperationSign();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExtractIncrementPredicate
    implements JSElementPredicate {
        private ExtractIncrementPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ExtractIncrementPredicate.$$$reportNull$$$0(0);
            }
            if (!ExpressionUtil.isIncrementDecrementExpression((PsiElement)element)) {
                return false;
            }
            if (ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSExpressionStatement) {
                return false;
            }
            JSStatement containingStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
            if (element instanceof JSPostfixExpression && (containingStatement instanceof JSReturnStatement || containingStatement instanceof JSThrowStatement)) {
                return false;
            }
            return containingStatement != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/increment/JSExtractIncrementIntention$ExtractIncrementPredicate", "satisfiedBy"));
        }
    }
}

