/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSIntention
extends PsiElementBaseIntentionAction {
    private static final Language JS_LANGUAGE = Language.findLanguageByID((String)"JavaScript");
    @NonNls
    private static final String INTENTION_SUFFIX = "Intention";
    @NonNls
    private static final String DISPLAY_NAME = ".display-name";
    @NonNls
    private static final String FAMILY_NAME = ".family-name";
    private static final String PACKAGE_NAME = JSIntention.class.getPackage().getName();
    private final JSElementPredicate predicate = this.getElementPredicate();

    protected JSIntention() {
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement matchingElement;
        if (project == null) {
            JSIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSIntention.$$$reportNull$$$0(1);
        }
        if ((matchingElement = this.findMatchingElement(element)) != null) {
            this.processIntention(matchingElement);
        }
    }

    protected abstract void processIntention(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    protected abstract JSElementPredicate getElementPredicate();

    @Nullable
    protected PsiElement findMatchingElement(@Nullable PsiElement element) {
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        Language language = element.getLanguage();
        if (language != Language.ANY && language != JavascriptLanguage.INSTANCE && !(language instanceof JSLanguageDialect)) {
            return null;
        }
        while (element != null) {
            if (this.predicate.satisfiedBy(element)) {
                return element;
            }
            if (!((element = element.getParent()) instanceof PsiFile) && !(element instanceof XmlElement)) continue;
            break;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSIntention.$$$reportNull$$$0(3);
        }
        return this.findMatchingElement(element) != null && JavaScriptIntention.isAcceptedFor((PsiElement)element, ((Object)((Object)this)).getClass());
    }

    protected String getTextKey(Object ... suffixes) {
        return JSIntentionBundle.getKey(((Object)((Object)this)).getClass().getName().substring(PACKAGE_NAME.length() + 1).replace("JS", ""), INTENTION_SUFFIX, null, suffixes);
    }

    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message(this.getTextKey(DISPLAY_NAME), new Object[0]);
        if (string == null) {
            JSIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getText(Object ... arguments) {
        return JSIntentionBundle.message(this.getTextKey(DISPLAY_NAME), arguments);
    }

    protected String getSuffixedDisplayName(@NonNls String suffix, Object ... arguments) {
        return JSIntentionBundle.message(this.getTextKey(DISPLAY_NAME, Character.valueOf('.'), suffix), arguments);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSIntentionBundle.message(this.getTextKey(FAMILY_NAME), new Object[0]);
        if (string == null) {
            JSIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/JSIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/JSIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

