/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

class ComposeFileUtil {
    ComposeFileUtil() {
    }

    public static PatternCondition<PsiElement> fromComposeFile() {
        return new PatternCondition<PsiElement>("from-docker-compose-file"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                PsiFile file;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (file = element.getContainingFile()) instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/composeFile/ComposeFileUtil$1", "accepts"));
            }
        };
    }

    public static boolean isDockerComposeYamlFile(@NotNull YAMLFile yamlFile) {
        VirtualFile vFile;
        if (yamlFile == null) {
            ComposeFileUtil.$$$reportNull$$$0(0);
        }
        if ((vFile = yamlFile.getOriginalFile().getVirtualFile()) == null) {
            return false;
        }
        if (ComposeFileUtil.isDockerComposeYamlFileName(vFile.getName())) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)yamlFile, () -> {
            if (yamlFile == null) {
                ComposeFileUtil.$$$reportNull$$$0(3);
            }
            boolean result = ComposeFileUtil.computeIsDockerComposeYamlFile(yamlFile);
            return new CachedValueProvider.Result((Object)result, new Object[]{yamlFile});
        });
    }

    private static boolean computeIsDockerComposeYamlFile(@NotNull YAMLFile yamlFile) {
        if (yamlFile == null) {
            ComposeFileUtil.$$$reportNull$$$0(1);
        }
        if (yamlFile.getDocuments().size() != 1) {
            return false;
        }
        YAMLValue topValue = ((YAMLDocument)yamlFile.getDocuments().get(0)).getTopLevelValue();
        if (!(topValue instanceof YAMLMapping)) {
            return false;
        }
        YAMLMapping topMapping = (YAMLMapping)topValue;
        return topMapping.getKeyValueByKey("version") != null && topMapping.getKeyValueByKey("services") != null;
    }

    private static boolean isDockerComposeYamlFileName(@NonNls @NotNull String fileName) {
        String lowerCaseName;
        if (fileName == null) {
            ComposeFileUtil.$$$reportNull$$$0(2);
        }
        return ((lowerCaseName = fileName.toLowerCase()).endsWith(".yaml") || lowerCaseName.endsWith(".yml")) && fileName.toLowerCase().contains("docker-compose");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDockerComposeYamlFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIsDockerComposeYamlFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDockerComposeYamlFileName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isDockerComposeYamlFile$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

