/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

public class ComposeFileReferenceResolver {
    public static final ComposeFileReferenceResolver SERVICES = new ComposeFileReferenceResolver("services");
    public static final ComposeFileReferenceResolver NETWORKS = new ComposeFileReferenceResolver("networks");
    public static final ComposeFileReferenceResolver VOLUMES = new ComposeFileReferenceResolver("volumes");
    private final String myDeclarationsMappingName;

    public ComposeFileReferenceResolver(@NotNull String declarationsMappingName) {
        if (declarationsMappingName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(0);
        }
        this.myDeclarationsMappingName = declarationsMappingName;
    }

    @NotNull
    public Optional<YAMLKeyValue> resolveByName(@Nullable PsiFile psiFile, @NotNull String lookupName) {
        if (lookupName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(1);
        }
        Optional<YAMLKeyValue> optional = Optional.ofNullable(psiFile).map(file -> (YAMLFile)ObjectUtils.tryCast((Object)file, YAMLFile.class)).map(file -> (YAMLDocument)ContainerUtil.getFirstItem((List)file.getDocuments())).flatMap(doc -> {
            if (lookupName == null) {
                ComposeFileReferenceResolver.$$$reportNull$$$0(17);
            }
            return this.resolveByName((YAMLDocument)doc, lookupName);
        });
        if (optional == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(2);
        }
        return optional;
    }

    @NotNull
    public Optional<YAMLKeyValue> resolveByName(@Nullable YAMLDocument document, @NotNull String lookupName) {
        if (lookupName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(3);
        }
        Optional<YAMLKeyValue> optional = this.listAllCandidates(document).stream().filter(kv -> {
            if (lookupName == null) {
                ComposeFileReferenceResolver.$$$reportNull$$$0(16);
            }
            return lookupName.equals(kv.getKeyText().trim());
        }).findAny();
        if (optional == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(4);
        }
        return optional;
    }

    @NotNull
    public Collection<YAMLKeyValue> listAllCandidates(@Nullable YAMLDocument document) {
        Optional<YAMLMapping> declarationsContainer = ComposeFileReferenceResolver.findTopLevelMappingByName(document, this.myDeclarationsMappingName);
        Collection collection = declarationsContainer.map(YAMLMapping::getKeyValues).orElse(Collections.emptyList());
        if (collection == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public List<LookupElementBuilder> createValueLookups(@NotNull PsiElement context) {
        if (context == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(6);
        }
        List<LookupElementBuilder> list = this.createValueLookups((YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)context, YAMLDocument.class), ComposeFileReferenceResolver.SKIP_ANCESTOR(context));
        if (list == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<LookupElementBuilder> createValueLookups(@Nullable YAMLDocument document, @NotNull Predicate<? super YAMLKeyValue> filter) {
        if (filter == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(8);
        }
        List<LookupElementBuilder> list = this.listAllCandidates(document).stream().filter(filter).map(this::createValueLookup).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static Predicate<YAMLKeyValue> SKIP_ANCESTOR(@NotNull PsiElement context) {
        if (context == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(10);
        }
        return kv -> {
            if (context == null) {
                ComposeFileReferenceResolver.$$$reportNull$$$0(15);
            }
            return !PsiTreeUtil.isAncestor((PsiElement)kv, (PsiElement)context, (boolean)true);
        };
    }

    @Nullable
    protected LookupElementBuilder createValueLookup(@NotNull YAMLKeyValue keyValue) {
        if (keyValue == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(11);
        }
        return LookupElementBuilder.create((String)keyValue.getKeyText().trim());
    }

    @NotNull
    private static Optional<YAMLMapping> findTopLevelMappingByName(@Nullable YAMLDocument document, @NotNull String nodeName) {
        if (nodeName == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(12);
        }
        Optional<YAMLMapping> optional = Optional.ofNullable(document).map(YAMLDocument::getTopLevelValue).filter(YAMLMapping.class::isInstance).map(YAMLMapping.class::cast).map(map -> {
            if (nodeName == null) {
                ComposeFileReferenceResolver.$$$reportNull$$$0(14);
            }
            return map.getKeyValueByKey(nodeName);
        }).map(YAMLKeyValue::getValue).filter(YAMLMapping.class::isInstance).map(YAMLMapping.class::cast);
        if (optional == null) {
            ComposeFileReferenceResolver.$$$reportNull$$$0(13);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationsMappingName";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileReferenceResolver";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileReferenceResolver";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveByName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllCandidates";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueLookups";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopLevelMappingByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveByName";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValueLookups";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "SKIP_ANCESTOR";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createValueLookup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelMappingByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findTopLevelMappingByName$5";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$SKIP_ANCESTOR$4";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveByName$3";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveByName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

