/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberPsiTreeListener;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public abstract class NotIndexedCucumberExtension
extends AbstractCucumberExtension {
    @Override
    public Object getDataObject(final @NotNull Project project) {
        if (project == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(0);
        }
        final DataObject result = new DataObject();
        result.myUpdateQueue.setPassThrough(false);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)result.myCucumberPsiTreeListener);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiElement parent = event.getParent();
                PsiElement child = event.getChild();
                if (NotIndexedCucumberExtension.this.isStepLikeFile(child, parent)) {
                    final PsiFile file = (PsiFile)child;
                    result.myUpdateQueue.queue(new Update(parent){

                        public void run() {
                            if (file.isValid()) {
                                NotIndexedCucumberExtension.this.reloadAbstractStepDefinitions(file);
                                NotIndexedCucumberExtension.this.createWatcher(file);
                            }
                        }
                    });
                }
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElement parent = event.getParent();
                final PsiElement child = event.getChild();
                if (NotIndexedCucumberExtension.this.isStepLikeFile(child, parent)) {
                    result.myUpdateQueue.queue(new Update(parent){

                        public void run() {
                            NotIndexedCucumberExtension.this.removeAbstractStepDefinitionsRelatedTo((PsiFile)child);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/NotIndexedCucumberExtension$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            final List<VirtualFile> myPreviousStepDefsProviders = new ArrayList<VirtualFile>();

            public void beforeRootsChange(ModuleRootEvent event) {
                this.myPreviousStepDefsProviders.clear();
                NotIndexedCucumberExtension.this.collectAllStepDefsProviders(this.myPreviousStepDefsProviders, project);
            }

            public void rootsChanged(ModuleRootEvent event) {
                ArrayList<VirtualFile> newStepDefsProviders = new ArrayList<VirtualFile>();
                NotIndexedCucumberExtension.this.collectAllStepDefsProviders(newStepDefsProviders, project);
                if (!this.compareRoots(newStepDefsProviders)) {
                    NotIndexedCucumberExtension.this.reset(project);
                }
            }

            private boolean compareRoots(List<VirtualFile> newStepDefsProviders) {
                if (this.myPreviousStepDefsProviders.size() != newStepDefsProviders.size()) {
                    return false;
                }
                for (VirtualFile root : this.myPreviousStepDefsProviders) {
                    if (newStepDefsProviders.contains(root)) continue;
                    return false;
                }
                return true;
            }
        });
        Disposer.register((Disposable)project, (Disposable)connection);
        return result;
    }

    @Override
    public Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(1);
        }
        Set<PsiDirectory> stepDefRoots = this.findStepDefsRoots(featureFile);
        HashSet stepDefs = ContainerUtil.newHashSet();
        for (PsiDirectory root : stepDefRoots) {
            stepDefs.addAll(this.gatherStepDefinitionsFilesFromDirectory(root, true));
        }
        return stepDefs.isEmpty() ? Collections.emptySet() : stepDefs;
    }

    protected Set<PsiDirectory> findStepDefsRoots(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(2);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile);
        VirtualFile file = featureFile.getVirtualFile();
        if (file == null || module == null) {
            return Collections.emptySet();
        }
        ArrayList<PsiDirectory> result = new ArrayList<PsiDirectory>();
        this.findRelatedStepDefsRoots(module, featureFile, result, new HashSet<String>());
        return new HashSet<PsiDirectory>(result);
    }

    private void createWatcher(final PsiFile file) {
        if (file.getProject().isDisposed()) {
            return;
        }
        final DataObject dataObject = (DataObject)CucumberStepsIndex.getInstance(file.getProject()).getExtensionDataObject(this);
        dataObject.myCucumberPsiTreeListener.addChangesWatcher((PsiElement)file, new CucumberPsiTreeListener.ChangesWatcher(){

            @Override
            public void onChange(PsiElement parentPsiElement) {
                dataObject.myUpdateQueue.queue(new Update(file){

                    public void run() {
                        if (!file.getProject().isDisposed()) {
                            NotIndexedCucumberExtension.this.reloadAbstractStepDefinitions(file);
                        }
                        DaemonCodeAnalyzer.getInstance((Project)file.getProject()).restart();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadAbstractStepDefinitions(PsiFile file) {
        if (file.getProject().isDisposed()) {
            return;
        }
        DataObject dataObject = (DataObject)CucumberStepsIndex.getInstance(file.getProject()).getExtensionDataObject(this);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = psiDocumentManager.getDocument(file);
        if (document != null) {
            psiDocumentManager.commitDocument(document);
        }
        this.removeAbstractStepDefinitionsRelatedTo(file);
        if (file.isValid()) {
            List<AbstractStepDefinition> list = dataObject.myStepDefinitions;
            synchronized (list) {
                dataObject.myStepDefinitions.addAll(this.getStepDefinitions(file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbstractStepDefinitionsRelatedTo(PsiFile file) {
        if (file.getProject().isDisposed()) {
            return;
        }
        DataObject dataObject = (DataObject)CucumberStepsIndex.getInstance(file.getProject()).getExtensionDataObject(this);
        List<AbstractStepDefinition> list = dataObject.myStepDefinitions;
        synchronized (list) {
            Iterator<AbstractStepDefinition> iterator = dataObject.myStepDefinitions.iterator();
            while (iterator.hasNext()) {
                AbstractStepDefinition definition = iterator.next();
                PsiElement element = definition.getElement();
                if (element != null && !element.getContainingFile().equals(file)) continue;
                iterator.remove();
            }
        }
    }

    @NotNull
    private List<PsiFile> gatherStepDefinitionsFilesFromDirectory(@NotNull PsiDirectory dir, boolean writableOnly) {
        if (dir == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(3);
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (PsiFile psiFile : dir.getFiles()) {
            boolean isStepFile;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            PsiDirectory parent = psiFile.getParent();
            if (parent == null) continue;
            boolean bl = isStepFile = writableOnly ? this.isWritableStepLikeFile((PsiElement)psiFile, (PsiElement)parent) : this.isStepLikeFile((PsiElement)psiFile, (PsiElement)parent);
            if (!isStepFile || virtualFile == null) continue;
            result.add(psiFile);
        }
        for (PsiFile psiFile : dir.getSubdirectories()) {
            result.addAll(this.gatherStepDefinitionsFilesFromDirectory((PsiDirectory)psiFile, writableOnly));
        }
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static void collectDependencies(Module module, Set<Module> modules) {
        Module[] dependencies;
        if (modules.contains(module)) {
            return;
        }
        for (Module dependency : dependencies = ModuleRootManager.getInstance((Module)module).getDependencies()) {
            if (modules.contains(dependency)) continue;
            modules.add(dependency);
            NotIndexedCucumberExtension.collectDependencies(dependency, modules);
        }
    }

    @Override
    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(5);
        }
        HashSet<Module> modules = new HashSet<Module>();
        NotIndexedCucumberExtension.collectDependencies(module, modules);
        modules.add(module);
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (Module current : modules) {
            result.addAll(this.loadStepsForModule(featureFile, current));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractStepDefinition> loadStepsForModule(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(6);
        }
        DataObject dataObject = (DataObject)CucumberStepsIndex.getInstance(module.getProject()).getExtensionDataObject(this);
        ArrayList<PsiDirectory> notLoadedStepDefinitionsRoots = new ArrayList<PsiDirectory>();
        try {
            if (featureFile != null) {
                this.findRelatedStepDefsRoots(module, featureFile, notLoadedStepDefinitionsRoots, dataObject.myProcessedStepDirectories);
            }
            this.loadStepDefinitionRootsFromLibraries(module, notLoadedStepDefinitionsRoots, dataObject.myProcessedStepDirectories);
        }
        catch (ProcessCanceledException e) {
            return Collections.emptyList();
        }
        List<AbstractStepDefinition> list = dataObject.myStepDefinitions;
        synchronized (list) {
            ArrayList<AbstractStepDefinition> stepDefinitions = new ArrayList<AbstractStepDefinition>();
            for (PsiDirectory root : notLoadedStepDefinitionsRoots) {
                stepDefinitions.clear();
                try {
                    dataObject.myProcessedStepDirectories.add(root.getVirtualFile().getPath());
                    List<PsiFile> files = this.gatherStepDefinitionsFilesFromDirectory(root, false);
                    for (PsiFile file : files) {
                        this.removeAbstractStepDefinitionsRelatedTo(file);
                        stepDefinitions.addAll(this.getStepDefinitions(file));
                        this.createWatcher(file);
                    }
                    dataObject.myStepDefinitions.addAll(stepDefinitions);
                }
                catch (ProcessCanceledException e) {
                    dataObject.myProcessedStepDirectories.remove(root.getVirtualFile().getPath());
                    if (!stepDefinitions.isEmpty()) {
                        dataObject.myStepDefinitions.removeAll(stepDefinitions);
                    }
                    throw e;
                }
            }
        }
        list = dataObject.myStepDefinitions;
        synchronized (list) {
            return new ArrayList<AbstractStepDefinition>(dataObject.myStepDefinitions);
        }
    }

    protected static void addStepDefsRootIfNecessary(VirtualFile root, @NotNull List<PsiDirectory> newStepDefinitionsRoots, @NotNull Set<String> processedStepDirectories, @NotNull Project project) {
        if (newStepDefinitionsRoots == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(7);
        }
        if (processedStepDirectories == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(8);
        }
        if (project == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(9);
        }
        if (root == null || !root.isValid()) {
            return;
        }
        String path = root.getPath();
        if (processedStepDirectories.contains(path)) {
            return;
        }
        PsiDirectory rootPathDir = PsiManager.getInstance((Project)project).findDirectory(root);
        if (rootPathDir != null && rootPathDir.isValid() && !newStepDefinitionsRoots.contains(rootPathDir)) {
            newStepDefinitionsRoots.add(rootPathDir);
        }
    }

    @Nullable
    protected static VirtualFile findContentRoot(Module module, VirtualFile file) {
        VirtualFile[] contentRoots;
        if (file == null || module == null) {
            return null;
        }
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return root;
        }
        return null;
    }

    protected abstract void loadStepDefinitionRootsFromLibraries(Module var1, List<PsiDirectory> var2, Set<String> var3);

    protected abstract Collection<AbstractStepDefinition> getStepDefinitions(@NotNull PsiFile var1);

    protected abstract void collectAllStepDefsProviders(@NotNull List<VirtualFile> var1, @NotNull Project var2);

    public abstract void findRelatedStepDefsRoots(@NotNull Module var1, @NotNull PsiFile var2, List<PsiDirectory> var3, Set<String> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(@NotNull Project project) {
        if (project == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(10);
        }
        DataObject dataObject = (DataObject)CucumberStepsIndex.getInstance(project).getExtensionDataObject(this);
        dataObject.myUpdateQueue.cancelAllUpdates();
        List<AbstractStepDefinition> list = dataObject.myStepDefinitions;
        synchronized (list) {
            dataObject.myStepDefinitions.clear();
        }
        dataObject.myProcessedStepDirectories.clear();
    }

    @Override
    public void flush(@NotNull Project project) {
        if (project == null) {
            NotIndexedCucumberExtension.$$$reportNull$$$0(11);
        }
        DataObject dataObject = (DataObject)CucumberStepsIndex.getInstance(project).getExtensionDataObject(this);
        dataObject.myUpdateQueue.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractStepDefinition> getAllStepDefinitions(Project project) {
        DataObject dataObject = (DataObject)CucumberStepsIndex.getInstance(project).getExtensionDataObject(this);
        List<AbstractStepDefinition> list = dataObject.myStepDefinitions;
        synchronized (list) {
            return new ArrayList<AbstractStepDefinition>(dataObject.myStepDefinitions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/NotIndexedCucumberExtension";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStepDefinitionsRoots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedStepDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/NotIndexedCucumberExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "gatherStepDefinitionsFilesFromDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataObject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefsRoots";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "gatherStepDefinitionsFilesFromDirectory";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsForModule";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addStepDefsRootIfNecessary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "flush";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DataObject {
        final List<AbstractStepDefinition> myStepDefinitions = new ArrayList<AbstractStepDefinition>();
        final Set<String> myProcessedStepDirectories = new HashSet<String>();
        final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("Steps reparse", 500, true, null);
        final CucumberPsiTreeListener myCucumberPsiTreeListener = new CucumberPsiTreeListener();
    }
}

