/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.wip.WipObjectKt$WhenMappings;
import org.jetbrains.wip.protocol.runtime.EntryPreviewValue;
import org.jetbrains.wip.protocol.runtime.ObjectPreviewValue;
import org.jetbrains.wip.protocol.runtime.PropertyPreviewValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"renderMap", "", "entries", "", "Lorg/jetbrains/wip/protocol/runtime/EntryPreviewValue;", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "renderProperty", "property", "Lorg/jetbrains/wip/protocol/runtime/PropertyPreviewValue;", "renderValue", "preview", "Lorg/jetbrains/wip/protocol/runtime/ObjectPreviewValue;", "renderPrimitive", "", "type", "Lorg/jetbrains/wip/protocol/runtime/PropertyPreviewValue$Type;", "value", "", "intellij.javascript.wip.backend"})
public final class WipObjectKt {
    private static final void renderProperty(PropertyPreviewValue property, XValuePresentation.XValueTextRenderer renderer) {
        block1: {
            ObjectPreviewValue objectPreviewValue;
            String string = property.getValue();
            if (string != null) {
                String string2;
                String it = string2 = string;
                WipObjectKt.renderPrimitive(renderer, property.type(), it);
                return;
            }
            ObjectPreviewValue objectPreviewValue2 = property.getValuePreview();
            if (objectPreviewValue2 == null) break block1;
            ObjectPreviewValue it = objectPreviewValue = objectPreviewValue2;
            WipObjectKt.renderValue(it, renderer);
        }
    }

    private static final boolean renderPrimitive(@NotNull XValuePresentation.XValueTextRenderer $receiver, PropertyPreviewValue.Type type, String value) {
        switch (WipObjectKt$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                $receiver.renderKeywordValue(value);
                break;
            }
            case 4: {
                $receiver.renderNumericValue(value);
                break;
            }
            case 5: {
                $receiver.renderStringValue(value, "\"\\", 1000);
                int actualStringLength = value.length();
                if (actualStringLength <= 1000) break;
                $receiver.renderComment(XDebuggerBundle.message((String)"node.text.ellipsis.truncated", (Object[])new Object[]{actualStringLength}));
                break;
            }
            case 6: {
                $receiver.renderComment(VariableViewKt.trimFunctionDescription((String)value));
                break;
            }
            case 7: {
                return false;
            }
            default: {
                $receiver.renderValue(value);
            }
        }
        return true;
    }

    private static final void renderMap(List<? extends EntryPreviewValue> entries, XValuePresentation.XValueTextRenderer renderer) {
        boolean isFirst = true;
        for (EntryPreviewValue entryPreviewValue : entries) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(",\n");
            }
            if (entryPreviewValue.getKey() != null) {
                ObjectPreviewValue objectPreviewValue;
                ObjectPreviewValue it = objectPreviewValue;
                WipObjectKt.renderValue(it, renderer);
                renderer.renderSpecialSymbol(" => ");
            }
            WipObjectKt.renderValue(entryPreviewValue.value(), renderer);
        }
    }

    private static final void renderValue(ObjectPreviewValue preview, XValuePresentation.XValueTextRenderer renderer) {
        Object it;
        Object object;
        String string = preview.getDescription();
        if (string != null) {
            PropertyPreviewValue.Type type;
            it = object = string;
            switch (WipObjectKt$WhenMappings.$EnumSwitchMapping$1[preview.type().ordinal()]) {
                case 1: {
                    type = PropertyPreviewValue.Type.OBJECT;
                    break;
                }
                case 2: {
                    type = PropertyPreviewValue.Type.FUNCTION;
                    break;
                }
                case 3: {
                    type = PropertyPreviewValue.Type.UNDEFINED;
                    break;
                }
                case 4: {
                    type = PropertyPreviewValue.Type.STRING;
                    break;
                }
                case 5: {
                    type = PropertyPreviewValue.Type.NUMBER;
                    break;
                }
                case 6: {
                    type = PropertyPreviewValue.Type.BOOLEAN;
                    break;
                }
                case 7: {
                    type = PropertyPreviewValue.Type.SYMBOL;
                    break;
                }
                case 8: {
                    type = PropertyPreviewValue.Type.NO_ENUM_CONST;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (WipObjectKt.renderPrimitive(renderer, type, (String)it)) {
                return;
            }
            renderer.renderComment((String)it);
        }
        renderer.renderSpecialSymbol(" {");
        List<EntryPreviewValue> list = preview.getEntries();
        if (list != null) {
            it = object = list;
            WipObjectKt.renderMap((List<? extends EntryPreviewValue>)it, renderer);
        }
        boolean isFirst = true;
        for (PropertyPreviewValue property : preview.properties()) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(",\n");
            }
            renderer.renderValue(property.name(), JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
            renderer.renderSpecialSymbol(": ");
            WipObjectKt.renderProperty(property, renderer);
        }
        if (preview.getOverflow()) {
            renderer.renderComment(",\n...");
        }
        renderer.renderSpecialSymbol("}");
    }

    public static final /* synthetic */ void access$renderValue(@NotNull ObjectPreviewValue preview, @NotNull XValuePresentation.XValueTextRenderer renderer) {
        WipObjectKt.renderValue(preview, renderer);
    }
}

