/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipBreakpointManagerKt;
import org.jetbrains.wip.WipBreakpointManagerKt$sam$Function$464d84df;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.domdebugger.DOMDebuggerKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J,\u0010\u0011\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0013\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0002J\u0006\u0010\u0018\u001a\u00020\u000eJ:\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0007H\u0014J\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J(\u0010$\u001a\b\u0012\u0004\u0012\u00020%0#2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0014\u0010(\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0014\u0010)\u001a\u00020\u00072\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\b\u0010,\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006-"}, d2={"Lorg/jetbrains/wip/WipBreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lorg/jetbrains/wip/WipBreakpoint;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "breakpointsActive", "", "regExpBreakpointSupported", "getRegExpBreakpointSupported", "()Z", "getVm", "()Lorg/jetbrains/wip/WipVm;", "breakpointReportedResolved", "", "eventData", "Lorg/jetbrains/wip/protocol/debugger/BreakpointResolvedEventData;", "breakpointResolvedHandler", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/Pair;", "", "", "Lorg/jetbrains/wip/protocol/debugger/LocationValue;", "breakpoint", "clearNonProvisionalBreakpoints", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "ignoreCount", "enabled", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "enableBreakpoints", "isBreakOnFirstStatement", "context", "Lorg/jetbrains/debugger/SuspendContext;", "setBreakOnFirstStatement", "intellij.javascript.wip.backend"})
public final class WipBreakpointManager
extends BreakpointManagerBase<WipBreakpoint> {
    private boolean breakpointsActive;
    private final boolean regExpBreakpointSupported = true;
    @NotNull
    private final WipVm vm;

    public boolean getRegExpBreakpointSupported() {
        return this.regExpBreakpointSupported;
    }

    @NotNull
    protected WipBreakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new WipBreakpoint(target, line, column, condition, enabled);
    }

    @NotNull
    protected Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull WipBreakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> breakpointResolvedHandler2 = this.breakpointResolvedHandler(breakpoint);
        Promise<Pair<String, List<LocationValue>>> promise2 = WipBreakpointManagerKt.sendSetBreakpointRequest(target, breakpoint.getLine(), breakpoint.getColumn(), breakpoint.getCondition(), this.vm.getCommandProcessor());
        Object object = breakpointResolvedHandler2;
        if (object != null) {
            Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> function1 = object;
            object = new WipBreakpointManagerKt$sam$Function$464d84df(function1);
        }
        Promise promise3 = promise2.then((Function)object).then(new Function<T, SUB_RESULT>(breakpoint){
            final /* synthetic */ WipBreakpoint $breakpoint;

            @NotNull
            public final WipBreakpoint fun(WipBreakpoint it) {
                return this.$breakpoint;
            }
            {
                this.$breakpoint = wipBreakpoint;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"sendSetBreakpointRequest\u2026     .then { breakpoint }");
        return promise3;
    }

    @NotNull
    protected Promise<?> doClearBreakpoint(@NotNull WipBreakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        WipCommandProcessor wipCommandProcessor = this.vm.getCommandProcessor();
        String string = breakpoint.getVmId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return wipCommandProcessor.send((Request)DebuggerKt.RemoveBreakpoint(string));
    }

    public final void clearNonProvisionalBreakpoints() {
        SmartList deleteList = new SmartList();
        for (WipBreakpoint breakpoint : this.getBreakpoints()) {
            if (breakpoint.getTarget() instanceof BreakpointTarget.ScriptId) {
                deleteList.add((Object)breakpoint);
                continue;
            }
            breakpoint.clearActualLocations();
        }
        for (WipBreakpoint breakpoint : deleteList) {
            try {
                this.getBreakpoints().remove((Object)breakpoint);
                BreakpointListener breakpointListener = (BreakpointListener)this.getDispatcher().getMulticaster();
                WipBreakpoint wipBreakpoint = breakpoint;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipBreakpoint), (String)"breakpoint");
                breakpointListener.nonProvisionalBreakpointRemoved((Breakpoint)wipBreakpoint);
            }
            catch (Throwable e) {
                CommandProcessorKt.getLOG().error(e);
            }
        }
    }

    public final void breakpointReportedResolved(@NotNull BreakpointResolvedEventData eventData) {
        Object v0;
        block2: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull((Object)eventData, (String)"eventData");
            String vmId = eventData.breakpointId();
            Iterable iterable2 = iterable = (Iterable)this.getBreakpoints();
            for (Object t : iterable2) {
                WipBreakpoint it = (WipBreakpoint)((Object)t);
                if (!Intrinsics.areEqual((Object)vmId, (Object)it.getVmId())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        WipBreakpoint wipBreakpoint = v0;
        if (wipBreakpoint == null) {
            return;
        }
        WipBreakpoint breakpoint = wipBreakpoint;
        breakpoint.addResolvedLocation(eventData.location());
        this.notifyBreakpointResolvedListener(breakpoint);
    }

    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        this.breakpointsActive = enabled;
        return this.vm.getCommandProcessor().send((Request)DebuggerKt.SetBreakpointsActive(enabled));
    }

    public void setBreakOnFirstStatement() {
        this.vm.getCommandProcessor().send((Request)DOMDebuggerKt.SetInstrumentationBreakpoint("scriptFirstStatement"));
    }

    public boolean isBreakOnFirstStatement(@NotNull SuspendContext<?> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        return context instanceof WipSuspendContext && ((WipSuspendContext)context).isBreakOnFirstStatement();
    }

    @NotNull
    public final Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> breakpointResolvedHandler(@NotNull WipBreakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        return (Function1)new Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint>(this, breakpoint){
            final /* synthetic */ WipBreakpointManager this$0;
            final /* synthetic */ WipBreakpoint $breakpoint;

            @NotNull
            public final WipBreakpoint invoke(@NotNull Pair<String, List<LocationValue>> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.$breakpoint.setVmId((String)it.first);
                this.$breakpoint.addResolvedLocations((List)it.second);
                WipBreakpointManager.access$notifyBreakpointResolvedListener(this.this$0, this.$breakpoint);
                return this.$breakpoint;
            }
            {
                this.this$0 = wipBreakpointManager;
                this.$breakpoint = wipBreakpoint;
                super(1);
            }
        };
    }

    @NotNull
    public final WipVm getVm() {
        return this.vm;
    }

    public WipBreakpointManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.breakpointsActive = true;
        this.regExpBreakpointSupported = true;
    }

    public static final /* synthetic */ void access$notifyBreakpointResolvedListener(WipBreakpointManager $this, @NotNull WipBreakpoint breakpoint) {
        $this.notifyBreakpointResolvedListener(breakpoint);
    }
}

