/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.ui.JSUiUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.PortField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0002H\u0014J\b\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0002H\u0014J\b\u0010*\u001a\u00020%H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "browserSelector", "Lcom/intellij/ide/browsers/BrowserSelector;", "browserSelectorLabel", "Ljavax/swing/JLabel;", "buildAndLaunch", "Lcom/intellij/ui/components/JBCheckBox;", "debugPort", "Lcom/intellij/ui/PortField;", "debugPortLabel", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "envVarsComponentLabel", "nodeInterpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "nodeInterpreterFieldLabel", "platformLabel", "platformModel", "Lcom/intellij/util/ui/RadioButtonEnumModel;", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "platformPanel", "Ljavax/swing/JPanel;", "reactNativeField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "reactNativeFieldLabel", "runArgumentsField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "runArgumentsLabel", "workingDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "workingDirFieldLabel", "applyEditorTo", "", "s", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "updateBuildConfigurationVisibility", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativeConfigurationEditor
extends SettingsEditor<ReactNativeRunConfiguration> {
    private final JBCheckBox buildAndLaunch;
    private final JLabel platformLabel;
    private final JPanel platformPanel;
    private final RadioButtonEnumModel<ReactNativePlatform> platformModel;
    private final JLabel runArgumentsLabel;
    private final TextFieldWithCompletion runArgumentsField;
    private final JLabel browserSelectorLabel;
    private final BrowserSelector browserSelector;
    private final JLabel debugPortLabel;
    private final PortField debugPort;
    private final JLabel reactNativeFieldLabel;
    private final NodePackageField reactNativeField;
    private final JLabel nodeInterpreterFieldLabel;
    private final NodeJsInterpreterField nodeInterpreterField;
    private final JLabel workingDirFieldLabel;
    private final TextFieldWithBrowseButton workingDirField;
    private final JLabel envVarsComponentLabel;
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;

    protected void resetEditorFrom(@NotNull ReactNativeRunConfiguration s) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)s), (String)"s");
        this.nodeInterpreterField.setInterpreterRef(s.getNodePath());
        NodePackage sPackage = s.getReactNativePackage();
        if (sPackage != null) {
            this.reactNativeField.setSelected(sPackage);
        } else {
            NodePackage defaultPackage = NodePackage.findDefaultPackage((Project)s.getProject(), (String)"react-native-cli", (NodeJsInterpreter)this.nodeInterpreterField.getInterpreter());
            if (defaultPackage != null) {
                this.reactNativeField.setSelected(defaultPackage);
            }
        }
        this.workingDirField.setText(s.getEffectiveWorkingDirectory());
        this.buildAndLaunch.setSelected(s.getBuildAndLaunch());
        this.platformModel.setSelected((Enum)s.getPlatform());
        this.runArgumentsField.setText(s.getRunArguments());
        this.envVarsComponent.setData(s.getEnvData());
        this.browserSelector.setSelected(s.getBrowser());
        this.debugPort.setNumber(s.getPackagerPort());
        this.updateBuildConfigurationVisibility();
    }

    protected void applyEditorTo(@NotNull ReactNativeRunConfiguration s) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)s), (String)"s");
        s.setReactNativePackage(this.reactNativeField.getSelected());
        NodeJsInterpreterRef nodeJsInterpreterRef = this.nodeInterpreterField.getInterpreterRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"nodeInterpreterField.interpreterRef");
        s.setNodePath(nodeJsInterpreterRef);
        if (Intrinsics.areEqual((Object)this.workingDirField.getText(), (Object)s.findWorkingDirectory())) {
            string = "";
        } else {
            String string2 = this.workingDirField.getText();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workingDirField.text");
        }
        s.setWorkingDirectory(string);
        s.setBuildAndLaunch(this.buildAndLaunch.isSelected());
        Enum enum_ = this.platformModel.getSelected();
        Intrinsics.checkExpressionValueIsNotNull((Object)enum_, (String)"platformModel.selected");
        s.setPlatform((ReactNativePlatform)enum_);
        String string3 = this.runArgumentsField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"runArgumentsField.text");
        s.setRunArguments(string3);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"envVarsComponent.data");
        s.setEnvData(environmentVariablesData);
        s.setBrowserId(this.browserSelector.getSelectedBrowserId());
        s.setPackagerPort(this.debugPort.getNumber());
    }

    private final void updateBuildConfigurationVisibility() {
        boolean selected = this.buildAndLaunch.isSelected();
        Component[] componentArray = this.platformPanel.getComponents();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentArray, (String)"platformPanel.components");
        for (Object element$iv : (Object[])componentArray) {
            Component it;
            Component component = it = (Component)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"it");
            component.setEnabled(selected);
        }
        this.platformLabel.setEnabled(selected);
        this.runArgumentsField.setEnabled(selected);
        this.runArgumentsLabel.setEnabled(selected);
        this.reactNativeFieldLabel.setVisible(selected);
        this.reactNativeField.setVisible(selected);
        this.nodeInterpreterFieldLabel.setVisible(selected);
        this.nodeInterpreterField.setVisible(selected);
        this.workingDirFieldLabel.setVisible(selected);
        this.workingDirField.setVisible(selected);
        this.envVarsComponentLabel.setVisible(selected);
        this.envVarsComponent.setVisible(selected);
    }

    @NotNull
    protected JComponent createEditor() {
        FormBuilder formBuilder2 = FormBuilder.createFormBuilder().addComponent((JComponent)this.buildAndLaunch).setFormLeftIndent(UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)((JCheckBox)this.buildAndLaunch))).addComponent((JComponent)new JLabel(JSUiUtil.getHtmlForCheckbox((String)"", (String)"Must be started manually on simulator or device if unchecked"))).addLabeledComponent((JComponent)this.platformLabel, (JComponent)this.platformPanel).addLabeledComponent((JComponent)this.runArgumentsLabel, (JComponent)this.runArgumentsField).setFormLeftIndent(0).addLabeledComponent((JComponent)this.browserSelectorLabel, this.browserSelector.getMainComponent(), 24).addLabeledComponent((JComponent)this.debugPortLabel, (JComponent)this.debugPort).addLabeledComponent((JComponent)this.nodeInterpreterFieldLabel, (JComponent)this.nodeInterpreterField, 24).addLabeledComponent((JComponent)this.reactNativeFieldLabel, (JComponent)this.reactNativeField).addLabeledComponent((JComponent)this.workingDirFieldLabel, (JComponent)this.workingDirField).addLabeledComponent((JComponent)this.envVarsComponentLabel, (JComponent)this.envVarsComponent);
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder2, (String)"FormBuilder.createFormBu\u2026tLabel, envVarsComponent)");
        JPanel jPanel = formBuilder2.getPanel();
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"FormBuilder.createFormBu\u2026rsComponent)\n      .panel");
        return jPanel;
    }

    public ReactNativeConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.platformLabel = new JLabel("Platform:");
        this.platformPanel = new JPanel(new GridBagLayout());
        this.runArgumentsLabel = new JLabel("Arguments:");
        this.reactNativeFieldLabel = new JLabel("React Native package:");
        this.nodeInterpreterFieldLabel = new JLabel("Node interpreter:");
        this.nodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.workingDirFieldLabel = new JLabel("Working directory:");
        this.workingDirField = new TextFieldWithBrowseButton();
        this.envVarsComponentLabel = new JLabel("Environment variables:");
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.reactNativeField = new NodePackageField(this.nodeInterpreterField, "react-native-cli");
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.workingDirField.addBrowseFolderListener(null, null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(this.workingDirField.getTextField(), descriptor, false, (Disposable)this.workingDirField);
        this.buildAndLaunch = new JBCheckBox("Build and launch application");
        this.buildAndLaunch.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                this.updateBuildConfigurationVisibility();
            }
        });
        this.platformModel = ReactNativeConfigurationEditorKt.createRadioButtonGroup(ReactNativePlatform.class, this.platformPanel);
        final TextFieldWithAutoCompletion.StringsCompletionProvider provider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)ReactNativePlatform.values()[0].getPossibleArguments(), null);
        this.runArgumentsField = new TextFieldWithCompletion(project, (TextCompletionProvider)provider, "", true, false, false);
        this.platformModel.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                provider.setItems((Collection)((ReactNativePlatform)platformModel.getSelected()).getPossibleArguments());
            }
        });
        this.browserSelector = new BrowserSelector((Condition)3.INSTANCE);
        this.browserSelectorLabel = new JLabel("Browser for debugging:");
        this.browserSelectorLabel.setLabelFor(this.browserSelector.getMainComponent());
        this.debugPort = new PortField();
        this.debugPortLabel = new JLabel("Bundler port:");
        this.debugPortLabel.setLabelFor((Component)this.debugPort);
        this.updateBuildConfigurationVisibility();
    }
}

