/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsoleMessageBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.WipConsoleAPICalledKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.protocol.log.LogEntryValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/debugger/wip/WipLogEntry;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/log/LogEntryValue;", "request", "Lorg/jetbrains/wip/RequestInfo;", "(Lorg/jetbrains/wip/protocol/log/LogEntryValue;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/ConsoleMessageBuilder;", "printFailedNetworkRequestMessage", "intellij.javascript.chrome.connector"})
public final class WipLogEntry
implements ConsoleMessage {
    private final LogEntryValue message;
    private final RequestInfo request;

    /*
     * Unable to fully structure code
     */
    public void print(@NotNull ConsoleMessageBuilder printer) {
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        url = this.message.getUrl();
        line = this.message.getLineNumber();
        v0 = this.message.getStackTrace();
        stackTrace = v0 != null ? v0.callFrames() : null;
        isFromNetwork = Intrinsics.areEqual((Object)this.message.source(), (Object)LogEntryValue.Source.NETWORK);
        if (isFromNetwork) {
            if (this.request == null) {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, (int)2, null);
                v1 = this.message.getUrl();
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                ConsoleMessageBuilder.addFileLink$default((ConsoleMessageBuilder)printer, (String)v1, (int)-1, (int)-1, null, (boolean)false, null, (int)32, null);
            } else {
                if (this.request.getInitiator() != null) {
                    v2 = this.request.getInitiator();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    v3 = v2.getStack();
                    stackTrace = v3 != null ? v3.callFrames() : null;
                    v4 = this.request.getInitiator();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringUtil.isEmpty((String)v4.getUrl())) {
                        v5 = this.request.getInitiator();
                        if (v5 == null) {
                            Intrinsics.throwNpe();
                        }
                        url = v5.getUrl();
                        v6 = this.request.getInitiator();
                        if (v6 == null) {
                            Intrinsics.throwNpe();
                        }
                        line = (int)v6.getLineNumber();
                    }
                }
                if (Intrinsics.areEqual((Object)this.message.level(), (Object)LogEntryValue.Level.ERROR)) {
                    this.printFailedNetworkRequestMessage(printer);
                } else {
                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, (int)2, null);
                }
            }
        } else {
            ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, (int)2, null);
        }
        if (!isFromNetwork && !Intrinsics.areEqual((Object)this.message.level(), (Object)LogEntryValue.Level.ERROR)) ** GOTO lbl-1000
        v7 = stackTrace;
        if (!(v7 != null ? v7.isEmpty() : true)) {
            v8 = true;
        } else lbl-1000:
        // 2 sources

        {
            v8 = willPrintStackTrace = false;
        }
        if (!(willPrintStackTrace || isFromNetwork && this.request == null)) {
            v9 = stackTrace;
            v10 = callFrame = v9 != null ? (CallFrameValue)CollectionsKt.firstOrNull(v9) : null;
            if (callFrame != null && !((var8_8 = (CharSequence)callFrame.url()).length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                ConsoleMessageBuilder.addFileLink$default((ConsoleMessageBuilder)printer, (String)callFrame.url(), (int)callFrame.getLineNumber(), (int)callFrame.getColumnNumber(), (String)callFrame.functionName(), (boolean)(isFromNetwork == false), null, (int)32, null);
            } else {
                var8_8 = url;
                if (!(var8_8 == null || var8_8.length() == 0) && Intrinsics.areEqual((Object)url, (Object)"undefined") ^ true) {
                    v11 = url;
                    if (v11 == null) {
                        Intrinsics.throwNpe();
                    }
                    ConsoleMessageBuilder.addFileLink$default((ConsoleMessageBuilder)printer, (String)v11, (int)line, (int)0, null, (boolean)(isFromNetwork == false), null, (int)32, null);
                }
            }
        }
        printer.newLine();
        if (willPrintStackTrace) {
            v12 = contentType = Intrinsics.areEqual((Object)this.message.level(), (Object)LogEntryValue.Level.ERROR) != false ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"contentType");
            WipConsoleAPICalledKt.printStackTrace(printer, v12, stackTrace);
        }
    }

    private final void printFailedNetworkRequestMessage(ConsoleMessageBuilder printer) {
        RequestInfo requestInfo = this.request;
        if (requestInfo == null) {
            Intrinsics.throwNpe();
        }
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    public WipLogEntry(@NotNull LogEntryValue message, @Nullable RequestInfo request) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
        this.request = request;
    }
}

