/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.JSRemoteDebugConfiguration;
import com.jetbrains.debugger.wip.JSRemoteDebugConfigurationKt;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import com.jetbrains.nodeJs.NodeJSFileFinder;
import com.jetbrains.nodeJs.NodeJsDebugProcess;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import java.awt.Component;
import java.awt.LayoutManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggableRunConfiguration;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.v8.StandaloneV8Vm;
import org.jetbrains.v8.V8Vm;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00010B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\"\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\"\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150&H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0017J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0017R$\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n8\u0002@BX\u0083\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/intellij/javascript/JSRunProfileWithCompileBeforeLaunchOption;", "Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "value", "host", "setHost", "(Ljava/lang/String;)V", "isV8Legacy", "", "port", "", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "computeDebugAddress", "Ljava/net/InetSocketAddress;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "createV8LegacyDebugProcess", "createWipDebugProcess", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "getState", "executor", "Lcom/intellij/execution/Executor;", "env", "readExternal", "", "element", "Lorg/jdom/Element;", "writeExternal", "WipRemoteDebugConfigurationSettingsEditor", "intellij.javascript.chrome.connector"})
public final class JSRemoteDebugConfiguration
extends LocatableConfigurationBase
implements RunConfigurationWithSuppressedDefaultRunAction,
JSRunProfileWithCompileBeforeLaunchOption,
DebuggableRunConfiguration {
    @Attribute
    private String host;
    @Attribute
    private int port;
    @Attribute
    private boolean isV8Legacy;

    private final void setHost(String value) {
        this.host = StringUtil.isEmpty((String)value) || Intrinsics.areEqual((Object)value, (Object)"localhost") || Intrinsics.areEqual((Object)value, (Object)"127.0.0.1") ? null : value;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new WipRemoteDebugConfigurationSettingsEditor();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        return EmptyRunProfileState.INSTANCE;
    }

    @NotNull
    public RunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        if (runConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.debugger.wip.JSRemoteDebugConfiguration");
        }
        JSRemoteDebugConfiguration configuration = (JSRemoteDebugConfiguration)runConfiguration;
        configuration.setHost(this.host);
        configuration.port = this.port;
        configuration.isV8Legacy = this.isV8Legacy;
        return (RunConfiguration)configuration;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)element);
        if (this.port <= 0) {
            this.port = JSRemoteDebugConfigurationKt.access$getDEFAULT_PORT$p();
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)((SerializationFilter)JSRemoteDebugConfigurationKt.access$getSERIALIZATION_FILTER$p()));
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(@NotNull RunProfileState state) {
        InetSocketAddress inetSocketAddress;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (this.host == null) {
            inetSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), this.port);
        } else {
            String string = this.host;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            inetSocketAddress = new InetSocketAddress(string, this.port);
        }
        return inetSocketAddress;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return this.isV8Legacy ? this.createV8LegacyDebugProcess(socketAddress, session2, executionResult) : this.createWipDebugProcess(socketAddress, session2, executionResult);
    }

    private final XDebugProcess createWipDebugProcess(InetSocketAddress socketAddress, XDebugSession session2, ExecutionResult executionResult) {
        WipRemoteVmConnection connection2 = new WipRemoteVmConnection(null, null, 3, null);
        BrowserChromeDebugProcess process2 = new BrowserChromeDebugProcess(session2, (DebuggableFileFinder)new LocalFileSystemFileFinder(true), (VmConnection)connection2, executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)socketAddress, null, (int)2, null);
        return (XDebugProcess)process2;
    }

    private final XDebugProcess createV8LegacyDebugProcess(InetSocketAddress socketAddress, XDebugSession session2, ExecutionResult executionResult) {
        RemoteVmConnection connection2 = new RemoteVmConnection(session2){
            final /* synthetic */ XDebugSession $session;

            @NotNull
            public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<Vm> vmResult) {
                Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
                Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
                Bootstrap bootstrap = NettyUtil.nioClientBootstrap((EventLoopGroup)((EventLoopGroup)WipRemoteVmConnectionKt.getEVENT_LOOP_GROUP()));
                EventDispatcher dispatcher = this.getDispatcher();
                bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(this, dispatcher, vmResult, address){
                    final /* synthetic */ createV8LegacyDebugProcess.connection.1 this$0;
                    final /* synthetic */ EventDispatcher $dispatcher;
                    final /* synthetic */ AsyncPromise $vmResult;
                    final /* synthetic */ InetSocketAddress $address;

                    protected void initChannel(@NotNull Channel ch) {
                        Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
                        ScheduledFuture<?> connectToWip2 = AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(this){
                            final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.1 this$0;

                            public final void run() {
                                WipRemoteVmConnection wipConnection2 = new WipRemoteVmConnection(this){
                                    final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.initChannel.connectToWip.1 this$0;

                                    @NotNull
                                    public EventDispatcher<DebugEventListener> getDispatcher() {
                                        return this.this$0.this$0.$dispatcher;
                                    }
                                    {
                                        this.this$0 = $outer;
                                        super(null, null, 3, null);
                                    }
                                };
                                AsyncPromise wipResult = new AsyncPromise();
                                wipResult.then((Function)new Function<T, SUB_RESULT>(this){
                                    final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.initChannel.connectToWip.1 this$0;

                                    public final Vm fun(Vm vm) {
                                        String message = JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol.detected", (Object[])new Object[]{JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol", (Object[])new Object[0])});
                                        this.this$0.this$0.this$0.$session.reportMessage(message, MessageType.INFO);
                                        this.this$0.this$0.$vmResult.setResult((Object)vm);
                                        return vm;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                                Bootstrap wipBootstrap = wipConnection2.createBootstrap(this.this$0.$address, (AsyncPromise<Vm>)wipResult);
                                NettyKt.connectRetrying$default((Bootstrap)wipBootstrap, (InetSocketAddress)this.this$0.$address, (int)2, null, (int)4, null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, 3L, TimeUnit.SECONDS);
                        AsyncPromise v8Attempt = new AsyncPromise();
                        v8Attempt.then((Function)new Function<T, SUB_RESULT>(this){
                            final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.1 this$0;

                            public final Vm fun(Vm vm) {
                                this.this$0.$vmResult.setResult((Object)vm);
                                return vm;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }).rejected((Consumer)new Consumer<Throwable>(this){
                            final /* synthetic */ createV8LegacyDebugProcess.connection.createBootstrap.1 this$0;

                            public final void consume(Throwable e) {
                                AsyncPromise asyncPromise = this.this$0.$vmResult;
                                Throwable throwable = e;
                                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e");
                                asyncPromise.setError(throwable);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }).processed((Consumer)new Consumer<Vm>(connectToWip2){
                            final /* synthetic */ ScheduledFuture $connectToWip;

                            public final void consume(Vm $noName_0) {
                                this.$connectToWip.cancel(true);
                            }
                            {
                                this.$connectToWip = scheduledFuture;
                            }
                        });
                        new StandaloneV8Vm(ch, createV8LegacyDebugProcess.connection.1.access$getDebugEventListener$p(this.this$0), (AsyncPromise<? super V8Vm>)v8Attempt, "");
                    }
                    {
                        this.this$0 = $outer;
                        this.$dispatcher = $captured_local_variable$1;
                        this.$vmResult = $captured_local_variable$2;
                        this.$address = $captured_local_variable$3;
                    }
                });
                Bootstrap bootstrap2 = bootstrap;
                Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
                return bootstrap2;
            }
            {
                this.$session = $captured_local_variable$0;
            }

            @NotNull
            public static final /* synthetic */ DebugEventListener access$getDebugEventListener$p(createV8LegacyDebugProcess.connection.1 $this) {
                return $this.getDebugEventListener();
            }
        };
        VmConnection vmConnection = (VmConnection)connection2;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        NodeJsDebugProcess process2 = new NodeJsDebugProcess(session2, (VmConnection<Vm>)vmConnection, (DebuggableFileFinder)new NodeJSFileFinder(project), false, executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)socketAddress, null, (int)2, null);
        return (XDebugProcess)process2;
    }

    public JSRemoteDebugConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(project, factory, name);
        this.port = JSRemoteDebugConfigurationKt.access$getDEFAULT_PORT$p();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration$WipRemoteDebugConfigurationSettingsEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;", "(Lcom/jetbrains/debugger/wip/JSRemoteDebugConfiguration;)V", "hostField", "Ljavax/swing/JTextField;", "portField", "Lcom/intellij/ui/PortField;", "v8RadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "wipRadioButton", "applyEditorTo", "", "configuration", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "intellij.javascript.chrome.connector"})
    private final class WipRemoteDebugConfigurationSettingsEditor
    extends SettingsEditor<JSRemoteDebugConfiguration> {
        private final JTextField hostField;
        private final PortField portField;
        private final JBRadioButton wipRadioButton;
        private final JBRadioButton v8RadioButton;

        protected void resetEditorFrom(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
            this.hostField.setText(StringUtil.notNullize((String)configuration.host, (String)"localhost"));
            this.portField.setNumber(configuration.port);
            this.wipRadioButton.setSelected(!configuration.isV8Legacy);
            this.v8RadioButton.setSelected(configuration.isV8Legacy);
        }

        protected void applyEditorTo(@NotNull JSRemoteDebugConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
            configuration.setHost(this.hostField.getText());
            configuration.port = this.portField.getNumber();
            configuration.isV8Legacy = this.v8RadioButton.isSelected();
        }

        @NotNull
        protected JComponent createEditor() {
            JPanel protocolPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            protocolPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSDebuggerBundle.message((String)"js.remote.debug.attach.to", (Object[])new Object[0])));
            protocolPanel.add((Component)this.wipRadioButton);
            protocolPanel.add((Component)this.v8RadioButton);
            FormBuilder formBuilder2 = FormBuilder.createFormBuilder().addLabeledComponent(JSDebuggerBundle.message((String)"js.remote.debug.host", (Object[])new Object[0]), (JComponent)this.hostField).addLabeledComponent(JSDebuggerBundle.message((String)"js.remote.debug.port", (Object[])new Object[0]), (JComponent)this.portField).addComponent((JComponent)protocolPanel, 7);
            Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder2, (String)"FormBuilder.createFormBu\u2026.TITLED_BORDER_TOP_INSET)");
            JPanel jPanel = formBuilder2.getPanel();
            Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"FormBuilder.createFormBu\u2026TOP_INSET)\n        .panel");
            return jPanel;
        }

        public WipRemoteDebugConfigurationSettingsEditor() {
            JTextField jTextField = GuiUtils.createUndoableTextField();
            Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"GuiUtils.createUndoableTextField()");
            this.hostField = jTextField;
            this.portField = new PortField(JSRemoteDebugConfigurationKt.access$getDEFAULT_PORT$p(), 1024);
            this.wipRadioButton = new JBRadioButton(JSDebuggerBundle.message((String)"js.remote.debug.inspector.protocol", (Object[])new Object[0]));
            this.v8RadioButton = new JBRadioButton(JSDebuggerBundle.message((String)"js.remote.debug.node.protocol", (Object[])new Object[0]));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.wipRadioButton);
            buttonGroup.add((AbstractButton)this.v8RadioButton);
        }
    }
}

