/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.openapi.project.Project;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/debugger/wip/ChromeLocalDebuggerEngine;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "()V", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "getBrowserFamily", "()Lcom/intellij/ide/browsers/BrowserFamily;", "requiresExtension", "", "getRequiresExtension", "()Z", "createDebugProcess", "Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "initialUrl", "Lcom/intellij/util/Url;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "usePreliminaryPage", "intellij.javascript.chrome.connector"})
public class ChromeLocalDebuggerEngine
extends JavaScriptDebugEngine {
    @NotNull
    private final BrowserFamily browserFamily = BrowserFamily.CHROME;
    private final boolean requiresExtension = false;

    @NotNull
    public BrowserFamily getBrowserFamily() {
        return this.browserFamily;
    }

    @NotNull
    public ChromeDebugProcess createDebugProcess(@NotNull XDebugSession session2, @NotNull WebBrowser browser, @NotNull DebuggableFileFinder fileFinder, @Nullable Url initialUrl, @Nullable ExecutionResult executionResult, boolean usePreliminaryPage) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        Intrinsics.checkParameterIsNotNull((Object)fileFinder, (String)"fileFinder");
        ChromeLocalVmConnection connection2 = new ChromeLocalVmConnection(initialUrl, usePreliminaryPage, browser, session2.getRunProfile());
        BrowserChromeDebugProcess process2 = new BrowserChromeDebugProcess(session2, fileFinder, (VmConnection)connection2, executionResult);
        Project project = session2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
        connection2.connect(project);
        return process2;
    }

    public boolean getRequiresExtension() {
        return this.requiresExtension;
    }
}

