# Reference

## @description List of API categories available in the editors

```namespaces
basic.showNumber(0);
input.onButtonPressed(Button.A, () => {
    
});
music.playTone(0, 0);
led.plot(0, 0);
radio.sendNumber(0);
```
## Advanced

```namespaces
game.addScore(1);
images.createImage(`
. . . . .
. . . . .
. . # . .
. . . . .
. . . . .
`);
pins.digitalReadPin(DigitalPin.P0);
serial.writeNumber(0);
control.inBackground(() => {
    
});
```

## Bluetooth

```namespaces
bluetooth.onBluetoothConnected(() => {});
devices.tellCameraTo(MesCameraEvent.TakePhoto);
```
  
```package
radio
devices
bluetooth
```

## See Also

[basic](/reference/basic), [input](/reference/input), [music](/reference/music), [led](/reference/led), [Math (blocks)](/blocks/math), [String](/types/string), [game](/reference/game), [images](/reference/images), [pins](/reference/pins), [serial](/reference/serial), [control](/reference/control), [radio](/reference/radio), [devices](/reference/devices), [bluetooth](/reference/bluetooth)
