# Technical information about browser support

[@homeurl@][] requires that you use a recent version of a modern
browser, such as Microsoft Edge, Google Chrome, Mozilla Firefox, Safari, Opera,
or IE11.  This is because the editor uses modern web technologies such as [web
workers][] to enable compiling [TypeScript][] in the browser, or the using the
same [Monaco][] editor that powers [Visual Studio Code][].

[@homeurl@]: @homeurl@
[web workers]: http://www.w3.org/TR/workers/
[typescript]: http://www.typescriptlang.org
[monaco]: https://microsoft.github.io/monaco-editor/
[visual studio code]: http://code.visualstudio.com

Most modern browsers automatically update themselves, but in some environments
such as schools these automatic updates are disabled for security. **We
strongly recommend that you use the most recent version of any of these
browsers**, but if you can't then you must use at least:

| Browser             | Minimum version | Release date   | Windows     | Mac        | Mobile OS  |
| ------------------- | --------------- | -------------- | ----------- | ---------- | ---------- |
| Edge                | 12              | March 2015     | Windows 10+ | N/A        | N/A        |
| Internet Explorer   | 11              | October 2013   | Windows 7+  | N/A        | N/A        |
| Mozilla Firefox     | 31 ESR          | July 2014      | Windows XP+ | OS X 10.6+ | N/A        |
| Google Chrome       | 38              | October 2014   | Windows XP+ | OS X 10.6+ | Android 5+ |
| Safari              | 9               | September 2015 | N/A         | OS X 10.9+ | N/A        |
| Opera               | 21              | May 2014       | Windows 7+  | OS X 10.9+ | N/A        |
| Mobile Safari       | 9               | September 2015 | N/A         | N/A        | iOS 9+     |
| Chrome for Android  | 59              | March 2017     | N/A         | N/A        | Android 5+ |
| Firefox for Android | 55              | August 2017    | N/A         | N/A        | Android 5+ |


Please see our information for which browsers are recommended for [Windows][],
[Mac][], [Linux][], or [Raspberry Pi][].

[Windows]: /browsers/windows
[Mac]: /browsers/mac
[Linux]: /browsers/linux
[Raspberry Pi]: /raspberry-pi
