'use strict';

goog.provide('Blockly.Python.sensor');

goog.require('Blockly.Python');

//ok
Blockly.Python.sensor_button_is_pressed = function(){
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    var btn = Blockly.Python.valueToCode(this, 'btn', Blockly.Python.ORDER_ATOMIC);
    var code =  btn + '.is_pressed()';
    return [code, Blockly.Python.ORDER_ATOMIC];
};
//ok
Blockly.Python.sensor_button_was_pressed = function(){
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    var btn = Blockly.Python.valueToCode(this, 'btn', Blockly.Python.ORDER_ATOMIC);
    var code =  btn + '.was_pressed()';
    return [code, Blockly.Python.ORDER_ATOMIC];
};
//ok
Blockly.Python.sensor_button_get_presses = function(){
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    var btn = Blockly.Python.valueToCode(this, 'btn', Blockly.Python.ORDER_ATOMIC);
    var code =  btn + '.get_presses()';
    return [code, Blockly.Python.ORDER_ATOMIC];
};
//ok
Blockly.Python.controls_GestureLists = function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    var gesture = this.getFieldValue('gesture');
    // Blockly.Python.definitions_['func_gesture' + gesture] = code;
    return ['"'+gesture+'"', Blockly.Python.ORDER_ATOMIC];
}
//ok
Blockly.Python.controls_attachGestureInterrupt = function(){
    Blockly.Python.definitions_['import_mpu9250_*'] = 'from mpu9250 import *';
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    var gesture = this.getFieldValue('gesture');
    var branch = Blockly.Python.statementToCode(this, 'DO');
    var d=branch || Blockly.Python.PASS;
    var code = 'if accelerometer.is_gesture("' + gesture + '"):\n' + d;
    // Blockly.Python.definitions_['func_gesture' + gesture] = code;
    return code;
}
//ok
Blockly.Python.controls_attachGestureInterrupt2 = function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    var gesture = this.getFieldValue('gesture');
    var branch = Blockly.Python.statementToCode(this, 'DO');
    var d=branch || Blockly.Python.PASS;
    var code = 'if accelerometer.was_gesture("' + gesture + '"):\n' + d;
    // Blockly.Python.definitions_['func_gesture' + gesture] = code;
    return code;
}
//ok
Blockly.Python.sensor_get_gestures= function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    var gesture = this.getFieldValue('GES');
    var a;
    if(gesture =='all'){
        a = 'accelerometer.get_gestures()';
    }
    else if(gesture =='current'){
        a = 'accelerometer.current_gesture()';
    }
    return [a, Blockly.Python.ORDER_ATOMIC];
};
//ok
Blockly.Python.sensor_current_gesture= function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    return ['accelerometer.current_gesture()', Blockly.Python.ORDER_ATOMIC];
};

//ok
Blockly.Python.sensor_get_acceleration = function(){
    Blockly.Python.definitions_['import_mpu9250_*'] = 'from mpu9250 import *';
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    var key = this.getFieldValue('key')
    var code = 'accelerometer.get_' + key + '()';
    return [code, Blockly.Python.ORDER_ATOMIC];
};

Blockly.Python.sensor_set_acceleration = function(){
    var key = this.getFieldValue('key')
    var code = 'input.setAccelerometerRange(' + key  + ')\n';
    return code;
};
//undefined?!?!?!?!
Blockly.Python.sensor_light_level= function(){
    return ['input.lightLevel()', Blockly.Python.ORDER_ATOMIC];
};
//ok
Blockly.Python.sensor_calibrate_compass= function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    return 'compass.calibrate()\n';
};
//ok
Blockly.Python.sensor_is_compass_calibrated= function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    return ['compass.is_calibrated()', Blockly.Python.ORDER_ATOMIC];
};
//ok
Blockly.Python.sensor_compass_heading= function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    return ['compass.heading()', Blockly.Python.ORDER_ATOMIC];
};
//ok
Blockly.Python.sensor_temperature = function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    return ['temperature()', Blockly.Python.ORDER_ATOMIC];
};
Blockly.Python.sensor_field_strength= function(){
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    Blockly.Python.definitions_['import_mpu9250_*'] = 'from mpu9250 import *';
    var compass = this.getFieldValue('compass');
    var a;
    if(compass =='strength'){
        a = 'compass.get_field_strength()';
    }
    else if(compass =='heading'){
        a = 'compass.heading()';
    }
    return [a, Blockly.Python.ORDER_ATOMIC];
};
Blockly.Python.sensor_rotation = function(){
    var key = this.getFieldValue('key')
    var code = 'input.rotation(' + key  + ')';
    return [code, Blockly.Python.ORDER_ATOMIC];
};
Blockly.Python.sensor_magnetic= function(){
    var key = this.getFieldValue('key')
    var code = 'input.magneticForce(' + key  + ')';
    return [code, Blockly.Python.ORDER_ATOMIC];
};
Blockly.Python.sensor_distance_hrsc04= function(){
    Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
    Blockly.Python.setups_['class_hrsc04'] =
    'class HCSR04:\n'+
    '    def __init__(self, tpin=pin15, epin=pin14, spin=pin13):\n'+
    '        self.trigger_pin = tpin\n'+
    '        self.echo_pin = epin\n'+
    '        self.sclk_pin = spin\n'+
    '\n'+
    '    def distance_mm(self):\n'+
    '        spi.init(baudrate=125000, sclk=self.sclk_pin,\n'+
    '                 mosi=self.trigger_pin, miso=self.echo_pin)\n'+
    '        pre = 0\n'+
    '        post = 0\n'+
    '        k = -1\n'+
    '        length = 500\n'+
    '        resp = bytearray(length)\n'+
    '        resp[0] = 0xFF\n'+
    '        spi.write_readinto(resp, resp)\n'+
    '        # find first non zero value\n'+
    '        try:\n'+
    '            i, value = next((ind, v) for ind, v in enumerate(resp) if v)\n'+
    '        except StopIteration:\n'+
    '            i = -1\n'+
    '        if i > 0:\n'+
    '            pre = bin(value).count("1")\n'+
    '            # find first non full high value afterwards\n'+
    '            try:\n'+
    '                k, value = next((ind, v)\n'+
    '                                for ind, v in enumerate(resp[i:length - 2]) if resp[i + ind + 1] == 0)\n'+
    '                post = bin(value).count("1") if k else 0\n'+
    '                k = k + i\n'+
    '            except StopIteration:\n'+
    '                i = -1\n'+
    '        dist= -1 if i < 0 else round((pre + (k - i) * 8. + post) * 8 * 0.172)\n'+
    '        return dist\n'+
    '\n'+
    'sonar=HCSR04()\n'
    return ['sonar.distance_mm()/10.0', Blockly.Python.ORDER_ATOMIC];
};

Blockly.Python.DS1307_init = function () {
  Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
  var SDA = Blockly.Python.valueToCode(this, 'SDA', Blockly.Python.ORDER_ATOMIC);
  var SCL = Blockly.Python.valueToCode(this, 'SCL', Blockly.Python.ORDER_ATOMIC);
  //var RTCName = this.getFieldValue('RTCName');
  //Blockly.Python.definitions_['include_Mixly'] = '#include "Mixly.h"';
  Blockly.Python.setups_['class_DS1307'] = Blockly.Python.CLASS_DS1307_INIT;
  //Blockly.Python.definitions_['DS1307'+RTCName] = 'DS1307 ' + RTCName + '('+SDA+','+SCL+');';
  //return 'DS1307' + '('+SDA+','+SCL+')\n';
};

Blockly.Python.RTC_get_time = function () {
  Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
  //var RTCName = this.getFieldValue('RTCName');
  var timeType =this.getFieldValue('TIME_TYPE');
  Blockly.Python.setups_['class_DS1307'] = Blockly.Python.CLASS_DS1307_INIT;
  switch (timeType) {
    case "Year":
       var code = 'ds.'+timeType+'()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Month":
       var code = 'ds.'+timeType+'()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Day":
       var code = 'ds.'+timeType+'()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Hour":
       var code = 'ds.'+timeType+'()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Minute":
       var code = 'ds.'+timeType+'()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Second":
       var code = 'ds.'+timeType+'()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Week":
       var code = 'ds.'+timeType+'()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Mix1":
       var code ='ds.Year()'+','+'ds.Month()'+','+'ds.Day()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
    case "Mix2":
       var code ='ds.Hour()'+','+'ds.Minute()'+','+'ds.Second()';
       return [code, Blockly.Python.ORDER_ASSIGNMENT];
       break;
  }

};

Blockly.Python.RTC_set_time = function () {
  Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
  //var RTCName = this.getFieldValue('RTCName');
  var hour = Blockly.Python.valueToCode(this, "hour", Blockly.Python.ORDER_ASSIGNMENT);
  var minute = Blockly.Python.valueToCode(this, "minute", Blockly.Python.ORDER_ASSIGNMENT);
  var second = Blockly.Python.valueToCode(this, "second", Blockly.Python.ORDER_ASSIGNMENT);
  Blockly.Python.setups_['class_DS1307'] = Blockly.Python.CLASS_DS1307_INIT;
  var code ='str(ds.Hour('+hour+'))+ str(ds.Minute('+minute+')) +str(ds.Second('+second+'))\n';
  return code;
};

Blockly.Python.RTC_set_date = function () {
  Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
  //var RTCName = this.getFieldValue('RTCName');
  var year = Blockly.Python.valueToCode(this, "year", Blockly.Python.ORDER_ASSIGNMENT);
  var month = Blockly.Python.valueToCode(this, "month",Blockly.Python.ORDER_ASSIGNMENT);
  var day = Blockly.Python.valueToCode(this, "day",Blockly.Python.ORDER_ASSIGNMENT);
  Blockly.Python.setups_['class_DS1307'] = Blockly.Python.CLASS_DS1307_INIT;
  var code ='str(ds.Year('+year+'))+ str(ds.Month('+month+')) +str(ds.Day('+day+'))\n';
  return code;
};

Blockly.Python.sensor_compass_reset = function(block) {
  Blockly.Python.definitions_['import_microbit_*'] = 'from microbit import *';
  return ['compass.clear_calibration()', Blockly.Python.ORDER_ATOMIC];
};

Blockly.Python.HCSR04 = function () {
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    //Blockly.Python.definitions_['import_machine_Pin'] = "from machine import Pin";
    var dropdown_pin1 = Blockly.Python.valueToCode(this, "PIN1", Blockly.Python.ORDER_ASSIGNMENT);
    var dropdown_pin2 = Blockly.Python.valueToCode(this, "PIN2", Blockly.Python.ORDER_ASSIGNMENT);
    var code = 'Sonar(' + dropdown_pin1 + ', ' + dropdown_pin2 + ').checkdist()';
    return [code, Blockly.Python.ORDER_ATOMIC];
}

Blockly.Python.dht11 = function () {
    /*Blockly.Python.definitions_['import_machine_Pin'] = "from machine import Pin";
    Blockly.Python.definitions_['import_dht'] = 'import dht';
    Blockly.Python.definitions_['import_time'] = 'import time';
    Blockly.Python.definitions_['import_machine'] ='import machine';*/
    Blockly.Python.definitions_['import_ESP32_*'] = 'from ESP32 import *';
    var sensor_type = this.getFieldValue('TYPE');
    var dropdown_pin = Blockly.Python.valueToCode(this, 'PIN', Blockly.Python.ORDER_ATOMIC);
    var what = this.getFieldValue('WHAT');
  /*  Blockly.Python.setups_['setup_dht'+dropdown_pin] ='d'+dropdown_pin+'= dht.DHT11(machine.Pin('+dropdown_pin+'))\n'
    Blockly.Python.setups_['setup_dht11'] ='_dht_time = 0\n'+
    'def measure(d):\n'+
    '    global _dht_time\n'+
    '    if(time.ticks_diff(time.ticks_ms(), _dht_time))>1000:\n'+
    '        d.measure()\n'+
    '        _dht_time = time.ticks_ms()\n'+
    'def getTemperature(d):\n'+
    '    measure(d)\n'+
    '    return d.temperature()\n'+
    'def getHumidity(d):\n'+
    '    measure(d)\n'+
    '    return d.humidity()\n'+
    'def getTempAndHum(d):\n'+
    '    measure(d)\n'+
    '    return d.temperature(),d.humidity()\n';*/
    //Blockly.Python.definitions_['var_dht_' + dropdown_pin] = 'dht myDHT_' + dropdown_pin + ';';
    var code ='get_'+what+'(Pin('+dropdown_pin+'))';
    return [code, Blockly.Python.ORDER_ATOMIC];
}