/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import cc.arduino.os.windows.Win32KnownFolders;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import processing.app.PreferencesData;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;

public class Platform
extends processing.app.Platform {
    private File settingsFolder;
    private File defaultSketchbookFolder;
    private static int detected = Platform.detectSystemDPI();

    @Override
    public void init() throws Exception {
        super.init();
        this.checkPath();
        this.recoverSettingsFolderPath();
        this.recoverDefaultSketchbookFolder();
    }

    private void recoverSettingsFolderPath() throws Exception {
        if (PreferencesData.getBoolean("runtime.is-windows-store-app")) {
            Path path = Win32KnownFolders.getDocumentsFolder().toPath();
            this.settingsFolder = path.resolve("ArduinoData").toFile();
        } else {
            Path path = Win32KnownFolders.getLocalAppDataFolder().toPath();
            this.settingsFolder = path.resolve("Arduino15").toFile();
        }
    }

    private Path recoverOldSettingsFolderPath() throws Exception {
        Path path = Win32KnownFolders.getRoamingAppDataFolder().toPath();
        return path.resolve("Arduino15");
    }

    private void recoverDefaultSketchbookFolder() throws Exception {
        Path path = Win32KnownFolders.getDocumentsFolder().toPath();
        this.defaultSketchbookFolder = path.resolve("Arduino").toFile();
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split(path, File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        for (String item : pieces) {
            File directory;
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if (!(directory = new File(item)).exists() || item.trim().length() == 0) continue;
            legit[legitCount++] = item;
        }
        String newPath = PApplet.join(legit = PApplet.subset(legit, 0, legitCount), File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() {
        return this.settingsFolder;
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return this.defaultSketchbookFolder;
    }

    @Override
    public void openURL(String url) throws Exception {
        File file;
        if (!url.startsWith("http") && !url.startsWith("file:") && (file = new File(url)).exists()) {
            url = file.toURI().toString();
        }
        if (url.startsWith("http") || url.startsWith("file:")) {
            int SW_SHOW = 5;
            Shell32.INSTANCE.ShellExecute(null, null, url, null, null, 5);
            return;
        }
        Runtime.getRuntime().exec("cmd /c \"" + url + "\"");
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        String folder = file.getAbsolutePath();
        Runtime.getRuntime().exec("explorer \"" + folder + "\"");
    }

    @Override
    public String getName() {
        return PConstants.platformNames[1];
    }

    @Override
    public void fixPrefsFilePermissions(File prefsFile) throws IOException {
    }

    @Override
    public List<File> postInstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "post_install.bat"));
        return scripts;
    }

    @Override
    public List<File> preUninstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "pre_uninstall.bat"));
        return scripts;
    }

    public void symlink(File something, File somewhere) throws IOException, InterruptedException {
    }

    @Override
    public void link(File something, File somewhere) throws IOException, InterruptedException {
    }

    @Override
    public void chmod(File file, int mode) throws IOException, InterruptedException {
    }

    @Override
    public void fixSettingsLocation() throws Exception {
        if (PreferencesData.getBoolean("runtime.is-windows-store-app")) {
            return;
        }
        Path oldSettingsFolder = this.recoverOldSettingsFolderPath();
        if (!Files.exists(oldSettingsFolder, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(oldSettingsFolder.resolve(Paths.get("preferences.txt", new String[0])), new LinkOption[0])) {
            return;
        }
        if (this.settingsFolder.exists()) {
            return;
        }
        Files.move(oldSettingsFolder, this.settingsFolder.toPath(), new CopyOption[0]);
    }

    @Override
    public int getSystemDPI() {
        if (detected == -1) {
            return super.getSystemDPI();
        }
        return detected;
    }

    public static int detectSystemDPI() {
        try {
            ExtUser32.INSTANCE.SetProcessDpiAwareness(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ExtUser32.INSTANCE.SetThreadDpiAwarenessContext(ExtUser32.DPI_AWARENESS_CONTEXT_SYSTEM_AWARE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return ExtUser32.INSTANCE.GetDpiForSystem();
        }
        catch (Throwable e) {
            System.out.println("DPI detection failed, fallback to 96 dpi");
            return -1;
        }
    }

    static interface ExtUser32
    extends StdCallLibrary,
    User32 {
        public static final ExtUser32 INSTANCE = (ExtUser32)Native.loadLibrary((String)"user32", ExtUser32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
        public static final int DPI_AWARENESS_INVALID = -1;
        public static final int DPI_AWARENESS_UNAWARE = 0;
        public static final int DPI_AWARENESS_SYSTEM_AWARE = 1;
        public static final int DPI_AWARENESS_PER_MONITOR_AWARE = 2;
        public static final Pointer DPI_AWARENESS_CONTEXT_UNAWARE = new Pointer(-1L);
        public static final Pointer DPI_AWARENESS_CONTEXT_SYSTEM_AWARE = new Pointer(-2L);
        public static final Pointer DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE = new Pointer(-3L);

        public int GetDpiForSystem();

        public int SetProcessDpiAwareness(int var1);

        public Pointer SetThreadDpiAwarenessContext(Pointer var1);
    }
}

