/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.UpdatableBoardsLibsFakeURLsHandler;
import cc.arduino.view.NotificationPopup;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;

public class NewBoardListener
implements PropertyChangeListener,
Runnable {
    private Base base;
    private Editor ed;

    public NewBoardListener(Base base) {
        this.base = base;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.checkForNewBoardAttached();
    }

    @Override
    public void run() {
        while (this.base.getActiveEditor() == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        BaseNoGui.addPropertyChangeListener((PropertyChangeListener)this);
        this.checkForNewBoardAttached();
    }

    public void checkForNewBoardAttached() {
        String newBoardManagerLink = BaseNoGui.getBoardManagerLink();
        if (newBoardManagerLink.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.ed = this.base.getActiveEditor();
            final NotificationPopup notificationPopup = new NotificationPopup((Frame)this.ed, new UpdatableBoardsLibsFakeURLsHandler(this.base), newBoardManagerLink, false);
            if (this.ed.isFocused()) {
                notificationPopup.begin();
                return;
            }
            WindowFocusListener wfl = new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent evt) {
                }

                @Override
                public void windowGainedFocus(WindowEvent evt) {
                    notificationPopup.begin();
                    for (Editor e : NewBoardListener.this.base.getEditors()) {
                        e.removeWindowFocusListener(this);
                    }
                }
            };
            for (Editor e : this.base.getEditors()) {
                e.addWindowFocusListener(wfl);
            }
        });
    }
}

