/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.mrbean.BeanBuilder;
import com.fasterxml.jackson.module.mrbean.BeanUtil;
import java.lang.reflect.Method;

public class POJOProperty {
    protected final String _name;
    protected final String _fieldName;
    protected final Class<?> _context;
    protected Method _getter;
    protected Method _setter;

    public POJOProperty(String name, Class<?> ctxt) {
        this._name = name;
        this._context = ctxt;
        this._fieldName = name;
    }

    public String getName() {
        return this._name;
    }

    public void setGetter(Method m) {
        this._getter = m;
    }

    public void setSetter(Method m) {
        this._setter = m;
    }

    public Method getGetter() {
        return this._getter;
    }

    public Method getSetter() {
        return this._setter;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public boolean hasConcreteGetter() {
        return this._getter != null && BeanUtil.isConcrete(this._getter);
    }

    public boolean hasConcreteSetter() {
        return this._setter != null && BeanUtil.isConcrete(this._setter);
    }

    private BeanBuilder.TypeDescription getterType(TypeFactory tf) {
        return new BeanBuilder.TypeDescription(tf.constructType(this._getter.getGenericReturnType(), this._context));
    }

    private BeanBuilder.TypeDescription setterType(TypeFactory tf) {
        return new BeanBuilder.TypeDescription(tf.constructType(this._setter.getGenericParameterTypes()[0], this._context));
    }

    public BeanBuilder.TypeDescription selectType(TypeFactory tf) {
        BeanBuilder.TypeDescription gt;
        if (this._getter == null) {
            return this.setterType(tf);
        }
        if (this._setter == null) {
            return this.getterType(tf);
        }
        BeanBuilder.TypeDescription st = this.setterType(tf);
        BeanBuilder.TypeDescription specificType = BeanBuilder.TypeDescription.moreSpecificType(st, gt = this.getterType(tf));
        if (specificType == null) {
            throw new IllegalArgumentException("Invalid property '" + this.getName() + "': incompatible types for getter/setter (" + gt + " vs " + st + ")");
        }
        return specificType;
    }
}

