'use strict'

goog.provide('Blockly.Blocks.ext')

goog.require('Blockly.Blocks');
goog.require('Blockly.Types');

/**
 * Common HSV hue for all blocks in this category.
 */
Blockly.Blocks.ext.HUE = 210;

Blockly.Blocks['write_eeprom'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("写入EEPROM");
    this.appendValueInput("ADDR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("地址");
    this.appendValueInput("VALUE")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("值");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#FF0000');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['read_eeprom'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("读取EEPROM");
    this.appendValueInput("ADDR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("地址");
    this.setInputsInline(true);
    this.setOutput(true, "Number");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};


Blockly.Blocks['logic_level'] = {
  init: function() {
    this.appendDummyInput()
        .appendField(new Blockly.FieldDropdown([["高电平", "HIGH"], ["低电平", "LOW"]]), "LEVEL");
    this.setOutput(true, "Number");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};