'use strict'

goog.provide('Blockly.Blocks.modules')

goog.require('Blockly.Blocks');
goog.require('Blockly.Types');


/**
 * Common HSV hue for all blocks in this category.
 */
Blockly.Blocks.modules.HUE = 210;

var _digitalPins = (function() {
    var pins = new Array();
    for (var i = 1; i != 15; ++i) {
        pins.push(["D" + i, i.toString()]);
    }

    return pins;
})();

function _media(fname) {
    return "../../data/hardware/modules/medias/" + fname;
}


Blockly.Blocks['module_set_4_digital_display'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定4位数码管（0-9999）")
        .appendField(new Blockly.FieldImage(_media("4_digital_display.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_set_chainable_rgb_led'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("设定全彩色LED灯")
        .appendField(new Blockly.FieldImage(_media("chainable_rgb_led.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.appendValueInput("RED")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("红（0-255）");
    this.appendValueInput("GREEN")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("绿（0-255）");
    this.appendValueInput("BLUE")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("蓝（0-255）");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};



Blockly.Blocks['module_read_thumb_joystick'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取手指控制杆坐标值（0-1023）")
        .appendField(new Blockly.FieldImage(_media("thumb_joystick.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(new Blockly.FieldDropdown([["X", "X"], ["Y", "Y"]]), "AXIS")
        .appendField("轴");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_speaker'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("TONE")
        .setCheck("Number")
        .appendField("设定扬声器")
        .appendField(new Blockly.FieldImage(_media("speaker.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField("音符（1~8，0停止声响）");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_button'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取按开关（0-1）")
        .appendField(new Blockly.FieldImage(_media("button.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_infrared_reciver'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取配套遥控器按键键值0-9")
        .appendField(new Blockly.FieldImage(_media("infrared_reciver.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_rotary_angle_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取旋转电位计（0-1023）")
        .appendField(new Blockly.FieldImage(_media("rotary_angle_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};


Blockly.Blocks['module_read_temperature_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取温度值")
        .appendField(new Blockly.FieldImage(_media("temperature_sensor.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};









Blockly.Blocks['module_read_temperature_and_humidity_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取温湿度传感器")
        .appendField(new Blockly.FieldImage(_media("temperature_and_humidity_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(new Blockly.FieldDropdown([["温度", 'T'], ['湿度', 'H']]), "TYPE");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};


Blockly.Blocks['module_set_servo'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("ANGLE")
        .setCheck("Number")
        .appendField("设定舵机")
        .appendField(new Blockly.FieldImage(_media("servo.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField("角度（0~180）");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_read_ultrasonic_ranger'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取超声波测距传感器")
        .appendField(new Blockly.FieldImage(_media("ultrasonic_ranger.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};


Blockly.Blocks['module_set_mini_motor_driver'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("设定迷你电机驱动板")
        .appendField(new Blockly.FieldImage(_media("mini_motor_driver.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.appendValueInput("MOTOR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设定Motor（0-左边电机,1-右边电机）");
    this.appendValueInput("ACTION")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设定速度为（-63~63");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');

    this.hardwareI2C = false;
  },

  mutationToDom: function() {
    var container = document.createElement('mutation');
    container.setAttribute('hardware_i2c', this.hardwareI2C);
    return container;
  },
  domToMutation: function(xmlElement) {
    this.hardwareI2C = xmlElement.getAttribute('hardware_i2c') == 'true';
  }
};

Blockly.Blocks['module_set_car_motor_driver'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("控制小车减速电机")
        .appendField(new Blockly.FieldImage(_media("car_motor.jpg"), 70, 70, "*"))
/*         .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2"); */
    this.appendValueInput("MOTOR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("选定电机（0-左边电机，1-右边电机）");
    this.appendValueInput("ACTION")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设置速度为（-255-255）");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');


    this.hardwareI2C = false;
  },

  mutationToDom: function() {
    var container = document.createElement('mutation');
    container.setAttribute('hardware_i2c', this.hardwareI2C);
    return container;
  },
  domToMutation: function(xmlElement) {
    this.hardwareI2C = xmlElement.getAttribute('hardware_i2c') == 'true';
  }
};


Blockly.Blocks['module_set_buzzer'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定蜂鸣器（0-关闭，1-启动）")
        .appendField(new Blockly.FieldImage(_media("buzzer.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_set_recorder'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定录音播放模块（0-关闭，1-启动）")
        .appendField(new Blockly.FieldImage(_media("recorder.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_set_relay'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定继电器（0-关闭，1-启动）")
        .appendField(new Blockly.FieldImage(_media("relay.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_read_line_finder'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取红外线接近传感器")
        .appendField(new Blockly.FieldImage(_media("line_finder.jpg"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_sunlight_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取光线值（0-1023）")
        .appendField(new Blockly.FieldImage(_media("sunlight_sensor.jpg"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_tilt_switch'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取倾斜传感器（0-1）")
        .appendField(new Blockly.FieldImage(_media("tilt_switch.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_el_driver'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定冷光条驱动（0-关闭，1-启动）")
        .appendField(new Blockly.FieldImage(_media("el_driver.jpg"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_set_lcd_reg_backlight'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("设定全彩背光LCD屏幕")
        .appendField(new Blockly.FieldImage(_media("lcd_rgb_backlight.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.appendValueInput("COLOR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设定颜色：0~5白,5~1023蓝-绿-红变化");
    this.appendValueInput("TEXT1")
        .setCheck("Text")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设定第1行");
    this.appendValueInput("TEXT2")
        .setCheck("Text")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设定第2行");

    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    mutationToDom: function() {
    var container = document.createElement('mutation');
    container.setAttribute('hardware_i2c', this.hardwareI2C);
    return container;
  },
  domToMutation: function(xmlElement) {
    this.hardwareI2C = xmlElement.getAttribute('hardware_i2c') == 'true';
  }
};


Blockly.Blocks['module_set_vibration_motor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定震动马达（0-关闭，1-启动）")
        .appendField(new Blockly.FieldImage(_media("vibration_motor.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_water_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取水分子检测传感器（0-有水，1-没水）")
        .appendField(new Blockly.FieldImage(_media("water_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_slide_potentiometer'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取滑动电位开关（0-1023）")
        .appendField(new Blockly.FieldImage(_media("slide_potentiometer.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")

    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_electromagnet'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定电磁铁模块（0-关闭，1-启动）")
        .appendField(new Blockly.FieldImage(_media("electromagnet.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_set_dc_motor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定直流电机")
        .appendField(new Blockly.FieldImage(_media("dc_motor.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_magnetic_switch'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取磁力开关（0-1）")
        .appendField(new Blockly.FieldImage(_media("magnetic_switch.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_pir_motion_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取运动检测传感器（0-1）")
        .appendField(new Blockly.FieldImage(_media("pir_motion_sensor.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_flexi_strip_led'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("设定2812灯条")
        .appendField(new Blockly.FieldImage(_media("flexi_strip_led.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.appendValueInput("ID")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("编号");
    this.appendValueInput("RED")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("红（0-255）");
    this.appendValueInput("GREEN")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("绿（0-255）");
    this.appendValueInput("BLUE")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("蓝（0-255）");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_pressure_vibration_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取压力震动传感器")
        .appendField(new Blockly.FieldImage(_media("pressure_vibration_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_loudness_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取噪声传感器（0-1023）")
        .appendField(new Blockly.FieldImage(_media("loudness_sensor.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_moisture_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取土壤湿度传感器（0-1023）")
        .appendField(new Blockly.FieldImage(_media("moisture_sensor.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_led_bar'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

        var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定柱状发光二极管")
        .appendField(new Blockly.FieldImage(_media("led_bar.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2")
        .appendField('亮灯的数量');
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_flame_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取火焰传感器")
        .appendField(new Blockly.FieldImage(_media("flame_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_cicular_led'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

        var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定环形发光二极管")
        .appendField(new Blockly.FieldImage(_media("circular_led.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2")
        .appendField('亮灯的数量');
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_collision_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取碰撞传感器")
        .appendField(new Blockly.FieldImage(_media("collision_sensor.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_red_led'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定红色LED灯珠（0-关闭，1-启动）")
        .appendField(new Blockly.FieldImage(_media("red_led.jpg"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_touch_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取触摸传感器（0-1）")
        .appendField(new Blockly.FieldImage(_media("touch_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_hall_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取霍尔电磁开关（1-有磁场，0-无磁场）")
        .appendField(new Blockly.FieldImage(_media("hall_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_3_axis_accelerometer'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("读取三轴数字加速度（0-1023）")
        .appendField(new Blockly.FieldImage(_media("3_axis_accelerometer.jpg"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2")
        .appendField(new Blockly.FieldDropdown([["X", "X"], ["Y", "Y"], ["Z", "Z"]]), "AXIS")
        .appendField("轴");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_i2c_touch_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("读取多通道触摸传感器")
        .appendField(new Blockly.FieldImage(_media("i2c_touch_sensor.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");

    this.appendValueInput("CHANNEL")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("通道（0~11）");

    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_read_gesture'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("读取手势识别传感器")
        .appendField(new Blockly.FieldImage(_media("gesture.png"), 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.setOutput(true, "Number");
    this.setColour('#4E65CF');
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};