'use strict';

goog.provide('Blockly.Arduino.modules');
goog.require('Blockly.Arduino');


Blockly.Arduino['module_set_4_digital_display'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'tm1637_' + pin.toLowerCase();


    Blockly.Arduino.addInclude('tm1637', '#include "TM1637.h"');
    Blockly.Arduino.addDeclaration(varname, 'TM1637 ' + varname + ';');

    var code = varname + '.DigitDisplayWrite(' + pin + ', ' + pin2 + ', ' + digit + ');\n';
    return code;
};


Blockly.Arduino['module_set_chainable_rgb_led'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var red = Blockly.Arduino.valueToCode(block, 'RED', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var green = Blockly.Arduino.valueToCode(block, 'GREEN', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var blue = Blockly.Arduino.valueToCode(block, 'BLUE', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'chainable_led_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('chainable_led', '#include "ChainableLED.h"');
    Blockly.Arduino.addDeclaration(varname, 'ChainableLED ' + varname + ';');

    var code = varname + '.ChainableRGBLEDWrite(' + pin + ', ' + pin2 + ', 1, ' + red + ', ' + green + ', ' + blue + ');\n';
    return code;
};


Blockly.Arduino['module_read_thumb_joystick'] = function(block) {
    var pin = block.getFieldValue('PIN');

    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = 'analogRead(' + pin + ')';

    return [code, Blockly.Arduino.ORDER_ATOMIC];
};


Blockly.Arduino['module_set_speaker'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var tone = Blockly.Arduino.valueToCode(block, 'TONE', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'speaker_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('speaker', '#include "Speaker.h"');
    Blockly.Arduino.addDeclaration(varname, 'grove_speaker_g ' + varname + ';');

    var code = varname + '.SpeakerWrite(' + pin + ', ' + tone + ');\n';
    return code;
};


Blockly.Arduino['module_read_button'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('button' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};


Blockly.Arduino['module_read_rotary_angle_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    setupCode =  'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('rotary_angle_sensor' + pin, setupCode, true);

    var code = 'analogRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};


Blockly.Arduino['module_read_temperature_and_humidity_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var type = block.getFieldValue('TYPE');
    var varname = 'dht_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('dht', '#include "SeeedDHT.h"');
    Blockly.Arduino.addDeclaration(varname, 'DHT ' + varname + ';');

    var setupCode = 'Serial.begin(115200);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = null;
    code = varname + '.TemperatureHumidityRead(' + pin + ", '" + type + "')";

    return [code, Blockly.Arduino.ORDER_ATOMIC];
};


Blockly.Arduino['module_set_servo'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var angle = Blockly.Arduino.valueToCode(block, 'ANGLE', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'servo_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('servo', '#include "Servo.h"');
    Blockly.Arduino.addDeclaration(varname, 'Servo ' + varname + ';');

    var setupCode = varname + '.attach(' + pin + ');';
    Blockly.Arduino.addSetup(varname, setupCode, true);

    var code = varname + '.write(' + angle + ');\n';

    return code;
};


Blockly.Arduino['module_read_ultrasonic_ranger'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var varname = 'ultrasonic_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('ultrasonic', '#include "Ultrasonic.h"');
    Blockly.Arduino.addDeclaration(varname, 'Ultrasonic ' + varname + ';');

    var setupCode = 'Serial.begin(115200);';
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = varname + '.UltrasonicRangerRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_set_mini_motor_driver'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var motor = Blockly.Arduino.valueToCode(block, 'MOTOR', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var action = Blockly.Arduino.valueToCode(block, 'ACTION', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = "miniI2CMotorDriver_" + pin.toLowerCase();
    
    Blockly.Arduino.addInclude('miniI2CMotorDriver', '#include "Seeed_MiniI2CMotorDriver.h"');

    if (block.hardwareI2C) {
        Blockly.Arduino.addDeclaration(varname, 'MiniI2CMotorDriver ' + varname + ';');
    } else {
        Blockly.Arduino.addDeclaration(varname, 'MiniI2CMotorDriver ' + varname + '(' + pin + ', ' + pin2 + ');');
    }
    
    var setupCode = 'Serial.begin(115200);';
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = varname + '.Driver(' + motor + ', ' + action + ');\n';
    return code;
};

Blockly.Arduino['module_set_buzzer'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('buzzer' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};
