'use strict'

goog.provide('Blockly.Blocks.modules')

goog.require('Blockly.Blocks');
goog.require('Blockly.Types');


/**
 * Common HSV hue for all blocks in this category.
 */
Blockly.Blocks.modules.HUE = 210;

var _digitalPins = (function() {
    var pins = new Array();
    for (var i = 1; i != 15; ++i) {
        pins.push(["D" + i, i.toString()]);
    }

    return pins;
})();


Blockly.Blocks['module_set_4_digital_display'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定4位数码管")
        .appendField(new Blockly.FieldImage("medias/4_digital_display.png", 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_set_chainable_rgb_led'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("设定全彩色LED灯")
        .appendField(new Blockly.FieldImage("medias/chainable_rgb_led.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.appendValueInput("RED")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("红");
    this.appendValueInput("GREEN")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("绿");
    this.appendValueInput("BLUE")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("蓝");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_thumb_joystick'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取手指控制杆坐标值")
        .appendField(new Blockly.FieldImage("medias/thumb_joystick.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(new Blockly.FieldDropdown([["X", "X"], ["Y", "Y"]]), "AXIS")
        .appendField("轴");
    this.setOutput(true, "Number");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
  getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['module_set_speaker'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("TONE")
        .setCheck("Number")
        .appendField("设定扬声器")
        .appendField(new Blockly.FieldImage("medias/speaker.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField("音符（1~8，0停止声响）");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_read_button'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取按钮开关")
        .appendField(new Blockly.FieldImage("medias/button.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Boolean");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.BOOLEAN;
  }
};

Blockly.Blocks['module_read_rotary_angle_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取旋转电位计")
        .appendField(new Blockly.FieldImage("medias/rotary_angle_sensor.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }, 
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};


Blockly.Blocks['module_read_temperature_and_humidity_sensor'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown([["A0", "A0"], ["A1", "A1"], ["A2", "A2"]]);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取温湿度传感器")
        .appendField(new Blockly.FieldImage("medias/temperature_and_humidity_sensor.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(new Blockly.FieldDropdown([["温度", 'T'], ['湿度', 'H']]), "TYPE");
    this.setOutput(true, "Number");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};


Blockly.Blocks['module_set_servo'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("ANGLE")
        .setCheck("Number")
        .appendField("设定舵机")
        .appendField(new Blockly.FieldImage("medias/servo.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField("角度（0~180）");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_read_ultrasonic_ranger'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取超声波测距传感器")
        .appendField(new Blockly.FieldImage("medias/ultrasonic_ranger.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};


Blockly.Blocks['module_set_mini_motor_driver'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    var pin2Field = new Blockly.FieldDropdown(_digitalPins);
    pin2Field.showEditor_ = function() {}
    pin2Field.setVisible(false);

    this.appendDummyInput()
        .appendField("设定迷你电机驱动板")
        .appendField(new Blockly.FieldImage("medias/mini_motor_driver.png", 70, 70, "*"))
        .appendField("PIN#")
        .appendField(pinField, "PIN")
        .appendField(pin2Field, "PIN2");
    this.appendValueInput("MOTOR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设定Motor");
    this.appendValueInput("ACTION")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("设定动作为");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');

    this.hardwareI2C = false;
  },

  mutationToDom: function() {
    var container = document.createElement('mutation');
    container.setAttribute('hardware_i2c', this.hardwareI2C);
    return container;
  },
  domToMutation: function(xmlElement) {
    this.hardwareI2C = xmlElement.getAttribute('hardware_i2c') == 'true';
  }
};


Blockly.Blocks['module_set_buzzer'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定蜂鸣器")
        .appendField(new Blockly.FieldImage("medias/buzzer.png", 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['module_set_recorder'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定录音播放模块")
        .appendField(new Blockly.FieldImage(_media("recorder.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_set_relay'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendValueInput("DIGIT")
        .setCheck("Number")
        .appendField("设定继电器")
        .appendField(new Blockly.FieldImage(_media("relay.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
        
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};


Blockly.Blocks['module_read_line_finder'] = {
  init: function() {
    var pinField = new Blockly.FieldDropdown(_digitalPins);
    pinField.showEditor_ = function() {}

    this.appendDummyInput()
        .appendField("读取红外线接近传感器")
        .appendField(new Blockly.FieldImage(_media("line_finder.png"), 70, 70, "name"))
        .appendField("PIN#")
        .appendField(pinField, "PIN");
    this.setOutput(true, "Number");
    this.setColour(210);
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};