// Do not edit this file; automatically generated by build.py.
'use strict';

/*
 Licensed under the Apache License, Version 2.0 (the "License"):
          http://www.apache.org/licenses/LICENSE-2.0
*/
Blockly.Arduino=new Blockly.Generator("Arduino");Blockly.Arduino.StaticTyping=new Blockly.StaticTyping;Blockly.Arduino.addReservedWords("Blockly,setup,loop,if,else,for,switch,case,while,do,break,continue,return,goto,define,include,HIGH,LOW,INPUT,OUTPUT,INPUT_PULLUP,true,false,integer,constants,floating,point,void,boolean,char,unsigned,byte,int,word,long,float,double,string,String,array,static,volatile,const,sizeof,pinMode,digitalWrite,digitalRead,analogReference,analogRead,analogWrite,tone,noTone,shiftOut,shitIn,pulseIn,millis,micros,delay,delayMicroseconds,min,max,abs,constrain,map,pow,sqrt,sin,cos,tan,randomSeed,random,lowByte,highByte,bitRead,bitWrite,bitSet,bitClear,bit,attachInterrupt,detachInterrupt,interrupts,noInterrupts");
Blockly.Arduino.ORDER_ATOMIC=0;Blockly.Arduino.ORDER_UNARY_POSTFIX=1;Blockly.Arduino.ORDER_UNARY_PREFIX=2;Blockly.Arduino.ORDER_MULTIPLICATIVE=3;Blockly.Arduino.ORDER_ADDITIVE=4;Blockly.Arduino.ORDER_SHIFT=5;Blockly.Arduino.ORDER_RELATIONAL=6;Blockly.Arduino.ORDER_EQUALITY=7;Blockly.Arduino.ORDER_BITWISE_AND=8;Blockly.Arduino.ORDER_BITWISE_XOR=9;Blockly.Arduino.ORDER_BITWISE_OR=10;Blockly.Arduino.ORDER_LOGICAL_AND=11;Blockly.Arduino.ORDER_LOGICAL_OR=12;Blockly.Arduino.ORDER_CONDITIONAL=13;
Blockly.Arduino.ORDER_ASSIGNMENT=14;Blockly.Arduino.ORDER_NONE=99;Blockly.Arduino.PinTypes={INPUT:"INPUT",OUTPUT:"OUTPUT",PWM:"PWM",SERVO:"SERVO",STEPPER:"STEPPER",SERIAL:"SERIAL",I2C:"I2C/TWI",SPI:"SPI"};Blockly.Arduino.DEF_FUNC_NAME=Blockly.Arduino.FUNCTION_NAME_PLACEHOLDER_;
Blockly.Arduino.init=function(a){Blockly.Arduino.includes_=Object.create(null);Blockly.Arduino.definitions_=Object.create(null);Blockly.Arduino.variables_=Object.create(null);Blockly.Arduino.codeFunctions_=Object.create(null);Blockly.Arduino.userFunctions_=Object.create(null);Blockly.Arduino.functionNames_=Object.create(null);Blockly.Arduino.setups_=Object.create(null);Blockly.Arduino.pins_=Object.create(null);Blockly.Arduino.variableDB_?Blockly.Arduino.variableDB_.reset():Blockly.Arduino.variableDB_=
new Blockly.Names(Blockly.Arduino.RESERVED_WORDS_);var b=Blockly.Arduino.StaticTyping.collectVarsWithTypes(a);Blockly.Arduino.StaticTyping.setProcedureArgs(a,b);for(var c in b)a=Blockly.Arduino.variableDB_.getName(c,Blockly.Variables.NAME_TYPE),Blockly.Arduino.addVariable(c,Blockly.Arduino.getArduinoType_(b[c])+" "+a+";")};
Blockly.Arduino.finish=function(a){var b=[],c=[],d=[],e=[],f;for(f in Blockly.Arduino.includes_)b.push(Blockly.Arduino.includes_[f]);b.length&&b.push("\n");for(f in Blockly.Arduino.variables_)d.push(Blockly.Arduino.variables_[f]);d.length&&d.push("\n");for(f in Blockly.Arduino.definitions_)c.push(Blockly.Arduino.definitions_[f]);c.length&&c.push("\n");for(f in Blockly.Arduino.codeFunctions_)e.push(Blockly.Arduino.codeFunctions_[f]);for(f in Blockly.Arduino.userFunctions_)e.push(Blockly.Arduino.userFunctions_[f]);
e.length&&e.push("\n");var g=[""],h="";void 0!==Blockly.Arduino.setups_.userSetupCode&&(h="\n"+Blockly.Arduino.setups_.userSetupCode,delete Blockly.Arduino.setups_.userSetupCode);for(f in Blockly.Arduino.setups_)g.push(Blockly.Arduino.setups_[f]);h&&g.push(h);delete Blockly.Arduino.includes_;delete Blockly.Arduino.definitions_;delete Blockly.Arduino.codeFunctions_;delete Blockly.Arduino.userFunctions_;delete Blockly.Arduino.functionNames_;delete Blockly.Arduino.setups_;delete Blockly.Arduino.pins_;
Blockly.Arduino.variableDB_.reset();b=b.join("\n")+d.join("\n")+c.join("\n")+e.join("\n\n");g="void setup() {"+g.join("\n  ")+"\n}\n\n";a="void loop() {\n  "+a.replace(/\n/g,"\n  ")+"\n}";return b+g+a};Blockly.Arduino.addInclude=function(a,b){void 0===Blockly.Arduino.includes_[a]&&(Blockly.Arduino.includes_[a]=b)};Blockly.Arduino.addDeclaration=function(a,b){void 0===Blockly.Arduino.definitions_[a]&&(Blockly.Arduino.definitions_[a]=b)};
Blockly.Arduino.addVariable=function(a,b,c){var d=!1;if(c||void 0===Blockly.Arduino.variables_[a])Blockly.Arduino.variables_[a]=b,d=!0;return d};Blockly.Arduino.addSetup=function(a,b,c){var d=!1;if(c||void 0===Blockly.Arduino.setups_[a])Blockly.Arduino.setups_[a]=b,d=!0;return d};
Blockly.Arduino.addFunction=function(a,b){if(void 0===Blockly.Arduino.codeFunctions_[a]){var c=Blockly.Arduino.variableDB_.getDistinctName(a,Blockly.Generator.NAME_TYPE);Blockly.Arduino.codeFunctions_[a]=b.replace(Blockly.Arduino.DEF_FUNC_NAME,c);Blockly.Arduino.functionNames_[a]=c}return Blockly.Arduino.functionNames_[a]};
Blockly.Arduino.reservePin=function(a,b,c,d){void 0!==Blockly.Arduino.pins_[b]?Blockly.Arduino.pins_[b]!=c?a.setWarningText(Blockly.Msg.ARD_PIN_WARN1.replace("%1",b).replace("%2",d).replace("%3",c).replace("%4",Blockly.Arduino.pins_[b]),d):a.setWarningText(null,d):(Blockly.Arduino.pins_[b]=c,a.setWarningText(null,d))};Blockly.Arduino.scrubNakedValue=function(a){return a+";\n"};
Blockly.Arduino.quote_=function(a){a=a.replace(/\\/g,"\\\\").replace(/\n/g,"\\\n").replace(/\$/g,"\\$").replace(/'/g,"\\'");return'"'+a+'"'};
Blockly.Arduino.scrub_=function(a,b){if(null===b)return"";var c="";if(!a.outputConnection||!a.outputConnection.targetConnection){var d=a.getCommentText();d&&(c+=this.prefixLines(d,"// ")+"\n");for(var e=0;e<a.inputList.length;e++)a.inputList[e].type==Blockly.INPUT_VALUE&&(d=a.inputList[e].connection.targetBlock())&&(d=this.allNestedComments(d))&&(c+=this.prefixLines(d,"// "))}e=a.nextConnection&&a.nextConnection.targetBlock();e=this.blockToCode(e);return c+b+e};
Blockly.Arduino.getArduinoType_=function(a){switch(a.typeId){case Blockly.Types.SHORT_NUMBER.typeId:return"char";case Blockly.Types.NUMBER.typeId:return"int";case Blockly.Types.LARGE_NUMBER.typeId:return"long";case Blockly.Types.DECIMAL.typeId:return"float";case Blockly.Types.TEXT.typeId:return"String";case Blockly.Types.CHARACTER.typeId:return"char";case Blockly.Types.BOOLEAN.typeId:return"boolean";case Blockly.Types.NULL.typeId:return"void";case Blockly.Types.UNDEF.typeId:return"undefined";case Blockly.Types.CHILD_BLOCK_MISSING.typeId:return"int";
default:return"Invalid Blockly Type"}};Blockly.Arduino.noGeneratorCodeInline=function(){return["",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.noGeneratorCodeLine=function(){return""};Blockly.Arduino.Boards={};Blockly.Arduino.Boards.generateDigitalIo=function(a,b){for(var c=[],d=a;d<b+1;d++)c.push([d.toString(),d.toString()]);return c};Blockly.Arduino.Boards.generateAnalogIo=function(a,b){for(var c=[],d=a;d<b+1;d++)c.push(["A"+d.toString(),"A"+d.toString()]);return c};
Blockly.Arduino.Boards.duplicateBoardProfile=function(a,b,c,d){return{name:b,description:c||a.description,compilerFlag:d||a.compilerFlag,analogPins:a.analogPins,digitalPins:a.digitalPins,pwmPins:a.pwmPins,serial:a.serial,serialPins:a.serialPins,serialSpeed:a.serialSpeed,spi:a.spi,spiPins:a.spiPins,spiClockDivide:a.spiClockDivide,i2c:a.i2c,i2cPins:a.i2cPins,i2cSpeed:a.i2cSpeed,builtinLed:a.builtinLed,interrupt:a.interrupt}};Blockly.Arduino.Boards.profiles={};
Blockly.Arduino.Boards.profiles.uno={name:"Arduino Uno",description:"Arduino Uno standard compatible board",compilerFlag:"arduino:avr:uno",analogPins:Blockly.Arduino.Boards.generateAnalogIo(0,5),digitalPins:Blockly.Arduino.Boards.generateDigitalIo(0,13).concat(Blockly.Arduino.Boards.generateAnalogIo(0,5)),pwmPins:[["3","3"],["5","5"],["6","6"],["9","9"],["10","10"],["11","11"]],serial:[["serial","Serial"]],serialPins:{Serial:[["RX","0"],["TX","1"]]},serialSpeed:[["300","300"],["600","600"],["1200",
"1200"],["2400","2400"],["4800","4800"],["9600","9600"],["14400","14400"],["19200","19200"],["28800","28800"],["31250","31250"],["38400","38400"],["57600","57600"],["115200","115200"]],spi:[["SPI","SPI"]],spiPins:{SPI:[["MOSI","11"],["MISO","12"],["SCK","13"]]},spiClockDivide:[["2 (8MHz)","SPI_CLOCK_DIV2"],["4 (4MHz)","SPI_CLOCK_DIV4"],["8 (2MHz)","SPI_CLOCK_DIV8"],["16 (1MHz)","SPI_CLOCK_DIV16"],["32 (500KHz)","SPI_CLOCK_DIV32"],["64 (250KHz)","SPI_CLOCK_DIV64"],["128 (125KHz)","SPI_CLOCK_DIV128"]],
i2c:[["I2C","Wire"]],i2cPins:{Wire:[["SDA","A4"],["SCL","A5"]]},i2cSpeed:[["100kHz","100000L"],["400kHz","400000L"]],builtinLed:[["BUILTIN_1","13"]],interrupt:[["interrupt0","2"],["interrupt1","3"]]};
Blockly.Arduino.Boards.profiles.nano={name:"Arduino Nano",description:"Arduino Nano with ATmega328p board",compilerFlag:"arduino:avr:nano",analogPins:Blockly.Arduino.Boards.generateAnalogIo(0,7),digitalPins:Blockly.Arduino.Boards.generateDigitalIo(0,13).concat(Blockly.Arduino.Boards.generateAnalogIo(0,7)),pwmPins:Blockly.Arduino.Boards.profiles.uno.pwmPins,serial:Blockly.Arduino.Boards.profiles.uno.serial,serialPins:Blockly.Arduino.Boards.profiles.uno.serialPins,serialSpeed:Blockly.Arduino.Boards.profiles.uno.serialSpeed,
spi:Blockly.Arduino.Boards.profiles.uno.spi,spiPins:Blockly.Arduino.Boards.profiles.uno.spiPins,spiClockDivide:Blockly.Arduino.Boards.profiles.uno.spiClockDivide,i2c:Blockly.Arduino.Boards.profiles.uno.i2c,i2cPins:Blockly.Arduino.Boards.profiles.uno.i2cPins,i2cSpeed:Blockly.Arduino.Boards.profiles.uno.i2cSpeed,builtinLed:Blockly.Arduino.Boards.profiles.uno.builtinLed,interrupt:Blockly.Arduino.Boards.profiles.uno.interrupt};
Blockly.Arduino.Boards.profiles.duemilanove_168p={name:"Arduino Duemilanove 168p",description:"Arduino Duemilanove with ATmega168p compatible board",compilerFlag:"arduino:avr:diecimila:cpu=atmega168",analogPins:Blockly.Arduino.Boards.profiles.uno.analogPins,digitalPins:Blockly.Arduino.Boards.profiles.uno.digitalPins,pwmPins:Blockly.Arduino.Boards.profiles.uno.pwmPins,serial:Blockly.Arduino.Boards.profiles.uno.serial,serialPins:Blockly.Arduino.Boards.profiles.uno.serialPins,serialSpeed:Blockly.Arduino.Boards.profiles.uno.serialSpeed,
spi:Blockly.Arduino.Boards.profiles.uno.spi,spiPins:Blockly.Arduino.Boards.profiles.uno.spiPins,spiClockDivide:Blockly.Arduino.Boards.profiles.uno.spiClockDivide,i2c:Blockly.Arduino.Boards.profiles.uno.i2c,i2cPins:Blockly.Arduino.Boards.profiles.uno.i2cPins,i2cSpeed:Blockly.Arduino.Boards.profiles.uno.i2cSpeed,builtinLed:Blockly.Arduino.Boards.profiles.uno.builtinLed,interrupt:Blockly.Arduino.Boards.profiles.uno.interrupt};
Blockly.Arduino.Boards.profiles.duemilanove_328p=Blockly.Arduino.Boards.duplicateBoardProfile(Blockly.Arduino.Boards.profiles.duemilanove_168p,"Arduino Duemilanove 328p","Arduino Duemilanove with ATmega328p compatible board","arduino:avr:diecimila");
Blockly.Arduino.Boards.profiles.mega={name:"Arduino Mega",description:"Arduino Mega-compatible board",compilerFlag:"arduino:avr:mega",analogPins:Blockly.Arduino.Boards.generateAnalogIo(0,15),digitalPins:Blockly.Arduino.Boards.generateDigitalIo(0,53),pwmPins:Blockly.Arduino.Boards.generateDigitalIo(2,13).concat(Blockly.Arduino.Boards.generateDigitalIo(44,46)),serial:[["serial","Serial"],["serial_1","Serial1"],["serial_2","Serial2"],["serial_3","Serial3"]],serialPins:{Serial:[["TX","0"],["RX","1"]],
Serial1:[["TX","18"],["TX","19"]],Serial2:[["TX","16"],["TX","17"]],Serial3:[["TX","14"],["TX","15"]]},serialSpeed:Blockly.Arduino.Boards.profiles.uno.serialSpeed,spi:[["SPI","SPI"]],spiPins:{SPI:[["MOSI","51"],["MISO","50"],["SCK","52"]]},spiClockDivide:Blockly.Arduino.Boards.profiles.uno.spiClockDivide,i2c:[["I2C","Wire"]],i2cPins:{Wire:[["SDA","20"],["SCL","21"]]},i2cSpeed:[["100kHz","100000L"],["400kHz","400000L"]],builtinLed:Blockly.Arduino.Boards.profiles.uno.builtinLed,interrupt:[["interrupt0",
"2"],["interrupt1","3"],["interrupt2","21"],["interrupt3","20"],["interrupt4","19"],["interrupt5","18"]]};
Blockly.Arduino.Boards.profiles.leonardo={name:"Arduino Leonardo",description:"Arduino Leonardo-compatible board",compilerFlag:"arduino:avr:leonardo",analogPins:Blockly.Arduino.Boards.generateAnalogIo(0,5).concat([["A6","4"],["A7","6"],["A8","8"],["A9","9"],["A10","10"],["A11","12"]]),digitalPins:Blockly.Arduino.Boards.generateDigitalIo(0,13).concat(Blockly.Arduino.Boards.generateAnalogIo(0,5)),pwmPins:Blockly.Arduino.Boards.profiles.uno.pwmPins.concat([["13","13"]]),serial:Blockly.Arduino.Boards.profiles.uno.serial,
serialPins:Blockly.Arduino.Boards.profiles.uno.serialPins,serialSpeed:Blockly.Arduino.Boards.profiles.uno.serialSpeed,spi:[["SPI","SPI"]],spiPins:{SPI:[["MOSI","ICSP-4"],["MISO","ICSP-1"],["SCK","ICSP-3"]]},spiClockDivide:Blockly.Arduino.Boards.profiles.uno.spiClockDivide,i2c:[["I2C","Wire"]],i2cPins:{Wire:[["SDA","2"],["SCL","3"]]},i2cSpeed:Blockly.Arduino.Boards.profiles.uno.i2cSpeed,builtinLed:Blockly.Arduino.Boards.profiles.uno.builtinLed,interrupt:[["interrupt0","3"],["interrupt1","2"],["interrupt2",
"0"],["interrupt3","1"],["interrupt4","17"]]};Blockly.Arduino.Boards.profiles.yun=Blockly.Arduino.Boards.duplicateBoardProfile(Blockly.Arduino.Boards.profiles.leonardo,"Arduino Yun","Arduino Yun compatible board");
Blockly.Arduino.Boards.profiles.atmel_atmega328p_xplained_mini={name:"Atmel atmega328p Xplained mini",description:"Atmel Xplained mini board with atmega328p (Uno compatible)",compilerFlag:"atmel:avr:atmega328p_xplained_mini",analogPins:Blockly.Arduino.Boards.profiles.uno.analogPins,digitalPins:Blockly.Arduino.Boards.profiles.uno.digitalPins.concat([["20","20"]]),pwmPins:Blockly.Arduino.Boards.profiles.uno.pwmPins,serial:Blockly.Arduino.Boards.profiles.uno.serial,serialPins:Blockly.Arduino.Boards.profiles.uno.serialPins,
serialSpeed:Blockly.Arduino.Boards.profiles.uno.serialSpeed,spi:Blockly.Arduino.Boards.profiles.uno.spi,spiPins:Blockly.Arduino.Boards.profiles.uno.spiPins,spiClockDivide:Blockly.Arduino.Boards.profiles.uno.spiClockDivide,i2c:Blockly.Arduino.Boards.profiles.uno.i2c,i2cPins:Blockly.Arduino.Boards.profiles.uno.i2cPins,i2cSpeed:Blockly.Arduino.Boards.profiles.uno.i2cSpeed,builtinLed:[["BUILTIN_LED","13"]],interrupt:Blockly.Arduino.Boards.profiles.uno.interrupt,builtinButton:[["BUILTIN_BUTTON","20"]]};
Blockly.Arduino.Boards.profiles.atmel_atmega328pb_xplained_mini=Blockly.Arduino.Boards.duplicateBoardProfile(Blockly.Arduino.Boards.profiles.atmel_atmega328p_xplained_mini,"Atmel atmega328pb Xplained mini","Atmel Xplained mini board with atmega328pb (Arduino Uno compatible)","atmel:avr:atmega328pb_xplained_mini");
Blockly.Arduino.Boards.profiles.atmel_atmega168pb_xplained_mini=Blockly.Arduino.Boards.duplicateBoardProfile(Blockly.Arduino.Boards.profiles.atmel_atmega328p_xplained_mini,"Atmel atmega168pb Xplained mini","Atmel Xplained mini board with atmega168pb (Arduino Uno compatible)","atmel:avr:atmega168pb_xplained_mini");
Blockly.Arduino.Boards.profiles.esp8266_huzzah={name:"Adafruit Feather HUZZAH",description:"Adafruit HUZZAH ESP8266 compatible board",compilerFlag:"esp8266:esp8266:generic",analogPins:[["A0","A0"]],digitalPins:[["0","0"],["2","2"],["4","4"],["5","5"],["12","12"],["13","13"],["14","14"],["15","15"],["16","16"]],pwmPins:[["2","2"]],serial:[["serial","Serial"]],serialPins:{Serial:[["RX","RX"],["TX","TX"]]},serialSpeed:Blockly.Arduino.Boards.profiles.uno.serial,spi:[["SPI","SPI"]],spiPins:{SPI:[["MOSI",
"13"],["MISO","12"],["SCK","14"]]},spiClockDivide:Blockly.Arduino.Boards.profiles.uno.spiClockDivide,i2c:[["I2C","Wire"]],i2cPins:{Wire:[["SDA","4"],["SCL","5"]]},i2cSpeed:Blockly.Arduino.Boards.profiles.uno.i2cSpeed,builtinLed:[["BUILTIN_1","0"]],interrupt:[["interrupt0","2"],["interrupt1","3"]]};
Blockly.Arduino.Boards.profiles.esp8266_wemos_d1={name:"Wemos D1",description:"Wemos D1 R2 compatible board",compilerFlag:"esp8266:esp8266:generic",analogPins:[["A0","A0"]],digitalPins:[["D0","D0"],["D1","D1"],["D2","D2"],["D3","D3"],["D4","D4"],["D5","D5"],["D6","D7"],["D8","D8"]],pwmPins:[["D1","D1"],["D2","D2"],["D3","D3"],["D4","D4"],["D5","D5"],["D6","D7"],["D8","D8"]],serial:[["serial","Serial"]],serialPins:{Serial:[["RX","RX"],["TX","TX"]]},serialSpeed:Blockly.Arduino.Boards.profiles.uno.serialSpeed,
spi:[["SPI","SPI"]],spiPins:{SPI:[["MOSI","D7"],["MISO","D6"],["SCK","D5"]]},spiClockDivide:Blockly.Arduino.Boards.profiles.uno.spiClockDivide,i2c:[["I2C","Wire"]],i2cPins:{Wire:[["SDA","D2"],["SCL","D1"]]},i2cSpeed:Blockly.Arduino.Boards.profiles.uno.i2cSpeed,builtinLed:[["BUILTIN_1","D4"]],interrupt:[["D0","D0"],["D1","D1"],["D2","D2"],["D3","D3"],["D4","D4"],["D5","D5"],["D6","D7"],["D8","D8"]]};Blockly.Arduino.Boards.selected=Blockly.Arduino.Boards.profiles.uno;
Blockly.Arduino.Boards.changeBoard=function(a,b){if(void 0===Blockly.Arduino.Boards.profiles[b])console.log("Tried to set non-existing Arduino board: "+b);else{Blockly.Arduino.Boards.selected=Blockly.Arduino.Boards.profiles[b];for(var c=a.getAllBlocks(),d=0;d<c.length;d++){var e=c[d].updateFields;e&&e.call(c[d])}}};
Blockly.Arduino.Boards.refreshBlockFieldDropdown=function(a,b,c){var d=a.getField(b);b=d.getValue();c=Blockly.Arduino.Boards.selected[c];d.menuGenerator_=c;for(var d=!1,e=0;e<c.length;e++)b==c[e][1]&&(d=!0);d?a.setWarningText(null,"bPin"):a.setWarningText("The old pin value "+b+" is no longer available.","bPin")};Blockly.Arduino.colour={};Blockly.Arduino.colour_picker=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.colour_random=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.colour_rgb=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.colour_blend=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.IO={};Blockly.Arduino.io_digitalwrite=function(a){var b=a.getFieldValue("PIN"),c=Blockly.Arduino.valueToCode(a,"STATE",Blockly.Arduino.ORDER_ATOMIC)||"LOW";Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Digital Write");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);",!1);return"digitalWrite("+b+", "+c+");\n"};
Blockly.Arduino.io_digitalread=function(a){var b=a.getFieldValue("PIN");Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.INPUT,"Digital Read");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", INPUT);",!1);return["digitalRead("+b+")",Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.io_builtin_led=function(a){var b=a.getFieldValue("BUILT_IN_LED"),c=Blockly.Arduino.valueToCode(a,"STATE",Blockly.Arduino.ORDER_ATOMIC)||"LOW";Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Set LED");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);",!1);return"digitalWrite("+b+", "+c+");\n"};
Blockly.Arduino.io_analogwrite=function(a){var b=a.getFieldValue("PIN"),c=Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Analogue Write");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);",!1);0>c||255<c?a.setWarningText("The analogue value set must be between 0 and 255","pwm_value"):a.setWarningText(null,"pwm_value");return"analogWrite("+b+", "+c+");\n"};
Blockly.Arduino.io_analogread=function(a){var b=a.getFieldValue("PIN");Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.INPUT,"Analogue Read");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", INPUT);",!1);return["analogRead("+b+")",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.io_highlow=function(a){return[a.getFieldValue("STATE"),Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.io_pulsein=function(a){var b=a.getFieldValue("PULSEPIN"),c=Blockly.Arduino.valueToCode(a,"PULSETYPE",Blockly.Arduino.ORDER_ATOMIC);Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.INPUT,"Pulse Pin");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", INPUT);\n",!1);return["pulseIn("+b+", "+c+")",Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.io_pulsetimeout=function(a){var b=a.getFieldValue("PULSEPIN"),c=Blockly.Arduino.valueToCode(a,"PULSETYPE",Blockly.Arduino.ORDER_ATOMIC),d=Blockly.Arduino.valueToCode(a,"TIMEOUT",Blockly.Arduino.ORDER_ATOMIC);Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.INPUT,"Pulse Pin");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", INPUT);\n",!1);return["pulseIn("+b+", "+c+", "+d+")",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.lists={};Blockly.Arduino.lists_create_empty=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_create_with=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_repeat=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_length=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_isEmpty=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_indexOf=Blockly.Arduino.noGeneratorCodeInline;Blockly.Arduino.lists_getIndex=Blockly.Arduino.noGeneratorCodeInline;
Blockly.Arduino.lists_setIndex=Blockly.Arduino.noGeneratorCodeLine;Blockly.Arduino.logic={};Blockly.Arduino.controls_if=function(a){for(var b=0,c=Blockly.Arduino.valueToCode(a,"IF"+b,Blockly.Arduino.ORDER_NONE)||"false",d=Blockly.Arduino.statementToCode(a,"DO"+b),e="if ("+c+") {\n"+d+"}",b=1;b<=a.elseifCount_;b++)c=Blockly.Arduino.valueToCode(a,"IF"+b,Blockly.Arduino.ORDER_NONE)||"false",d=Blockly.Arduino.statementToCode(a,"DO"+b),e+=" else if ("+c+") {\n"+d+"}";a.elseCount_&&(d=Blockly.Arduino.statementToCode(a,"ELSE"),e+=" else {\n"+d+"}");return e+"\n"};
Blockly.Arduino.logic_compare=function(a){var b={EQ:"==",NEQ:"!=",LT:"<",LTE:"<=",GT:">",GTE:">="}[a.getFieldValue("OP")],c="=="==b||"!="==b?Blockly.Arduino.ORDER_EQUALITY:Blockly.Arduino.ORDER_RELATIONAL,d=Blockly.Arduino.valueToCode(a,"A",c)||"0";a=Blockly.Arduino.valueToCode(a,"B",c)||"0";return[d+" "+b+" "+a,c]};
Blockly.Arduino.logic_operation=function(a){var b="AND"==a.getFieldValue("OP")?"&&":"||",c="&&"==b?Blockly.Arduino.ORDER_LOGICAL_AND:Blockly.Arduino.ORDER_LOGICAL_OR,d=Blockly.Arduino.valueToCode(a,"A",c)||"false";a=Blockly.Arduino.valueToCode(a,"B",c)||"false";if(d||a){var e="&&"==b?"true":"false";d||(d=e);a||(a=e)}else a=d="false";return[d+" "+b+" "+a,c]};
Blockly.Arduino.logic_negate=function(a){var b=Blockly.Arduino.ORDER_UNARY_PREFIX;return["!"+(Blockly.Arduino.valueToCode(a,"BOOL",b)||"false"),b]};Blockly.Arduino.logic_boolean=function(a){return["TRUE"==a.getFieldValue("BOOL")?"true":"false",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.logic_null=function(a){return["NULL",Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.logic_ternary=function(a){var b=Blockly.Arduino.valueToCode(a,"IF",Blockly.Arduino.ORDER_CONDITIONAL)||"false",c=Blockly.Arduino.valueToCode(a,"THEN",Blockly.Arduino.ORDER_CONDITIONAL)||"null";a=Blockly.Arduino.valueToCode(a,"ELSE",Blockly.Arduino.ORDER_CONDITIONAL)||"null";return[b+" ? "+c+" : "+a,Blockly.Arduino.ORDER_CONDITIONAL]};Blockly.Arduino.loops={};Blockly.Arduino.controls_repeat=function(a){var b=Number(a.getFieldValue("TIMES")),c=Blockly.Arduino.statementToCode(a,"DO"),c=Blockly.Arduino.addLoopTrap(c,a.id);a=Blockly.Arduino.variableDB_.getDistinctName("count",Blockly.Variables.NAME_TYPE);return"for (int "+a+" = 0; "+a+" < "+b+"; "+a+"++) {\n"+c+"}\n"};
Blockly.Arduino.controls_repeat_ext=function(a){var b=Blockly.Arduino.valueToCode(a,"TIMES",Blockly.Arduino.ORDER_ADDITIVE)||"0",c=Blockly.Arduino.statementToCode(a,"DO"),c=Blockly.Arduino.addLoopTrap(c,a.id);a="";var d=Blockly.Arduino.variableDB_.getDistinctName("count",Blockly.Variables.NAME_TYPE),e=b;b.match(/^\w+$/)||Blockly.isNumber(b)||(e=Blockly.Arduino.variableDB_.getDistinctName("repeat_end",Blockly.Variables.NAME_TYPE),a+="int "+e+" = "+b+";\n");return a+("for (int "+d+" = 0; "+d+" < "+
e+"; "+d+"++) {\n"+c+"}\n")};Blockly.Arduino.controls_whileUntil=function(a){var b="UNTIL"==a.getFieldValue("MODE"),c=Blockly.Arduino.valueToCode(a,"BOOL",b?Blockly.Arduino.ORDER_LOGICAL_OR:Blockly.Arduino.ORDER_NONE)||"false",d=Blockly.Arduino.statementToCode(a,"DO"),d=Blockly.Arduino.addLoopTrap(d,a.id);b&&(c.match(/^\w+$/)||(c="("+c+")"),c="!"+c);return"while ("+c+") {\n"+d+"}\n"};
Blockly.Arduino.controls_for=function(a){var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE),c=Blockly.Arduino.valueToCode(a,"FROM",Blockly.Arduino.ORDER_ASSIGNMENT)||"0",d=Blockly.Arduino.valueToCode(a,"TO",Blockly.Arduino.ORDER_ASSIGNMENT)||"0",e=Blockly.Arduino.valueToCode(a,"BY",Blockly.Arduino.ORDER_ASSIGNMENT)||"1",f=Blockly.Arduino.statementToCode(a,"DO"),f=Blockly.Arduino.addLoopTrap(f,a.id);if(Blockly.isNumber(c)&&Blockly.isNumber(d)&&Blockly.isNumber(e)){var g=
parseFloat(c)<=parseFloat(d);a="for ("+b+" = "+c+"; "+b+(g?" <= ":" >= ")+d+"; "+b;b=Math.abs(parseFloat(e));a=(1==b?a+(g?"++":"--"):a+((g?" += ":" -= ")+b))+(") {\n"+f+"}\n")}else a="",g=c,c.match(/^\w+$/)||Blockly.isNumber(c)||(g=Blockly.Arduino.variableDB_.getDistinctName(b+"_start",Blockly.Variables.NAME_TYPE),a+="int "+g+" = "+c+";\n"),c=d,d.match(/^\w+$/)||Blockly.isNumber(d)||(c=Blockly.Arduino.variableDB_.getDistinctName(b+"_end",Blockly.Variables.NAME_TYPE),a+="int "+c+" = "+d+";\n"),d=Blockly.Arduino.variableDB_.getDistinctName(b+
"_inc",Blockly.Variables.NAME_TYPE),a+="int "+d+" = ",a=Blockly.isNumber(e)?a+(Math.abs(e)+";\n"):a+("abs("+e+");\n"),a=a+("if ("+g+" > "+c+") {\n")+(Blockly.Arduino.INDENT+d+" = -"+d+";\n"),a+="}\n",a+="for ("+b+" = "+g+";\n     "+d+" >= 0 ? "+b+" <= "+c+" : "+b+" >= "+c+";\n     "+b+" += "+d+") {\n"+f+"}\n";return a};Blockly.Arduino.controls_forEach=Blockly.Arduino.noGeneratorCodeLine;
Blockly.Arduino.controls_flow_statements=function(a){switch(a.getFieldValue("FLOW")){case "BREAK":return"break;\n";case "CONTINUE":return"continue;\n"}throw"Unknown flow statement.";};Blockly.Arduino.map={};Blockly.Arduino.base_map=function(a){var b=Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_NONE)||"0";a=Blockly.Arduino.valueToCode(a,"DMAX",Blockly.Arduino.ORDER_ATOMIC)||"0";return["map("+b+", 0, 1024, 0, "+a+")",Blockly.Arduino.ORDER_NONE]};Blockly.Arduino.math={};Blockly.Arduino.math_number=function(a){a=parseFloat(a.getFieldValue("NUM"));Infinity==a?a="INFINITY":-Infinity==a&&(a="-INFINITY");return[a,Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.math_arithmetic=function(a){var b={ADD:[" + ",Blockly.Arduino.ORDER_ADDITIVE],MINUS:[" - ",Blockly.Arduino.ORDER_ADDITIVE],MULTIPLY:[" * ",Blockly.Arduino.ORDER_MULTIPLICATIVE],DIVIDE:[" / ",Blockly.Arduino.ORDER_MULTIPLICATIVE],POWER:[null,Blockly.Arduino.ORDER_NONE]}[a.getFieldValue("OP")],c=b[0],b=b[1],d=Blockly.Arduino.valueToCode(a,"A",b)||"0";a=Blockly.Arduino.valueToCode(a,"B",b)||"0";return c?[d+c+a,b]:["Math.pow("+d+", "+a+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.math_single=function(a){var b=a.getFieldValue("OP"),c;if("NEG"==b)return a=Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_UNARY_PREFIX)||"0","-"==a[0]&&(a=" "+a),["-"+a,Blockly.Arduino.ORDER_UNARY_PREFIX];a="ABS"==b||"ROUND"==b.substring(0,5)?Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_UNARY_POSTFIX)||"0":"SIN"==b||"COS"==b||"TAN"==b?Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0":Blockly.Arduino.valueToCode(a,"NUM",Blockly.Arduino.ORDER_NONE)||
"0";switch(b){case "ABS":c="abs("+a+")";break;case "ROOT":c="sqrt("+a+")";break;case "LN":c="log("+a+")";break;case "EXP":c="exp("+a+")";break;case "POW10":c="pow(10,"+a+")";break;case "ROUND":c="round("+a+")";break;case "ROUNDUP":c="ceil("+a+")";break;case "ROUNDDOWN":c="floor("+a+")";break;case "SIN":c="sin("+a+" / 180 * Math.PI)";break;case "COS":c="cos("+a+" / 180 * Math.PI)";break;case "TAN":c="tan("+a+" / 180 * Math.PI)"}if(c)return[c,Blockly.Arduino.ORDER_UNARY_POSTFIX];switch(b){case "LOG10":c=
"log("+a+") / log(10)";break;case "ASIN":c="asin("+a+") / M_PI * 180";break;case "ACOS":c="acos("+a+") / M_PI * 180";break;case "ATAN":c="atan("+a+") / M_PI * 180";break;default:throw"Unknown math operator: "+b;}return[c,Blockly.Arduino.ORDER_MULTIPLICATIVE]};
Blockly.Arduino.math_constant=function(a){return{PI:["M_PI",Blockly.Arduino.ORDER_UNARY_POSTFIX],E:["M_E",Blockly.Arduino.ORDER_UNARY_POSTFIX],GOLDEN_RATIO:["(1 + sqrt(5)) / 2",Blockly.Arduino.ORDER_MULTIPLICATIVE],SQRT2:["M_SQRT2",Blockly.Arduino.ORDER_UNARY_POSTFIX],SQRT1_2:["M_SQRT1_2",Blockly.Arduino.ORDER_UNARY_POSTFIX],INFINITY:["INFINITY",Blockly.Arduino.ORDER_ATOMIC]}[a.getFieldValue("CONSTANT")]};
Blockly.Arduino.math_number_property=function(a){var b=Blockly.Arduino.valueToCode(a,"NUMBER_TO_CHECK",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0",c=a.getFieldValue("PROPERTY"),d;if("PRIME"==c)return a=Blockly.Arduino.addFunction("mathIsPrime",["boolean "+Blockly.Arduino.DEF_FUNC_NAME+"(int n) {","  // https://en.wikipedia.org/wiki/Primality_test#Naive_methods\n  if (n == 2 || n == 3) {\n    return true;\n  }\n  // False if n is NaN, negative, is 1.\n  // And false if n is divisible by 2 or 3.\n  if (isnan(n) || (n <= 1) || (n == 1) || (n % 2 == 0) || (n % 3 == 0)) {\n    return false;\n  }\n  // Check all the numbers of form 6k +/- 1, up to sqrt(n).\n  for (int x = 6; x <= sqrt(n) + 1; x += 6) {\n    if (n % (x - 1) == 0 || n % (x + 1) == 0) {\n      return false;\n    }\n  }\n  return true;\n}"].join("\n")),
Blockly.Arduino.addInclude("math","#include <math.h>"),[a+"("+b+")",Blockly.Arduino.ORDER_UNARY_POSTFIX];switch(c){case "EVEN":d=b+" % 2 == 0";break;case "ODD":d=b+" % 2 == 1";break;case "WHOLE":Blockly.Arduino.addInclude("math","#include <math.h>");d="(floor("+b+") == "+b+")";break;case "POSITIVE":d=b+" > 0";break;case "NEGATIVE":d=b+" < 0";break;case "DIVISIBLE_BY":a=Blockly.Arduino.valueToCode(a,"DIVISOR",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0",d=b+" % "+a+" == 0"}return[d,Blockly.Arduino.ORDER_EQUALITY]};
Blockly.Arduino.math_change=function(a){var b=Blockly.Arduino.valueToCode(a,"DELTA",Blockly.Arduino.ORDER_ADDITIVE)||"0";return Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE)+" += "+b+";\n"};Blockly.Arduino.math_round=Blockly.Arduino.math_single;Blockly.Arduino.math_trig=Blockly.Arduino.math_single;Blockly.Arduino.math_on_list=Blockly.Arduino.noGeneratorCodeInline;
Blockly.Arduino.math_modulo=function(a){var b=Blockly.Arduino.valueToCode(a,"DIVIDEND",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0";a=Blockly.Arduino.valueToCode(a,"DIVISOR",Blockly.Arduino.ORDER_MULTIPLICATIVE)||"0";return[b+" % "+a,Blockly.Arduino.ORDER_MULTIPLICATIVE]};
Blockly.Arduino.math_constrain=function(a){var b=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_NONE)||"0",c=Blockly.Arduino.valueToCode(a,"LOW",Blockly.Arduino.ORDER_NONE)||"0";a=Blockly.Arduino.valueToCode(a,"HIGH",Blockly.Arduino.ORDER_NONE)||"0";return["("+b+" < "+c+" ? "+c+" : ( "+b+" > "+a+" ? "+a+" : "+b+"))",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.math_random_int=function(a){var b=Blockly.Arduino.valueToCode(a,"FROM",Blockly.Arduino.ORDER_NONE)||"0";a=Blockly.Arduino.valueToCode(a,"TO",Blockly.Arduino.ORDER_NONE)||"0";var c=Blockly.Arduino.variableDB_.getDistinctName("math_random_int",Blockly.Generator.NAME_TYPE);Blockly.Arduino.math_random_int.random_function=c;return[Blockly.Arduino.addFunction("mathRandomInt",["int "+Blockly.Arduino.DEF_FUNC_NAME+"(int min, int max) {","  if (min > max) {\n    // Swap min and max to ensure min is smaller.\n    int temp = min;\n    min = max;\n    max = temp;\n  }\n  return min + (rand() % (max - min + 1));\n}"].join("\n"))+
"("+b+", "+a+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.math_random_float=function(a){return["(rand() / RAND_MAX)",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.procedures={};
Blockly.Arduino.procedures_defreturn=function(a){var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE),c=Blockly.Arduino.statementToCode(a,"STACK");Blockly.Arduino.STATEMENT_PREFIX&&(c=Blockly.Arduino.prefixLines(Blockly.Arduino.STATEMENT_PREFIX.replace(/%1/g,"'"+a.id+"'"),Blockly.Arduino.INDENT)+c);Blockly.Arduino.INFINITE_LOOP_TRAP&&(c=Blockly.Arduino.INFINITE_LOOP_TRAP.replace(/%1/g,"'"+a.id+"'")+c);var d=Blockly.Arduino.valueToCode(a,"RETURN",Blockly.Arduino.ORDER_NONE)||
"";d&&(d="  return "+d+";\n");for(var e=[],f=0;f<a.arguments_.length;f++)e[f]=Blockly.Arduino.getArduinoType_(a.getArgType(a.arguments_[f]))+" "+Blockly.Arduino.variableDB_.getName(a.arguments_[f],Blockly.Variables.NAME_TYPE);f=Blockly.Types.NULL;a.getReturnType&&(f=a.getReturnType());f=Blockly.Arduino.getArduinoType_(f);c=f+" "+b+"("+e.join(", ")+") {\n"+c+d+"}";c=Blockly.Arduino.scrub_(a,c);Blockly.Arduino.userFunctions_[b]=c;return null};Blockly.Arduino.procedures_defnoreturn=Blockly.Arduino.procedures_defreturn;
Blockly.Arduino.procedures_callreturn=function(a){for(var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE),c=[],d=0;d<a.arguments_.length;d++)c[d]=Blockly.Arduino.valueToCode(a,"ARG"+d,Blockly.Arduino.ORDER_NONE)||"null";return[b+"("+c.join(", ")+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.procedures_callnoreturn=function(a){for(var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE),c=[],d=0;d<a.arguments_.length;d++)c[d]=Blockly.Arduino.valueToCode(a,"ARG"+d,Blockly.Arduino.ORDER_NONE)||"null";return b+"("+c.join(", ")+");\n"};
Blockly.Arduino.procedures_ifreturn=function(a){var b="if ("+(Blockly.Arduino.valueToCode(a,"CONDITION",Blockly.Arduino.ORDER_NONE)||"false")+") {\n";a.hasReturnValue_?(a=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_NONE)||"null",b+="  return "+a+";\n"):b+="  return;\n";return b+"}\n"};
Blockly.Arduino.arduino_functions=function(a){var b=Blockly.Arduino.statementToCode(a,"SETUP_FUNC");b&&Blockly.Arduino.addSetup("userSetupCode",b,!0);a=a.getInputTargetBlock("LOOP_FUNC");b=Blockly.Arduino.blockToCode(a);if(!goog.isString(b))throw'Expecting code from statement block "'+a.type+'".';return b};Blockly.Arduino.serial={};Blockly.Arduino.serial_print=function(a){for(var b=a.getFieldValue("SERIAL_ID"),c=Blockly.Arduino.valueToCode(a,"CONTENT",Blockly.Arduino.ORDER_ATOMIC)||"0",d="TRUE"==a.getFieldValue("NEW_LINE"),e=Blockly.Arduino.Boards.selected.serialPins[b],f=0;f<e.length;f++)Blockly.Arduino.reservePin(a,e[f][1],Blockly.Arduino.PinTypes.SERIAL,"SERIAL "+e[f][0]);return d?b+".println("+c+");\n":b+".print("+c+");\n"};
Blockly.Arduino.serial_setup=function(a){var b=a.getFieldValue("SERIAL_ID");a=a.getFieldValue("SPEED");Blockly.Arduino.addSetup("serial_"+b,b+".begin("+a+");",!0);return""};Blockly.Arduino.servo={};Blockly.Arduino.servo_write=function(a){var b=a.getFieldValue("SERVO_PIN"),c=Blockly.Arduino.valueToCode(a,"SERVO_ANGLE",Blockly.Arduino.ORDER_ATOMIC)||"90",d="myServo"+b;Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.SERVO,"Servo Write");Blockly.Arduino.addInclude("servo","#include <Servo.h>");Blockly.Arduino.addDeclaration("servo_"+b,"Servo "+d+";");Blockly.Arduino.addSetup("servo_"+b,d+".attach("+b+");",!0);return d+".write("+c+");\n"};
Blockly.Arduino.servo_read=function(a){var b=a.getFieldValue("SERVO_PIN"),c="myServo"+b;Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.SERVO,"Servo Read");Blockly.Arduino.addInclude("servo","#include <Servo.h>");Blockly.Arduino.addDeclaration("servo_"+b,"Servo "+c+";");Blockly.Arduino.addSetup("servo_"+b,c+".attach("+b+");",!0);return[c+".read()",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.spi={};
Blockly.Arduino.spi_setup=function(a){var b=a.getFieldValue("SPI_ID"),c=a.getFieldValue("SPI_SHIFT_ORDER"),d=a.getFieldValue("SPI_CLOCK_DIVIDE");a=a.getFieldValue("SPI_MODE");Blockly.Arduino.addInclude("spi","#include <SPI.h>");Blockly.Arduino.addSetup("spi_order",b+".setBitOrder("+c+");",!0);Blockly.Arduino.addSetup("spi_mode",b+".setDataMode("+a+");",!0);Blockly.Arduino.addSetup("spi_div",b+".setClockDivider("+d+");",!0);Blockly.Arduino.addSetup("spi_begin",b+".begin();",!0);return""};
Blockly.Arduino.spi_transfer=function(a){var b=a.getFieldValue("SPI_ID"),c=a.getFieldValue("SPI_SS"),d=Blockly.Arduino.valueToCode(a,"SPI_DATA",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.addInclude("spi","#include <SPI.h>");Blockly.Arduino.addSetup("spi_begin",b+".begin();",!1);for(var e=Blockly.Arduino.Boards.selected.spiPins[b],f=0;f<e.length;f++)Blockly.Arduino.reservePin(a,e[f][1],Blockly.Arduino.PinTypes.SPI,"SPI "+e[f][0]);"none"!==c&&(Blockly.Arduino.reservePin(a,c,Blockly.Arduino.PinTypes.OUTPUT,
"SPI Slave pin"),Blockly.Arduino.addSetup("io_"+c,"pinMode("+c+", OUTPUT);",!1));a=[];"none"!==c&&a.push("digitalWrite("+c+", HIGH);");a.push(b+".transfer("+d+");");"none"!==c&&a.push("digitalWrite("+c+", LOW);");return a.join("\n")+"\n"};
Blockly.Arduino.spi_transfer_return=function(a){var b=a.getFieldValue("SPI_ID"),c=a.getFieldValue("SPI_SS"),d=Blockly.Arduino.valueToCode(a,"SPI_DATA",Blockly.Arduino.ORDER_ATOMIC)||"0";Blockly.Arduino.spi_transfer(a);return["none"===c?b+".transfer("+d+")":Blockly.Arduino.addFunction("spiReturnSlave"+c,["int "+Blockly.Arduino.DEF_FUNC_NAME+"() {","  int spiReturn = 0;","  digitalWrite("+c+", HIGH);","  spiReturn = "+b+".transfer("+d+");","  digitalWrite("+c+", LOW);","  return spiReturn;\n}"].join("\n"))+
"()",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.stepper={};
Blockly.Arduino.stepper_config=function(a){var b=a.getFieldValue("STEPPER_PIN1"),c=a.getFieldValue("STEPPER_PIN2"),d=Blockly.Arduino.PinTypes.STEPPER,e=a.getFieldValue("STEPPER_NAME"),f=Blockly.Arduino.valueToCode(a,"STEPPER_STEPS",Blockly.Arduino.ORDER_ATOMIC)||"360",g=Blockly.Arduino.valueToCode(a,"STEPPER_SPEED",Blockly.Arduino.ORDER_ATOMIC)||"90";Blockly.Arduino.addVariable(e,"int "+e+"[2] = {"+b+", "+c+"};",!0);e="stepper_"+e;Blockly.Arduino.reservePin(a,b,d,"Stepper");Blockly.Arduino.reservePin(a,
c,d,"Stepper");Blockly.Arduino.addInclude("stepper","#include <Stepper.h>");Blockly.Arduino.addDeclaration(e,"Stepper "+e+"("+f+", "+b+", "+c+");");Blockly.Arduino.addSetup(e,e+".setSpeed("+g+");",!0);return""};Blockly.Arduino.stepper_step=function(a){var b="stepper_"+a.getFieldValue("STEPPER_NAME");a=Blockly.Arduino.valueToCode(a,"STEPPER_STEPS",Blockly.Arduino.ORDER_ATOMIC)||"0";return b+".step("+a+");\n"};Blockly.Arduino.text={};Blockly.Arduino.text=function(a){return[Blockly.Arduino.quote_(a.getFieldValue("TEXT")),Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.text_join=function(a){var b;if(0==a.itemCount_)return['""',Blockly.Arduino.ORDER_ATOMIC];if(1==a.itemCount_)return["String("+(Blockly.Arduino.valueToCode(a,"ADD0",Blockly.Arduino.ORDER_UNARY_POSTFIX)||'""')+")",Blockly.Arduino.ORDER_UNARY_POSTFIX];var c;b=[];for(var d=0;d<a.itemCount_;d++)c=Blockly.Arduino.valueToCode(a,"ADD"+d,Blockly.Arduino.ORDER_NONE),b[d]=""==c?'""':"String("+c+")";b=b.join(" + ");return[b,Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_append=function(a){var b=Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE);a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_UNARY_POSTFIX);return b+" += "+(""==a?'""':"String("+a+")")+";\n"};Blockly.Arduino.text_length=function(a){return["String("+(Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_UNARY_POSTFIX)||'""')+").length()",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_isEmpty=function(a){var b=[];b.push("boolean "+Blockly.Arduino.DEF_FUNC_NAME+"(String msg) {");b.push("  if (msg.length() == 0) {");b.push("    return true;");b.push("  } else {");b.push("    return false;");b.push("  }");b.push("}");b=Blockly.Arduino.addFunction("isStringEmpty",b.join("\n"));a=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_UNARY_POSTFIX);return[b+"("+(""==a?'""':"String("+a+")")+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_trim=function(a){Blockly.Arduino.text_trim.OPERATORS={LEFT:".trim()",RIGHT:".trim()",BOTH:".trim()"};var b=a.getFieldValue("MODE"),b=Blockly.Arduino.text_trim.OPERATORS[b];a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_UNARY_POSTFIX);return[(""==a?'""':"String("+a+")")+b,Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_print=function(a){var b=Blockly.Arduino.Boards.selected.serial[0][1];Blockly.Arduino.addSetup("serial_"+b,b+".begin(9600);",!1);a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_NONE);return b+".print("+(""==a?'""':"String("+a+")")+");\n"};
Blockly.Arduino.text_prompt_ext=function(a){var b=Blockly.Arduino.Boards.selected.serial[0][1],c=a.getFieldValue("TYPE"),d=[],e=c==Blockly.Types.NUMBER.output;e?d.push("int "+Blockly.Arduino.DEF_FUNC_NAME+"(String msg) {"):d.push("String "+Blockly.Arduino.DEF_FUNC_NAME+"(String msg) {");d.push("  "+b+".println(msg);");d.push("  boolean stringComplete = false;");e?d.push("  int content = 0;"):d.push('  String content = "";');d.push("  while (stringComplete == false) {");d.push("    if ("+b+".available()) {");
e?(d.push("      content = "+b+".parseInt();"),d.push("      stringComplete = true;")):(d.push("      char readChar = (char)"+b+".read();"),d.push("      if (readChar == '\\n' || readChar == '\\r') {"),d.push("        stringComplete = true;"),d.push("      } else {"),d.push("        content += readChar;"),d.push("      }"));d.push("    }");d.push("  }");d.push("  // Empty incoming serial buffer");d.push("  while(Serial.available()) { Serial.read(); };");d.push("  return content;");d.push("}");c=Blockly.Arduino.addFunction("getUserInputPrompt"+
c,d.join("\n"));Blockly.Arduino.addSetup("serial_"+b,b+".begin(9600);",!1);a=Blockly.Arduino.valueToCode(a,"TEXT",Blockly.Arduino.ORDER_NONE)||'""';return[c+"("+a+")",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_endString=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_indexOf=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_charAt=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};
Blockly.Arduino.text_getSubstring=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_changeCase=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.text_prompt=function(a){return["",Blockly.Arduino.ORDER_UNARY_POSTFIX]};Blockly.Arduino.time={};Blockly.Arduino.time_delay=function(a){return"delay("+(Blockly.Arduino.valueToCode(a,"DELAY_TIME_MILI",Blockly.Arduino.ORDER_ATOMIC)||"0")+");\n"};Blockly.Arduino.time_delaymicros=function(a){return"delayMicroseconds("+(Blockly.Arduino.valueToCode(a,"DELAY_TIME_MICRO",Blockly.Arduino.ORDER_ATOMIC)||"0")+");\n"};Blockly.Arduino.time_millis=function(a){return["millis()",Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.time_micros=function(a){return["micros()",Blockly.Arduino.ORDER_ATOMIC]};
Blockly.Arduino.infinite_loop=function(a){return"while(true);\n"};Blockly.Arduino.tone={};Blockly.Arduino.io_tone=function(a){var b=a.getFieldValue("TONEPIN"),c=Blockly.Arduino.valueToCode(a,"FREQUENCY",Blockly.Arduino.ORDER_ATOMIC);Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Tone Pin");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);\n",!1);return"tone("+b+","+c+");\n"};
Blockly.Arduino.io_notone=function(a){var b=a.getFieldValue("TONEPIN");Blockly.Arduino.reservePin(a,b,Blockly.Arduino.PinTypes.OUTPUT,"Tone Pin");Blockly.Arduino.addSetup("io_"+b,"pinMode("+b+", OUTPUT);\n",!1);return"noTone("+b+");\n"};Blockly.Arduino.variables={};Blockly.Arduino.variables_get=function(a){return[Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE),Blockly.Arduino.ORDER_ATOMIC]};Blockly.Arduino.variables_set=function(a){var b=Blockly.Arduino.valueToCode(a,"VALUE",Blockly.Arduino.ORDER_ASSIGNMENT)||"0";return Blockly.Arduino.variableDB_.getName(a.getFieldValue("VAR"),Blockly.Variables.NAME_TYPE)+" = "+b+";\n"};
Blockly.Arduino.variables_set_type=function(a){var b=Blockly.Arduino.valueToCode(a,"VARIABLE_SETTYPE_INPUT",Blockly.Arduino.ORDER_ASSIGNMENT)||"0";return["("+Blockly.Arduino.getArduinoType_(Blockly.Types[a.getFieldValue("VARIABLE_SETTYPE_TYPE")])+")("+b+")",Blockly.Arduino.ORDER_ATOMIC]};